/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.xinclude;

import com.sun.org.apache.xerces.internal.impl.Constants;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.util.AugmentationsImpl;
import com.sun.org.apache.xerces.internal.util.IntStack;
import com.sun.org.apache.xerces.internal.util.ParserConfigurationSettings;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.URI;
import com.sun.org.apache.xerces.internal.util.XMLAttributesImpl;
import com.sun.org.apache.xerces.internal.util.XMLResourceIdentifierImpl;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xinclude.ObjectFactory;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeInputSource;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeMessageFormatter;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeNamespaceSupport;
import com.sun.org.apache.xerces.internal.xinclude.XPointerFramework;
import com.sun.org.apache.xerces.internal.xinclude.XPointerSchema;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLDTDHandler;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDTDFilter;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDTDSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentFilter;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class XIncludeHandler
implements XMLComponent,
XMLDocumentFilter,
XMLDTDFilter {
    public static final String XPOINTER_DEFAULT_CONFIGURATION = "com.sun.org.apache.xerces.internal.parsers.XPointerParserConfiguration";
    protected static final String XPOINTER_SCHEMA = "http://apache.org/xml/properties/xpointer-schema";
    protected static final String XINCLUDE_AWARE = "http://apache.org/xml/features/xinclude-aware";
    public static final String XINCLUDE_DEFAULT_CONFIGURATION = "com.sun.org.apache.xerces.internal.parsers.XIncludeParserConfiguration";
    public static final String HTTP_ACCEPT = "Accept";
    public static final String HTTP_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HTTP_ACCEPT_CHARSET = "Accept-Charset";
    public static final String XPOINTER = "xpointer";
    public static final String XINCLUDE_NS_URI = "http://www.w3.org/2001/XInclude".intern();
    public static final String XINCLUDE_INCLUDE = "include".intern();
    public static final String XINCLUDE_FALLBACK = "fallback".intern();
    public static final String XINCLUDE_PARSE_XML = "xml".intern();
    public static final String XINCLUDE_PARSE_TEXT = "text".intern();
    public static final String XINCLUDE_ATTR_HREF = "href".intern();
    public static final String XINCLUDE_ATTR_PARSE = "parse".intern();
    public static final String XINCLUDE_ATTR_ENCODING = "encoding".intern();
    public static final String XINCLUDE_ATTR_ACCEPT = "accept".intern();
    public static final String XINCLUDE_ATTR_ACCEPT_LANGUAGE = "accept-language".intern();
    public static final String XINCLUDE_ATTR_ACCEPT_CHARSET = "accept-charset".intern();
    public static final String XINCLUDE_INCLUDED = "[included]".intern();
    public static final String CURRENT_BASE_URI = "currentBaseURI";
    public static final String XINCLUDE_BASE = "base";
    public static final QName XML_BASE_QNAME = new QName(XMLSymbols.PREFIX_XML, "base", XMLSymbols.PREFIX_XML + ":" + "base", NamespaceContext.XML_URI);
    public static final QName NEW_NS_ATTR_QNAME = new QName(XMLSymbols.PREFIX_XMLNS, "", XMLSymbols.PREFIX_XMLNS + ":", NamespaceContext.XMLNS_URI);
    private static final int STATE_NORMAL_PROCESSING = 1;
    private static final int STATE_IGNORE = 2;
    private static final int STATE_EXPECT_FALLBACK = 3;
    protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/allow-dtd-events-after-endDTD"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/xpointer-schema"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null};
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected XPointerFramework fXPointerFramework = null;
    protected XPointerSchema[] fXPointerSchema;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDSource fDTDSource;
    protected XIncludeHandler fParentXIncludeHandler;
    protected String fParentRelativeURI;
    protected XMLParserConfiguration fChildConfig;
    protected XMLLocator fDocLocation;
    protected XIncludeNamespaceSupport fNamespaceContext;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected SecurityManager fSecurityManager;
    protected XMLResourceIdentifier fCurrentBaseURI;
    protected IntStack baseURIScope;
    protected Stack baseURI;
    protected Stack literalSystemID;
    protected Stack expandedSystemID;
    protected ParserConfigurationSettings fSettings;
    private int fDepth = 0;
    private static final int INITIAL_SIZE = 8;
    private boolean[] fSawInclude = new boolean[8];
    private boolean[] fSawFallback = new boolean[8];
    private int[] fState = new int[8];
    private Vector fNotations;
    private Vector fUnparsedEntities;
    private boolean fSendUEAndNotationEvents;
    private boolean fIsXML11;
    private boolean fInDTD;

    public XIncludeHandler() {
        this.fSawFallback[this.fDepth] = false;
        this.fSawInclude[this.fDepth] = false;
        this.fState[this.fDepth] = 1;
        this.fNotations = new Vector();
        this.fUnparsedEntities = new Vector();
        this.baseURIScope = new IntStack();
        this.baseURI = new Stack();
        this.literalSystemID = new Stack();
        this.expandedSystemID = new Stack();
        this.fCurrentBaseURI = new XMLResourceIdentifierImpl();
    }

    public void reset(XMLComponentManager componentManager) throws XNIException {
        Object value;
        int i;
        this.fNamespaceContext = null;
        this.fDepth = 0;
        this.fNotations = new Vector();
        this.fUnparsedEntities = new Vector();
        this.fParentRelativeURI = null;
        this.fIsXML11 = false;
        this.fInDTD = false;
        this.baseURIScope.clear();
        this.baseURI.clear();
        this.literalSystemID.clear();
        this.expandedSystemID.clear();
        for (i = 0; i < this.fState.length; ++i) {
            this.fState[i] = 1;
        }
        for (i = 0; i < this.fSawFallback.length; ++i) {
            this.fSawFallback[i] = false;
        }
        for (i = 0; i < this.fSawInclude.length; ++i) {
            this.fSawInclude[i] = false;
        }
        try {
            this.fSendUEAndNotationEvents = componentManager.getFeature(ALLOW_UE_AND_NOTATION_EVENTS);
            if (this.fChildConfig != null) {
                this.fChildConfig.setFeature(ALLOW_UE_AND_NOTATION_EVENTS, this.fSendUEAndNotationEvents);
            }
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            value = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
            if (value != null) {
                this.setErrorReporter((XMLErrorReporter)value);
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ERROR_REPORTER, value);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.fErrorReporter = null;
        }
        try {
            value = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
            if (value != null) {
                this.fEntityResolver = value;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ENTITY_RESOLVER, value);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.fEntityResolver = null;
        }
        try {
            this.fXPointerSchema = (XPointerSchema[])componentManager.getProperty(XPOINTER_SCHEMA);
        }
        catch (XMLConfigurationException e) {
            this.fXPointerSchema = null;
        }
        try {
            value = (SecurityManager)componentManager.getProperty(SECURITY_MANAGER);
            if (value != null) {
                this.fSecurityManager = value;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(SECURITY_MANAGER, value);
                }
            }
        }
        catch (XMLConfigurationException e) {
            this.fSecurityManager = null;
        }
        this.fSettings = new ParserConfigurationSettings();
        this.copyFeatures(componentManager, this.fSettings);
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        if (featureId.equals(ALLOW_UE_AND_NOTATION_EVENTS)) {
            this.fSendUEAndNotationEvents = state;
        }
        if (this.fSettings != null) {
            this.fSettings.setFeature(featureId, state);
        }
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.equals(ERROR_REPORTER)) {
            this.setErrorReporter((XMLErrorReporter)value);
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
        }
        if (propertyId.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)value;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
        }
        if (propertyId.equals(SECURITY_MANAGER)) {
            this.fSecurityManager = (SecurityManager)value;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(propertyId, value);
            }
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.fDocumentHandler = handler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        if (this.fErrorReporter != null) {
            this.fErrorReporter.setDocumentLocator(locator);
        }
        if (!this.isRootDocument() && this.fParentXIncludeHandler.searchForRecursiveIncludes(locator)) {
            this.reportFatalError("RecursiveInclude", new Object[]{locator.getExpandedSystemId()});
        }
        if (!(namespaceContext instanceof XIncludeNamespaceSupport)) {
            this.reportFatalError("IncompatibleNamespaceContext");
        }
        this.fNamespaceContext = (XIncludeNamespaceSupport)namespaceContext;
        this.fDocLocation = locator;
        this.fCurrentBaseURI.setBaseSystemId(locator.getBaseSystemId());
        this.fCurrentBaseURI.setExpandedSystemId(locator.getExpandedSystemId());
        this.fCurrentBaseURI.setLiteralSystemId(locator.getLiteralSystemId());
        this.saveBaseURI();
        if (augs == null) {
            augs = new AugmentationsImpl();
        }
        augs.putItem(CURRENT_BASE_URI, this.fCurrentBaseURI);
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(locator, encoding, namespaceContext, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        this.fIsXML11 = "1.1".equals(version);
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fInDTD) {
            if (this.fDocumentHandler != null && this.getState() == 1) {
                ++this.fDepth;
                augs = this.modifyAugmentations(augs);
                this.fDocumentHandler.comment(text, augs);
                --this.fDepth;
            }
        } else if (this.fDTDHandler != null) {
            this.fDTDHandler.comment(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (!this.fInDTD) {
            if (this.fDocumentHandler != null && this.getState() == 1) {
                ++this.fDepth;
                augs = this.modifyAugmentations(augs);
                this.fDocumentHandler.processingInstruction(target, data, augs);
                --this.fDepth;
            }
        } else if (this.fDTDHandler != null) {
            this.fDTDHandler.processingInstruction(target, data, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        ++this.fDepth;
        this.setState(this.getState(this.fDepth - 1));
        this.processXMLBaseAttributes(attributes);
        if (this.isIncludeElement(element)) {
            boolean success = this.handleIncludeElement(attributes);
            if (success) {
                this.setState(2);
            } else {
                this.setState(3);
            }
        } else if (this.isFallbackElement(element)) {
            this.handleFallbackElement();
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            augs = this.modifyAugmentations(augs);
            attributes = this.processAttributes(attributes);
            this.fDocumentHandler.startElement(element, attributes, augs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        ++this.fDepth;
        this.setState(this.getState(this.fDepth - 1));
        this.processXMLBaseAttributes(attributes);
        if (this.isIncludeElement(element)) {
            boolean success = this.handleIncludeElement(attributes);
            if (success) {
                this.setState(2);
            } else {
                this.reportFatalError("NoFallback");
            }
        } else if (this.isFallbackElement(element)) {
            this.handleFallbackElement();
        } else if (this.hasXIncludeNamespace(element)) {
            if (this.getSawInclude(this.fDepth - 1)) {
                this.reportFatalError("IncludeChild", new Object[]{element.rawname});
            }
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            augs = this.modifyAugmentations(augs);
            attributes = this.processAttributes(attributes);
            this.fDocumentHandler.emptyElement(element, attributes, augs);
        }
        this.setSawFallback(this.fDepth + 1, false);
        this.setSawInclude(this.fDepth + 1, false);
        if (this.baseURIScope.size() > 0 && this.fDepth == this.baseURIScope.peek()) {
            this.restoreBaseURI();
        }
        --this.fDepth;
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.isIncludeElement(element) && this.getState() == 3 && !this.getSawFallback(this.fDepth + 1)) {
            this.reportFatalError("NoFallback");
        }
        if (this.isFallbackElement(element)) {
            if (this.getState() == 1) {
                this.setState(2);
            }
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endElement(element, augs);
        }
        this.setSawFallback(this.fDepth + 1, false);
        this.setSawInclude(this.fDepth + 1, false);
        if (this.baseURIScope.size() > 0 && this.fDepth == this.baseURIScope.peek()) {
            this.restoreBaseURI();
        }
        --this.fDepth;
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier resId, String encoding, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.startGeneralEntity(name, resId, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endGeneralEntity(name, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            ++this.fDepth;
            augs = this.modifyAugmentations(augs);
            this.fDocumentHandler.characters(text, augs);
            --this.fDepth;
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.ignorableWhitespace(text, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endCDATA(augs);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augs);
        }
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.fDocumentSource = source;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue, nonNormalizedDefaultValue, augmentations);
        }
    }

    public void elementDecl(String name, String contentModel, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.elementDecl(name, contentModel, augmentations);
        }
    }

    public void endAttlist(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endAttlist(augmentations);
        }
    }

    public void endConditional(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endConditional(augmentations);
        }
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endDTD(augmentations);
        }
        this.fInDTD = false;
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endExternalSubset(augmentations);
        }
    }

    public void endParameterEntity(String name, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endParameterEntity(name, augmentations);
        }
    }

    public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.externalEntityDecl(name, identifier, augmentations);
        }
    }

    public XMLDTDSource getDTDSource() {
        return this.fDTDSource;
    }

    public void ignoredCharacters(XMLString text, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.ignoredCharacters(text, augmentations);
        }
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.internalEntityDecl(name, text, nonNormalizedText, augmentations);
        }
    }

    public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
        this.addNotation(name, identifier, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(name, identifier, augmentations);
        }
    }

    public void setDTDSource(XMLDTDSource source) {
        this.fDTDSource = source;
    }

    public void startAttlist(String elementName, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startAttlist(elementName, augmentations);
        }
    }

    public void startConditional(short type, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startConditional(type, augmentations);
        }
    }

    public void startDTD(XMLLocator locator, Augmentations augmentations) throws XNIException {
        this.fInDTD = true;
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(locator, augmentations);
        }
    }

    public void startExternalSubset(XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startExternalSubset(identifier, augmentations);
        }
    }

    public void startParameterEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startParameterEntity(name, identifier, encoding, augmentations);
        }
    }

    public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier, String notation, Augmentations augmentations) throws XNIException {
        this.addUnparsedEntity(name, identifier, notation, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.unparsedEntityDecl(name, identifier, notation, augmentations);
        }
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDHandler(XMLDTDHandler handler) {
        this.fDTDHandler = handler;
    }

    private void setErrorReporter(XMLErrorReporter reporter) {
        this.fErrorReporter = reporter;
        if (this.fErrorReporter != null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xinclude", new XIncludeMessageFormatter());
            if (this.fDocLocation != null) {
                this.fErrorReporter.setDocumentLocator(this.fDocLocation);
            }
        }
    }

    protected void handleFallbackElement() {
        this.setSawInclude(this.fDepth, false);
        this.fNamespaceContext.setContextInvalid();
        if (!this.getSawInclude(this.fDepth - 1)) {
            this.reportFatalError("FallbackParent");
        }
        if (this.getSawFallback(this.fDepth)) {
            this.reportFatalError("MultipleFallbacks");
        } else {
            this.setSawFallback(this.fDepth, true);
        }
        if (this.getState() == 3) {
            this.setState(1);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean handleIncludeElement(XMLAttributes attributes) throws XNIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean hasXIncludeNamespace(QName element) {
        return element.uri == XINCLUDE_NS_URI || this.fNamespaceContext.getURI(element.prefix) == XINCLUDE_NS_URI;
    }

    protected boolean isIncludeElement(QName element) {
        return element.localpart.equals(XINCLUDE_INCLUDE) && this.hasXIncludeNamespace(element);
    }

    protected boolean isFallbackElement(QName element) {
        return element.localpart.equals(XINCLUDE_FALLBACK) && this.hasXIncludeNamespace(element);
    }

    protected boolean sameBaseURIAsIncludeParent() {
        String parentBaseURI = this.getIncludeParentBaseURI();
        String baseURI = this.fCurrentBaseURI.getExpandedSystemId();
        return parentBaseURI != null && parentBaseURI.equals(baseURI);
    }

    protected boolean searchForRecursiveIncludes(XMLLocator includedSource) {
        String includedSystemId = includedSource.getExpandedSystemId();
        if (includedSystemId == null) {
            try {
                includedSystemId = XMLEntityManager.expandSystemId(includedSource.getLiteralSystemId(), includedSource.getBaseSystemId(), false);
            }
            catch (URI.MalformedURIException e) {
                this.reportFatalError("ExpandedSystemId");
            }
        }
        if (includedSystemId.equals(this.fCurrentBaseURI.getExpandedSystemId())) {
            return true;
        }
        if (this.fParentXIncludeHandler == null) {
            return false;
        }
        return this.fParentXIncludeHandler.searchForRecursiveIncludes(includedSource);
    }

    protected boolean isTopLevelIncludedItem() {
        return this.isTopLevelIncludedItemViaInclude() || this.isTopLevelIncludedItemViaFallback();
    }

    protected boolean isTopLevelIncludedItemViaInclude() {
        return this.fDepth == 1 && !this.isRootDocument();
    }

    protected boolean isTopLevelIncludedItemViaFallback() {
        return this.getSawFallback(this.fDepth - 1);
    }

    protected XMLAttributes processAttributes(XMLAttributes attributes) {
        if (this.isTopLevelIncludedItem()) {
            if (!this.sameBaseURIAsIncludeParent()) {
                if (attributes == null) {
                    attributes = new XMLAttributesImpl();
                }
                String uri = null;
                try {
                    uri = this.getRelativeBaseURI();
                }
                catch (URI.MalformedURIException e) {
                    uri = this.fCurrentBaseURI.getExpandedSystemId();
                }
                int index = attributes.addAttribute(XML_BASE_QNAME, XMLSymbols.fCDATASymbol, uri);
                attributes.setSpecified(index, true);
            }
            Enumeration inscopeNS = this.fNamespaceContext.getAllPrefixes();
            while (inscopeNS.hasMoreElements()) {
                QName ns;
                String uri;
                String prefix = (String)inscopeNS.nextElement();
                String parentURI = this.fNamespaceContext.getURIFromIncludeParent(prefix);
                if (parentURI == (uri = this.fNamespaceContext.getURI(prefix)) || attributes == null) continue;
                if (prefix == XMLSymbols.EMPTY_STRING) {
                    if (attributes.getValue(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS) != null) continue;
                    if (attributes == null) {
                        attributes = new XMLAttributesImpl();
                    }
                    ns = (QName)NEW_NS_ATTR_QNAME.clone();
                    ns.localpart = XMLSymbols.PREFIX_XMLNS;
                    ns.rawname = XMLSymbols.PREFIX_XMLNS;
                    attributes.addAttribute(ns, XMLSymbols.fCDATASymbol, uri);
                    continue;
                }
                if (attributes.getValue(NamespaceContext.XMLNS_URI, prefix) != null) continue;
                if (attributes == null) {
                    attributes = new XMLAttributesImpl();
                }
                ns = (QName)NEW_NS_ATTR_QNAME.clone();
                ns.localpart = prefix;
                ns.rawname = ns.rawname + prefix;
                attributes.addAttribute(ns, XMLSymbols.fCDATASymbol, uri);
            }
        }
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String type = attributes.getType(i);
                String value = attributes.getValue(i);
                if (type == XMLSymbols.fENTITYSymbol) {
                    this.checkUnparsedEntity(value);
                }
                if (type == XMLSymbols.fENTITIESSymbol) {
                    StringTokenizer st = new StringTokenizer(value);
                    while (st.hasMoreTokens()) {
                        String entName = st.nextToken();
                        this.checkUnparsedEntity(entName);
                    }
                    continue;
                }
                if (type != XMLSymbols.fNOTATIONSymbol) continue;
                this.checkNotation(value);
            }
        }
        return attributes;
    }

    protected String getRelativeBaseURI() throws URI.MalformedURIException {
        int includeParentDepth = this.getIncludeParentDepth();
        String relativeURI = this.getRelativeURI(includeParentDepth);
        if (this.isRootDocument()) {
            return relativeURI;
        }
        if (relativeURI.equals("")) {
            relativeURI = this.fCurrentBaseURI.getLiteralSystemId();
        }
        if (includeParentDepth == 0) {
            if (this.fParentRelativeURI == null) {
                this.fParentRelativeURI = this.fParentXIncludeHandler.getRelativeBaseURI();
            }
            if (this.fParentRelativeURI.equals("")) {
                return relativeURI;
            }
            URI uri = new URI("file", this.fParentRelativeURI);
            uri = new URI(uri, relativeURI);
            return uri.getPath();
        }
        return relativeURI;
    }

    private String getIncludeParentBaseURI() {
        int depth = this.getIncludeParentDepth();
        if (!this.isRootDocument() && depth == 0) {
            return this.fParentXIncludeHandler.getIncludeParentBaseURI();
        }
        return this.getBaseURI(depth);
    }

    private int getIncludeParentDepth() {
        for (int i = this.fDepth - 1; i >= 0; --i) {
            if (this.getSawInclude(i) || this.getSawFallback(i)) continue;
            return i;
        }
        return 0;
    }

    protected Augmentations modifyAugmentations(Augmentations augs) {
        return this.modifyAugmentations(augs, false);
    }

    protected Augmentations modifyAugmentations(Augmentations augs, boolean force) {
        if (force || this.isTopLevelIncludedItem()) {
            if (augs == null) {
                augs = new AugmentationsImpl();
            }
            augs.putItem(XINCLUDE_INCLUDED, Boolean.TRUE);
        }
        return augs;
    }

    protected int getState(int depth) {
        return this.fState[depth];
    }

    protected int getState() {
        return this.fState[this.fDepth];
    }

    protected void setState(int state) {
        if (this.fDepth >= this.fState.length) {
            int[] newarray = new int[this.fDepth * 2];
            System.arraycopy(this.fState, 0, newarray, 0, this.fState.length);
            this.fState = newarray;
        }
        this.fState[this.fDepth] = state;
    }

    protected void setSawFallback(int depth, boolean val) {
        if (depth >= this.fSawFallback.length) {
            boolean[] newarray = new boolean[depth * 2];
            System.arraycopy(this.fSawFallback, 0, newarray, 0, this.fSawFallback.length);
            this.fSawFallback = newarray;
        }
        this.fSawFallback[depth] = val;
    }

    protected boolean getSawFallback(int depth) {
        if (depth >= this.fSawFallback.length) {
            return false;
        }
        return this.fSawFallback[depth];
    }

    protected void setSawInclude(int depth, boolean val) {
        if (depth >= this.fSawInclude.length) {
            boolean[] newarray = new boolean[depth * 2];
            System.arraycopy(this.fSawInclude, 0, newarray, 0, this.fSawInclude.length);
            this.fSawInclude = newarray;
        }
        this.fSawInclude[depth] = val;
    }

    protected boolean getSawInclude(int depth) {
        if (depth >= this.fSawInclude.length) {
            return false;
        }
        return this.fSawInclude[depth];
    }

    protected void reportResourceError(String key) {
        this.reportFatalError(key, null);
    }

    protected void reportResourceError(String key, Object[] args) {
        this.reportError(key, args, (short)0);
    }

    protected void reportFatalError(String key) {
        this.reportFatalError(key, null);
    }

    protected void reportFatalError(String key, Object[] args) {
        this.reportError(key, args, (short)2);
    }

    private void reportError(String key, Object[] args, short severity) {
        if (this.fErrorReporter != null) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xinclude", key, args, severity);
        }
    }

    protected void setParent(XIncludeHandler parent) {
        this.fParentXIncludeHandler = parent;
    }

    protected boolean isRootDocument() {
        return this.fParentXIncludeHandler == null;
    }

    protected void addUnparsedEntity(String name, XMLResourceIdentifier identifier, String notation, Augmentations augmentations) {
        UnparsedEntity ent = new UnparsedEntity();
        ent.name = name;
        ent.systemId = identifier.getLiteralSystemId();
        ent.publicId = identifier.getPublicId();
        ent.baseURI = identifier.getBaseSystemId();
        ent.notation = notation;
        ent.augmentations = augmentations;
        this.fUnparsedEntities.add(ent);
    }

    protected void addNotation(String name, XMLResourceIdentifier identifier, Augmentations augmentations) {
        Notation not = new Notation();
        not.name = name;
        not.systemId = identifier.getLiteralSystemId();
        not.publicId = identifier.getPublicId();
        not.baseURI = identifier.getBaseSystemId();
        not.augmentations = augmentations;
        this.fNotations.add(not);
    }

    protected void checkUnparsedEntity(String entName) {
        UnparsedEntity ent = new UnparsedEntity();
        ent.name = entName;
        int index = this.fUnparsedEntities.indexOf(ent);
        if (index != -1) {
            ent = (UnparsedEntity)this.fUnparsedEntities.get(index);
            this.checkNotation(ent.notation);
            this.checkAndSendUnparsedEntity(ent);
        }
    }

    protected void checkNotation(String notName) {
        Notation not = new Notation();
        not.name = notName;
        int index = this.fNotations.indexOf(not);
        if (index != -1) {
            not = (Notation)this.fNotations.get(index);
            this.checkAndSendNotation(not);
        }
    }

    protected void checkAndSendUnparsedEntity(UnparsedEntity ent) {
        if (this.isRootDocument()) {
            int index = this.fUnparsedEntities.indexOf(ent);
            if (index == -1) {
                XMLResourceIdentifierImpl id = new XMLResourceIdentifierImpl(ent.publicId, ent.systemId, ent.baseURI, null);
                this.addUnparsedEntity(ent.name, id, ent.notation, ent.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.unparsedEntityDecl(ent.name, id, ent.notation, ent.augmentations);
                }
            } else {
                UnparsedEntity localEntity = (UnparsedEntity)this.fUnparsedEntities.get(index);
                if (!ent.isDuplicate(localEntity)) {
                    this.reportFatalError("NonDuplicateUnparsedEntity", new Object[]{ent.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendUnparsedEntity(ent);
        }
    }

    protected void checkAndSendNotation(Notation not) {
        if (this.isRootDocument()) {
            int index = this.fNotations.indexOf(not);
            if (index == -1) {
                XMLResourceIdentifierImpl id = new XMLResourceIdentifierImpl(not.publicId, not.systemId, not.baseURI, null);
                this.addNotation(not.name, id, not.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.notationDecl(not.name, id, not.augmentations);
                }
            } else {
                Notation localNotation = (Notation)this.fNotations.get(index);
                if (!not.isDuplicate(localNotation)) {
                    this.reportFatalError("NonDuplicateNotation", new Object[]{not.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendNotation(not);
        }
    }

    protected void copyFeatures(XMLComponentManager from, ParserConfigurationSettings to) {
        Enumeration features = Constants.getXercesFeatures();
        this.copyFeatures1(features, "http://apache.org/xml/features/", from, to);
        features = Constants.getSAXFeatures();
        this.copyFeatures1(features, "http://xml.org/sax/features/", from, to);
    }

    protected void copyFeatures(XMLComponentManager from, XMLParserConfiguration to) {
        Enumeration features = Constants.getXercesFeatures();
        this.copyFeatures1(features, "http://apache.org/xml/features/", from, to);
        features = Constants.getSAXFeatures();
        this.copyFeatures1(features, "http://xml.org/sax/features/", from, to);
    }

    private void copyFeatures1(Enumeration features, String featurePrefix, XMLComponentManager from, ParserConfigurationSettings to) {
        while (features.hasMoreElements()) {
            String featureId = featurePrefix + (String)features.nextElement();
            to.addRecognizedFeatures(new String[]{featureId});
            try {
                to.setFeature(featureId, from.getFeature(featureId));
            }
            catch (XMLConfigurationException e) {}
        }
    }

    private void copyFeatures1(Enumeration features, String featurePrefix, XMLComponentManager from, XMLParserConfiguration to) {
        while (features.hasMoreElements()) {
            String featureId = featurePrefix + (String)features.nextElement();
            boolean value = from.getFeature(featureId);
            try {
                to.setFeature(featureId, value);
            }
            catch (XMLConfigurationException e) {}
        }
    }

    protected void saveBaseURI() {
        this.baseURIScope.push(this.fDepth);
        this.baseURI.push(this.fCurrentBaseURI.getBaseSystemId());
        this.literalSystemID.push(this.fCurrentBaseURI.getLiteralSystemId());
        this.expandedSystemID.push(this.fCurrentBaseURI.getExpandedSystemId());
    }

    protected void restoreBaseURI() {
        this.baseURI.pop();
        this.literalSystemID.pop();
        this.expandedSystemID.pop();
        this.baseURIScope.pop();
        this.fCurrentBaseURI.setBaseSystemId((String)this.baseURI.peek());
        this.fCurrentBaseURI.setLiteralSystemId((String)this.literalSystemID.peek());
        this.fCurrentBaseURI.setExpandedSystemId((String)this.expandedSystemID.peek());
    }

    public String getBaseURI(int depth) {
        int scope = this.scopeOf(depth);
        return (String)this.expandedSystemID.elementAt(scope);
    }

    public String getRelativeURI(int depth) throws URI.MalformedURIException {
        int start = this.scopeOf(depth) + 1;
        if (start == this.baseURIScope.size()) {
            return "";
        }
        URI uri = new URI("file", (String)this.literalSystemID.elementAt(start));
        for (int i = start + 1; i < this.baseURIScope.size(); ++i) {
            uri = new URI(uri, (String)this.literalSystemID.elementAt(i));
        }
        return uri.getPath();
    }

    private int scopeOf(int depth) {
        for (int i = this.baseURIScope.size() - 1; i >= 0; --i) {
            if (this.baseURIScope.elementAt(i) > depth) continue;
            return i;
        }
        return -1;
    }

    protected void processXMLBaseAttributes(XMLAttributes attributes) {
        String baseURIValue = attributes.getValue(NamespaceContext.XML_URI, XINCLUDE_BASE);
        if (baseURIValue != null) {
            try {
                String expandedValue = XMLEntityManager.expandSystemId(baseURIValue, this.fCurrentBaseURI.getExpandedSystemId(), false);
                this.fCurrentBaseURI.setLiteralSystemId(baseURIValue);
                this.fCurrentBaseURI.setBaseSystemId(this.fCurrentBaseURI.getExpandedSystemId());
                this.fCurrentBaseURI.setExpandedSystemId(expandedValue);
                this.saveBaseURI();
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
        }
    }

    protected XMLInputSource setHttpProperties(XMLInputSource source, XMLAttributes attributes) throws IOException {
        String httpAcceptLang = attributes.getValue(HTTP_ACCEPT_LANGUAGE);
        String httpAccept = attributes.getValue(HTTP_ACCEPT);
        String httpAcceptchar = attributes.getValue(HTTP_ACCEPT_CHARSET);
        if (source.getCharacterStream() == null && source.getByteStream() == null) {
            XIncludeInputSource includeSource = new XIncludeInputSource(source.getPublicId(), source.getSystemId(), source.getBaseSystemId(), source.getByteStream(), source.getEncoding());
            includeSource.setProperty(XINCLUDE_ATTR_ACCEPT, attributes.getValue(XINCLUDE_ATTR_ACCEPT));
            includeSource.setProperty(XINCLUDE_ATTR_ACCEPT_CHARSET, attributes.getValue(XINCLUDE_ATTR_ACCEPT_CHARSET));
            includeSource.setProperty(XINCLUDE_ATTR_ACCEPT_LANGUAGE, attributes.getValue(XINCLUDE_ATTR_ACCEPT_LANGUAGE));
        }
        return source;
    }

    public boolean processSchema(XPointerSchema fXPointerSchemaS, XMLInputSource includedSource) {
        try {
            this.fChildConfig = this.createXPointerParser();
            this.fChildConfig.setProperty("http://apache.org/xml/properties/internal/xinclude-handler", fXPointerSchemaS);
            fXPointerSchemaS.setParent(this);
            fXPointerSchemaS.setDocumentHandler(this.getDocumentHandler());
            this.fChildConfig.parse(includedSource);
        }
        catch (Exception e) {
            this.reportResourceError("XMLResourceError", new Object[]{null, e.getMessage()});
        }
        return fXPointerSchemaS.isSubResourceIndentified();
    }

    private boolean isValidInHTTPHeader(String value) {
        for (int i = value.length() - 1; i >= 0; --i) {
            char ch = value.charAt(i);
            if (ch >= ' ' && ch <= '~') continue;
            return false;
        }
        return true;
    }

    protected XMLParserConfiguration createXPointerParser() {
        XMLParserConfiguration childConfig = (XMLParserConfiguration)ObjectFactory.newInstance(XPOINTER_DEFAULT_CONFIGURATION, ObjectFactory.findClassLoader(), true);
        childConfig.setProperty(ERROR_REPORTER, this.fErrorReporter);
        childConfig.setProperty("http://apache.org/xml/properties/internal/namespace-context", this.fNamespaceContext);
        this.copyFeatures((XMLComponentManager)this.fSettings, childConfig);
        return childConfig;
    }

    protected class UnparsedEntity {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public String notation;
        public Augmentations augmentations;

        protected UnparsedEntity() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof UnparsedEntity) {
                UnparsedEntity other = (UnparsedEntity)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        public boolean isDuplicate(Object obj) {
            if (obj != null && obj instanceof UnparsedEntity) {
                UnparsedEntity other = (UnparsedEntity)obj;
                return this.name.equals(other.name) && (this.systemId == other.systemId || this.systemId != null && this.systemId.equals(other.systemId)) && (this.publicId == other.publicId || this.publicId != null && this.publicId.equals(other.publicId)) && (this.baseURI == other.baseURI || this.baseURI != null && this.baseURI.equals(other.baseURI)) && (this.notation == other.notation || this.notation != null && this.notation.equals(other.notation));
            }
            return false;
        }
    }

    protected class Notation {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public Augmentations augmentations;

        protected Notation() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Notation) {
                Notation other = (Notation)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        public boolean isDuplicate(Object obj) {
            if (obj != null && obj instanceof Notation) {
                Notation other = (Notation)obj;
                return this.name.equals(other.name) && (this.systemId == other.systemId || this.systemId != null && this.systemId.equals(other.systemId)) && (this.publicId == other.publicId || this.publicId != null && this.publicId.equals(other.publicId)) && (this.baseURI == other.baseURI || this.baseURI != null && this.baseURI.equals(other.baseURI));
            }
            return false;
        }
    }
}

