/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XML11Char;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xml.internal.serialize.ElementState;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.xml.sax.SAXException;

public class XML11Serializer
extends XMLSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    private boolean fPreserveSpace;

    public XML11Serializer() {
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputFormat format) {
        super(format);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(Writer writer, OutputFormat format) {
        super(writer, format);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputStream output, OutputFormat format) {
        super(output, format != null ? format : new OutputFormat("xml", null, false));
        this._format.setVersion("1.1");
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            ElementState state = this.content();
            if (state.inCData || state.doCData) {
                if (!state.inCData) {
                    this._printer.printText("<![CDATA[");
                    state.inCData = true;
                }
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                for (int index = start; index < length; ++index) {
                    char ch = chars[index];
                    if (ch == ']' && index + 2 < length && chars[index + 1] == ']' && chars[index + 2] == '>') {
                        this._printer.printText("]]]]><![CDATA[>");
                        index += 2;
                        continue;
                    }
                    if (!XML11Char.isXML11Valid(ch)) {
                        if (++index < length) {
                            this.surrogates(ch, chars[index]);
                            continue;
                        }
                        this.fatalError("The character '" + ch + "' is an invalid XML character");
                        continue;
                    }
                    if (this._encodingInfo.isPrintable(ch) && XML11Char.isXML11ValidLiteral(ch)) {
                        this._printer.printText(ch);
                        continue;
                    }
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(ch));
                    this._printer.printText(";<![CDATA[");
                }
                this._printer.setNextIndent(saveIndent);
            } else if (state.preserveSpace) {
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(chars, start, length, true, state.unescaped);
                this._printer.setNextIndent(saveIndent);
            } else {
                this.printText(chars, start, length, false, state.unescaped);
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    protected void printEscaped(String source) throws IOException {
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (!XML11Char.isXML11Valid(ch)) {
                if (++i < length) {
                    this.surrogates(ch, source.charAt(i));
                    continue;
                }
                this.fatalError("The character '" + (char)ch + "' is an invalid XML character");
                continue;
            }
            if (ch == '\n' || ch == '\r' || ch == '\t' || ch == '\u0085' || ch == '\u2028') {
                this.printHex(ch);
                continue;
            }
            if (ch == '<') {
                this._printer.printText("&lt;");
                continue;
            }
            if (ch == '&') {
                this._printer.printText("&amp;");
                continue;
            }
            if (ch == '\"') {
                this._printer.printText("&quot;");
                continue;
            }
            if (ch >= ' ' && this._encodingInfo.isPrintable(ch)) {
                this._printer.printText(ch);
                continue;
            }
            this.printHex(ch);
        }
    }

    protected final void printCDATAText(String text) throws IOException {
        int length = text.length();
        for (int index = 0; index < length; ++index) {
            char ch = text.charAt(index);
            if (ch == ']' && index + 2 < length && text.charAt(index + 1) == ']' && text.charAt(index + 2) == '>') {
                if (this.fDOMErrorHandler != null) {
                    String msg;
                    if ((this.features & 0x10) == 0 && (this.features & 2) == 0) {
                        msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null);
                        this.modifyDOMError(msg, (short)3, this.fCurrentNode);
                        boolean continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!continueProcess) {
                            throw new IOException();
                        }
                    } else {
                        msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null);
                        this.modifyDOMError(msg, (short)1, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                index += 2;
                continue;
            }
            if (!XML11Char.isXML11Valid(ch)) {
                if (++index < length) {
                    this.surrogates(ch, text.charAt(index));
                    continue;
                }
                this.fatalError("The character '" + ch + "' is an invalid XML character");
                continue;
            }
            if (this._encodingInfo.isPrintable(ch) && XML11Char.isXML11ValidLiteral(ch)) {
                this._printer.printText(ch);
                continue;
            }
            this._printer.printText("]]>&#x");
            this._printer.printText(Integer.toHexString(ch));
            this._printer.printText(";<![CDATA[");
        }
    }

    protected final void printXMLChar(int ch) throws IOException {
        if (ch == 13 || ch == 133 || ch == 8232) {
            this.printHex(ch);
        } else if (ch == 60) {
            this._printer.printText("&lt;");
        } else if (ch == 38) {
            this._printer.printText("&amp;");
        } else if (ch == 62) {
            this._printer.printText("&gt;");
        } else if (this._encodingInfo.isPrintable((char)ch) && XML11Char.isXML11ValidLiteral(ch)) {
            this._printer.printText((char)ch);
        } else {
            this.printHex(ch);
        }
    }

    protected final void surrogates(int high, int low) throws IOException {
        if (XMLChar.isHighSurrogate(high)) {
            if (!XMLChar.isLowSurrogate(low)) {
                this.fatalError("The character '" + (char)low + "' is an invalid XML character");
            } else {
                int supplemental = XMLChar.supplemental((char)high, (char)low);
                if (!XML11Char.isXML11Valid(supplemental)) {
                    this.fatalError("The character '" + (char)supplemental + "' is an invalid XML character");
                } else if (this.content().inCData) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(supplemental));
                    this._printer.printText(";<![CDATA[");
                } else {
                    this.printHex(supplemental);
                }
            }
        } else {
            this.fatalError("The character '" + (char)high + "' is an invalid XML character");
        }
    }

    protected void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        int length = text.length();
        if (preserveSpace) {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XML11Char.isXML11Valid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XML11Char.isXML11Valid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    protected void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            while (length-- > 0) {
                char ch = chars[start];
                ++start;
                if (!XML11Char.isXML11Valid(ch)) {
                    if (++start < length) {
                        this.surrogates(ch, chars[start]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            while (length-- > 0) {
                char ch = chars[start];
                ++start;
                if (!XML11Char.isXML11Valid(ch)) {
                    if (++start < length) {
                        this.surrogates(ch, chars[start]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped && XML11Char.isXML11ValidLiteral(ch)) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    public boolean reset() {
        super.reset();
        return true;
    }
}

