/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderImpl;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public class DocumentBuilderFactoryImpl
extends DocumentBuilderFactory {
    private Hashtable attributes;
    private Schema grammar;
    private boolean isXIncludeAware;

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (this.attributes != null && this.attributes.containsKey("http://java.sun.com/xml/jaxp/properties/schemaLanguage") && this.grammar != null) {
            throw new ParserConfigurationException(DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "jaxp-schema-support", null));
        }
        try {
            return new DocumentBuilderImpl(this, this.attributes);
        }
        catch (SAXException se) {
            throw new ParserConfigurationException(se.getMessage());
        }
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (value == null) {
            if (this.attributes != null) {
                this.attributes.remove(name);
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, value);
        try {
            new DocumentBuilderImpl(this, this.attributes);
        }
        catch (Exception e) {
            this.attributes.remove(name);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        Object val;
        if (this.attributes != null && (val = this.attributes.get(name)) != null) {
            return val;
        }
        DOMParser domParser = null;
        try {
            domParser = new DocumentBuilderImpl(this, this.attributes).getDOMParser();
            return domParser.getProperty(name);
        }
        catch (SAXException se1) {
            try {
                boolean result = domParser.getFeature(name);
                return result ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (SAXException se2) {
                throw new IllegalArgumentException(se1.getMessage());
            }
        }
    }

    public Schema getSchema() {
        return this.grammar;
    }

    public void setSchema(Schema grammar) {
        this.grammar = grammar;
    }

    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    public void setXIncludeAware(boolean state) {
        this.isXIncludeAware = state;
    }

    public void setFeature(String name, boolean value) throws ParserConfigurationException {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        if (!name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            throw new ParserConfigurationException(DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "jaxp_feature_not_supported", new Object[]{name}));
        }
        this.attributes.put("http://javax.xml.XMLConstants/feature/secure-processing", value);
    }

    public boolean getFeature(String name) throws ParserConfigurationException {
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            Object ob = this.attributes.get("http://javax.xml.XMLConstants/feature/secure-processing");
            if (ob == null) {
                return false;
            }
            return (Boolean)ob;
        }
        throw new ParserConfigurationException(DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "jaxp_feature_not_supported", new Object[]{name}));
    }
}

