/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.jaxp.XNI2SAX;
import com.sun.org.apache.xerces.internal.util.AugmentationsImpl;
import com.sun.org.apache.xerces.internal.util.DraconianErrorHandler;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerProxy;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.TeeXMLDocumentFilterImpl;
import com.sun.org.apache.xerces.internal.util.XMLResourceIdentifierImpl;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.io.IOException;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JAXPValidatorComponent
extends TeeXMLDocumentFilterImpl
implements XMLComponent {
    private final ValidatorHandler validator;
    private final XNI2SAX xni2sax = new XNI2SAX();
    private final SAX2XNI sax2xni = new SAX2XNI();
    private final TypeInfoProvider typeInfoProvider;
    private Augmentations fCurrentAug;
    private XMLAttributes fCurrentAttributes;
    private SymbolTable fSymbolTable;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityResolver fEntityResolver;
    private static final TypeInfoProvider noInfoProvider = new TypeInfoProvider(){

        public TypeInfo getElementTypeInfo() {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(int index) {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(String attributeQName) {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(String attributeUri, String attributeLocalName) {
            return null;
        }

        public boolean isIdAttribute(int index) {
            return false;
        }

        public boolean isSpecified(int index) {
            return false;
        }
    };

    public JAXPValidatorComponent(ValidatorHandler validatorHandler) {
        this.validator = validatorHandler;
        TypeInfoProvider tip = validatorHandler.getTypeInfoProvider();
        if (tip == null) {
            tip = noInfoProvider;
        }
        this.typeInfoProvider = tip;
        this.xni2sax.setContentHandler(this.validator);
        this.validator.setContentHandler(this.sax2xni);
        this.setSide(this.xni2sax);
        this.validator.setErrorHandler(new ErrorHandlerProxy(){

            protected XMLErrorHandler getErrorHandler() {
                XMLErrorHandler handler = JAXPValidatorComponent.this.fErrorReporter.getErrorHandler();
                if (handler != null) {
                    return handler;
                }
                return new ErrorHandlerWrapper(DraconianErrorHandler.theInstance);
            }
        });
        this.validator.setResourceResolver(new LSResourceResolver(){

            public LSInput resolveResource(String type, String ns, String publicId, String systemId, String baseUri) {
                if (JAXPValidatorComponent.this.fEntityResolver == null) {
                    return null;
                }
                try {
                    XMLInputSource is = JAXPValidatorComponent.this.fEntityResolver.resolveEntity(new XMLResourceIdentifierImpl(publicId, systemId, baseUri, systemId));
                    if (is == null) {
                        return null;
                    }
                    DOMInputImpl di = new DOMInputImpl();
                    di.setBaseURI(is.getBaseSystemId());
                    di.setByteStream(is.getByteStream());
                    di.setCharacterStream(is.getCharacterStream());
                    di.setEncoding(is.getEncoding());
                    di.setPublicId(is.getPublicId());
                    di.setSystemId(is.getSystemId());
                    return di;
                }
                catch (IOException e) {
                    throw new XNIException(e);
                }
            }
        });
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.fCurrentAttributes = attributes;
        this.fCurrentAug = augs;
        this.xni2sax.startElement(element, attributes, null);
        this.fCurrentAttributes = null;
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.fCurrentAug = augs;
        this.xni2sax.endElement(element, null);
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        this.fCurrentAug = augs;
        this.xni2sax.characters(text, null);
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.fCurrentAug = augs;
        this.xni2sax.ignorableWhitespace(text, null);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)componentManager.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty("http://apache.org/xml/properties/internal/error-reporter");
    }

    private void updateAttributes(Attributes atts) {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String aqn = atts.getQName(i);
            int j = this.fCurrentAttributes.getIndex(aqn);
            String av = atts.getValue(i);
            if (j == -1) {
                int idx = aqn.indexOf(58);
                String prefix = idx < 0 ? null : this.symbolize(aqn.substring(0, idx));
                j = this.fCurrentAttributes.addAttribute(new QName(prefix, this.symbolize(atts.getLocalName(i)), this.symbolize(aqn), this.symbolize(atts.getURI(i))), atts.getType(i), av);
            } else if (!av.equals(this.fCurrentAttributes.getValue(j))) {
                this.fCurrentAttributes.setValue(j, av);
            }
            Augmentations augs = this.fCurrentAttributes.getAugmentations(j);
            augs.putItem("org.w3c.dom.TypeInfo", this.typeInfoProvider.getAttributeTypeInfo(i));
            augs.putItem("ID_ATTRIBUTE", this.typeInfoProvider.isIdAttribute(i) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private String symbolize(String s) {
        return this.fSymbolTable.addSymbol(s);
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return new String[]{"http://apache.org/xml/properties/internal/entity-resolver"};
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.equals("http://apache.org/xml/properties/internal/entity-resolver")) {
            this.fEntityResolver = (XMLEntityResolver)value;
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        return null;
    }

    private final class SAX2XNI
    extends DefaultHandler {
        private final Augmentations fAugmentations = new AugmentationsImpl();
        private final QName fQName = new QName();

        private SAX2XNI() {
        }

        public void characters(char[] ch, int start, int len) throws SAXException {
            try {
                this.handler().characters(new XMLString(ch, start, len), this.aug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
            try {
                this.handler().ignorableWhitespace(new XMLString(ch, start, len), this.aug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            try {
                JAXPValidatorComponent.this.updateAttributes(atts);
                this.handler().startElement(this.toQName(uri, localName, qname), JAXPValidatorComponent.this.fCurrentAttributes, this.elementAug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            try {
                this.handler().endElement(this.toQName(uri, localName, qname), this.aug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        private Augmentations elementAug() {
            Augmentations aug = this.aug();
            aug.putItem("org.w3c.dom.TypeInfo", JAXPValidatorComponent.this.typeInfoProvider.getElementTypeInfo());
            return aug;
        }

        private Augmentations aug() {
            if (JAXPValidatorComponent.this.fCurrentAug != null) {
                Augmentations r = JAXPValidatorComponent.this.fCurrentAug;
                JAXPValidatorComponent.this.fCurrentAug = null;
                return r;
            }
            this.fAugmentations.removeAllItems();
            return this.fAugmentations;
        }

        private XMLDocumentHandler handler() {
            return JAXPValidatorComponent.this.getDocumentHandler();
        }

        private SAXException toSAXException(XNIException xe) {
            Exception e = xe.getException();
            if (e == null) {
                e = xe;
            }
            if (e instanceof SAXException) {
                return (SAXException)e;
            }
            return new SAXException(e);
        }

        private QName toQName(String uri, String localName, String qname) {
            String prefix = null;
            int idx = qname.indexOf(58);
            if (idx > 0) {
                prefix = JAXPValidatorComponent.this.symbolize(qname.substring(0, idx));
            }
            localName = JAXPValidatorComponent.this.symbolize(localName);
            qname = JAXPValidatorComponent.this.symbolize(qname);
            uri = JAXPValidatorComponent.this.symbolize(uri);
            this.fQName.setValues(prefix, localName, qname, uri);
            return this.fQName;
        }
    }
}

