/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.dom.DOMErrorImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMStringListImpl;
import com.sun.org.apache.xerces.internal.impl.Constants;
import com.sun.org.apache.xerces.internal.parsers.AbstractDOMParser;
import com.sun.org.apache.xerces.internal.parsers.ObjectFactory;
import com.sun.org.apache.xerces.internal.util.DOMEntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.DOMErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import java.io.StringReader;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;
import org.w3c.dom.ls.LSResourceResolver;

public class DOMParserImpl
extends AbstractDOMParser
implements LSParser,
DOMConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String PSVI_AUGMENT = "http://apache.org/xml/features/validation/schema/augment-psvi";
    Thread currentThread = null;
    protected String fSchemaType = null;
    protected boolean fBusy = false;
    protected static final boolean DEBUG = false;
    private Vector fSchemaLocations = new Vector();
    private String fSchemaLocation = null;
    private DOMStringList fRecognizedParameters;
    private boolean abortNow = false;

    public DOMParserImpl(String configuration, String schemaType) {
        this((XMLParserConfiguration)ObjectFactory.createObject("com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration", configuration));
        if (schemaType != null) {
            if (schemaType.equals(Constants.NS_DTD)) {
                this.fConfiguration.setFeature(XMLSCHEMA, false);
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                this.fSchemaType = Constants.NS_DTD;
            } else if (schemaType.equals(Constants.NS_XMLSCHEMA)) {
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
            }
        }
    }

    public DOMParserImpl(XMLParserConfiguration config) {
        super(config);
        String[] domRecognizedFeatures = new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "split-cdata-sections", "supported-media-types-only", "certified", "well-formed", "ignore-unknown-character-denormalizations"};
        this.fConfiguration.addRecognizedFeatures(domRecognizedFeatures);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("well-formed", true);
        this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", true);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", true);
        this.fConfiguration.setFeature(NAMESPACES, true);
        this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", false);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("split-cdata-sections", true);
        this.fConfiguration.setFeature("supported-media-types-only", false);
        this.fConfiguration.setFeature("ignore-unknown-character-denormalizations", true);
        this.fConfiguration.setFeature("certified", true);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
    }

    public DOMParserImpl(SymbolTable symbolTable) {
        this((XMLParserConfiguration)ObjectFactory.createObject("com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration", "com.sun.org.apache.xerces.internal.parsers.XIncludeParserConfiguration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
    }

    public DOMParserImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this((XMLParserConfiguration)ObjectFactory.createObject("com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration", "com.sun.org.apache.xerces.internal.parsers.XIncludeParserConfiguration"));
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
    }

    public void reset() {
        super.reset();
        if (this.fSkippedElemStack != null) {
            this.fSkippedElemStack.removeAllElements();
        }
        this.fSchemaLocations.clear();
        this.fRejectedElement.clear();
        this.fFilterReject = false;
        this.fSchemaType = null;
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public LSParserFilter getFilter() {
        return this.fDOMFilter;
    }

    public void setFilter(LSParserFilter filter) {
        this.fDOMFilter = filter;
        if (this.fSkippedElemStack == null) {
            this.fSkippedElemStack = new Stack();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            try {
                if (name.equalsIgnoreCase("comments")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", state);
                    return;
                }
                if (name.equalsIgnoreCase("datatype-normalization")) {
                    this.fConfiguration.setFeature(NORMALIZE_DATA, state);
                    return;
                }
                if (name.equalsIgnoreCase("entities")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", state);
                    return;
                }
                if (name.equalsIgnoreCase("disallow-doctype")) {
                    this.fConfiguration.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, state);
                    return;
                }
                if (name.equalsIgnoreCase("supported-media-types-only") || name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("canonical-form")) {
                    if (!state) return;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                if (name.equalsIgnoreCase("namespaces")) {
                    this.fConfiguration.setFeature(NAMESPACES, state);
                    return;
                }
                if (name.equalsIgnoreCase("infoset")) {
                    if (!state) return;
                    this.fConfiguration.setFeature(NAMESPACES, true);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", true);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", true);
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
                    this.fConfiguration.setFeature(NORMALIZE_DATA, false);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", false);
                    return;
                }
                if (name.equalsIgnoreCase("cdata-sections")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", state);
                    return;
                }
                if (name.equalsIgnoreCase("namespace-declarations") || name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                    if (state) return;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                if (name.equalsIgnoreCase("validate")) {
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, state);
                    if (this.fSchemaType != Constants.NS_DTD) {
                        this.fConfiguration.setFeature(XMLSCHEMA, state);
                    }
                    if (!state) return;
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    return;
                }
                if (name.equalsIgnoreCase("validate-if-schema")) {
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, state);
                    if (!state) return;
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, false);
                    return;
                }
                if (name.equalsIgnoreCase("element-content-whitespace")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", state);
                    return;
                }
                if (name.equalsIgnoreCase("psvi")) {
                    this.fConfiguration.setFeature(PSVI_AUGMENT, true);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", "com.sun.org.apache.xerces.internal.dom.PSVIDocumentImpl");
                    return;
                }
                this.fConfiguration.setFeature(name.toLowerCase(Locale.ENGLISH), state);
                return;
            }
            catch (XMLConfigurationException e) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
                throw new DOMException(8, msg);
            }
        }
        if (name.equalsIgnoreCase("error-handler")) {
            if (value instanceof DOMErrorHandler || value == null) {
                try {
                    this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)value);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", this.fErrorHandler);
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            if (value instanceof LSResourceResolver || value == null) {
                try {
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper((LSResourceResolver)value));
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equalsIgnoreCase("schema-location")) {
            if (value instanceof String || value == null) {
                try {
                    if (value == null) {
                        this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", null);
                        return;
                    }
                    if (this.fSchemaType == Constants.NS_XMLSCHEMA) {
                        this.fSchemaLocation = (String)value;
                        StringTokenizer t = new StringTokenizer(this.fSchemaLocation, " \n\t\r");
                        if (t.hasMoreTokens()) {
                            this.fSchemaLocations.clear();
                            this.fSchemaLocations.add(t.nextToken());
                            while (t.hasMoreTokens()) {
                                this.fSchemaLocations.add(t.nextToken());
                            }
                            this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.fSchemaLocations.toArray());
                            return;
                        } else {
                            this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", value);
                        }
                        return;
                    }
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equalsIgnoreCase("schema-type")) {
            if (value instanceof String || value == null) {
                try {
                    if (value == null) {
                        this.fConfiguration.setFeature(XMLSCHEMA, false);
                        this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", null);
                        this.fSchemaType = null;
                        return;
                    }
                    if (value.equals(Constants.NS_XMLSCHEMA)) {
                        this.fConfiguration.setFeature(XMLSCHEMA, true);
                        this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
                        this.fSchemaType = Constants.NS_XMLSCHEMA;
                        return;
                    }
                    if (!value.equals(Constants.NS_DTD)) return;
                    this.fConfiguration.setFeature(XMLSCHEMA, false);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                    this.fSchemaType = Constants.NS_DTD;
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equalsIgnoreCase("http://apache.org/xml/properties/dom/document-class-name")) {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", value);
            return;
        } else {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equalsIgnoreCase("comments")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("datatype-normalization")) {
            return this.fConfiguration.getFeature(NORMALIZE_DATA) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("entities")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespaces")) {
            return this.fConfiguration.getFeature(NAMESPACES) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("validate")) {
            return this.fConfiguration.getFeature(VALIDATION_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("validate-if-schema")) {
            return this.fConfiguration.getFeature(DYNAMIC_VALIDATION) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("element-content-whitespace")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("disallow-doctype")) {
            return this.fConfiguration.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("infoset")) {
            boolean infoset = this.fConfiguration.getFeature(NAMESPACES) && this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") && this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") && !this.fConfiguration.getFeature(DYNAMIC_VALIDATION) && !this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") && !this.fConfiguration.getFeature(NORMALIZE_DATA) && !this.fConfiguration.getFeature("http://apache.org/xml/features/create-cdata-nodes");
            return infoset ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("cdata-sections")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/create-cdata-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("normalize-characters")) {
            return Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespace-declarations") || name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations") || name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("supported-media-types-only") || name.equalsIgnoreCase("split-cdata-sections") || name.equalsIgnoreCase("charset-overrides-xml-encoding")) {
            return this.fConfiguration.getFeature(name.toLowerCase(Locale.ENGLISH)) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("error-handler")) {
            if (this.fErrorHandler != null) {
                return this.fErrorHandler.getErrorHandler();
            }
            return null;
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            try {
                XMLEntityResolver entityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
                if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                    return ((DOMEntityResolverWrapper)entityResolver).getEntityResolver();
                }
                return null;
            }
            catch (XMLConfigurationException e) {}
        } else {
            if (name.equalsIgnoreCase("schema-type")) {
                return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            }
            if (name.equalsIgnoreCase("schema-location")) {
                return this.fSchemaLocation;
            }
            if (name.equalsIgnoreCase(SYMBOL_TABLE)) {
                return this.fConfiguration.getProperty(SYMBOL_TABLE);
            }
            if (name.equalsIgnoreCase("http://apache.org/xml/properties/dom/document-class-name")) {
                return this.fConfiguration.getProperty("http://apache.org/xml/properties/dom/document-class-name");
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
        return null;
    }

    public boolean canSetParameter(String name, Object value) {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equalsIgnoreCase("supported-media-types-only") || name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("canonical-form")) {
                return !state;
            }
            if (name.equalsIgnoreCase("namespace-declarations") || name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                return state;
            }
            if (name.equalsIgnoreCase("cdata-sections") || name.equalsIgnoreCase("charset-overrides-xml-encoding") || name.equalsIgnoreCase("comments") || name.equalsIgnoreCase("datatype-normalization") || name.equalsIgnoreCase("disallow-doctype") || name.equalsIgnoreCase("entities") || name.equalsIgnoreCase("infoset") || name.equalsIgnoreCase("namespaces") || name.equalsIgnoreCase("validate") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("element-content-whitespace") || name.equalsIgnoreCase("xml-declaration")) {
                return true;
            }
            try {
                this.fConfiguration.getFeature(name.toLowerCase(Locale.ENGLISH));
                return true;
            }
            catch (XMLConfigurationException e) {
                return false;
            }
        }
        if (name.equalsIgnoreCase("error-handler")) {
            return value instanceof DOMErrorHandler || value == null;
        }
        if (name.equalsIgnoreCase("resource-resolver")) {
            return value instanceof LSResourceResolver || value == null;
        }
        if (name.equalsIgnoreCase("schema-type")) {
            return value instanceof String && (value.equals(Constants.NS_XMLSCHEMA) || value.equals(Constants.NS_DTD)) || value == null;
        }
        if (name.equalsIgnoreCase("schema-location")) {
            return value instanceof String || value == null;
        }
        return name.equalsIgnoreCase("http://apache.org/xml/properties/dom/document-class-name");
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            Vector<String> parameters = new Vector<String>();
            parameters.add("namespaces");
            parameters.add("cdata-sections");
            parameters.add("canonical-form");
            parameters.add("namespace-declarations");
            parameters.add("split-cdata-sections");
            parameters.add("entities");
            parameters.add("validate-if-schema");
            parameters.add("validate");
            parameters.add("datatype-normalization");
            parameters.add("charset-overrides-xml-encoding");
            parameters.add("check-character-normalization");
            parameters.add("supported-media-types-only");
            parameters.add("ignore-unknown-character-denormalizations");
            parameters.add("normalize-characters");
            parameters.add("well-formed");
            parameters.add("infoset");
            parameters.add("disallow-doctype");
            parameters.add("element-content-whitespace");
            parameters.add("comments");
            parameters.add("error-handler");
            parameters.add("resource-resolver");
            parameters.add("schema-location");
            parameters.add("schema-type");
            this.fRecognizedParameters = new DOMStringListImpl(parameters);
        }
        return this.fRecognizedParameters;
    }

    public Document parseURI(String uri) throws LSException {
        block8: {
            if (this.fBusy) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null);
                throw new DOMException(11, msg);
            }
            XMLInputSource source = new XMLInputSource(null, uri, null);
            try {
                if (!this.fBusy) {
                    this.currentThread = Thread.currentThread();
                }
                this.fBusy = true;
                this.parse(source);
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    this.abortNow = false;
                    DOMParserImpl dOMParserImpl = this;
                    dOMParserImpl.currentThread.interrupted();
                }
            }
            catch (Exception e) {
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    DOMParserImpl dOMParserImpl = this;
                    dOMParserImpl.currentThread.interrupted();
                }
                if (this.abortNow) {
                    this.abortNow = false;
                    return null;
                }
                if (e == abort) break block8;
                if (this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                throw new LSException(81, e.getMessage());
            }
        }
        return this.getDocument();
    }

    public Document parse(LSInput is) throws LSException {
        block8: {
            XMLInputSource xmlInputSource = this.dom2xmlInputSource(is);
            if (this.fBusy) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null);
                throw new DOMException(11, msg);
            }
            try {
                if (!this.fBusy) {
                    this.currentThread = Thread.currentThread();
                }
                this.fBusy = true;
                this.parse(xmlInputSource);
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    this.abortNow = false;
                    DOMParserImpl dOMParserImpl = this;
                    dOMParserImpl.currentThread.interrupted();
                }
            }
            catch (Exception e) {
                this.fBusy = false;
                if (this.abortNow && this.currentThread.isInterrupted()) {
                    DOMParserImpl dOMParserImpl = this;
                    dOMParserImpl.currentThread.interrupted();
                }
                if (this.abortNow) {
                    this.abortNow = false;
                    return null;
                }
                if (e == abort) break block8;
                if (this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                throw new LSException(81, e.getMessage());
            }
        }
        return this.getDocument();
    }

    public Node parseWithContext(LSInput is, Node cnode, short action) throws DOMException, LSException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(LSInput is) {
        XMLInputSource xis = null;
        if (is.getCharacterStream() != null) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16");
        } else if (is.getByteStream() != null) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding());
        } else if (is.getStringData() != null && is.getStringData().length() > 0) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16");
        } else if (is.getSystemId() != null && is.getSystemId().length() > 0 || is.getPublicId() != null && is.getPublicId().length() > 0) {
            xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI());
        } else {
            if (this.fErrorHandler != null) {
                DOMErrorImpl error = new DOMErrorImpl();
                error.fType = "no-input-specified";
                error.fMessage = "no-input-specified";
                error.fSeverity = (short)3;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
            throw new LSException(81, "no-input-specified");
        }
        return xis;
    }

    public boolean getAsync() {
        return false;
    }

    public boolean getBusy() {
        return this.fBusy;
    }

    public void abort() {
        if (this.fBusy) {
            this.fBusy = false;
            this.abortNow = true;
            try {
                this.reset();
                if (this.currentThread != null) {
                    this.currentThread.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

