/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.ColumnSet;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.ConstrainedStatement;
import org.apache.ws.jaxme.sqls.Constraint;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.BooleanConstraintImpl;
import org.apache.ws.jaxme.sqls.impl.ColumnReferenceImpl;
import org.apache.ws.jaxme.sqls.impl.ConstraintImpl;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;

public class CombinedConstraintImpl
extends ConstraintImpl
implements CombinedConstraint {
    private List parts = new ArrayList();
    private CombinedConstraint.Type type;

    protected CombinedConstraintImpl(ConstrainedStatement pConstrainedStatement, CombinedConstraint.Type pType) {
        super(pConstrainedStatement);
        this.type = pType;
    }

    public CombinedConstraint.Type getType() {
        return this.type;
    }

    public CombinedConstraint createAndConstraint() {
        CombinedConstraintImpl result = new CombinedConstraintImpl(this.getConstrainedStatement(), CombinedConstraint.Type.AND);
        this.parts.add(result);
        return result;
    }

    public CombinedConstraint createOrConstraint() {
        CombinedConstraintImpl result = new CombinedConstraintImpl(this.getConstrainedStatement(), CombinedConstraint.Type.OR);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createEQ() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.EQ);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createNE() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.NE);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createLT() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.LT);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createGT() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.GT);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createLE() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.LE);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createGE() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.GE);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createLIKE() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.LIKE);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createISNULL() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.ISNULL);
        this.parts.add(result);
        return result;
    }

    public BooleanConstraint createIN() {
        BooleanConstraintImpl result = new BooleanConstraintImpl(this, BooleanConstraint.Type.IN);
        this.parts.add(result);
        return result;
    }

    public void addColumnSetQuery(ColumnSet pSet, TableReference pTableReference) {
        if (!pTableReference.getTable().equals(pSet.getTable())) {
            throw new IllegalStateException("The foreign keys referencing table is " + pSet.getTable().getQName() + ", but the arguments referencing table is " + pTableReference.getTable().getQName());
        }
        if (!pTableReference.getStatement().equals(this.getConstrainedStatement())) {
            throw new IllegalStateException("The statement of the table reference is not the same as this constraints statement.");
        }
        Iterator iter = pSet.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            BooleanConstraint eq = this.createEQ();
            eq.addPart(new ColumnReferenceImpl(pTableReference, column));
            eq.addPlaceholder();
        }
    }

    public void addJoin(ForeignKey pKey, TableReference pReferencingTable, TableReference pReferencedTable) {
        if (!pReferencingTable.getTable().equals(pKey.getTable())) {
            throw new IllegalStateException("The foreign keys referencing table is " + pKey.getTable().getQName() + ", but the arguments referencing table is " + pReferencingTable.getTable().getQName());
        }
        if (!pReferencedTable.getTable().equals(pKey.getReferencedTable())) {
            throw new IllegalStateException("The foreign keys referenced table is " + pKey.getReferencedTable().getQName() + ", but the arguments referenced table is " + pReferencedTable.getTable().getQName());
        }
        if (!pReferencingTable.getStatement().equals(this.getConstrainedStatement())) {
            throw new IllegalStateException("The statement of the referencing table is not the same as this constraints statement.");
        }
        if (!pReferencedTable.getStatement().equals(this.getConstrainedStatement())) {
            throw new IllegalStateException("The statement of the referenced table is not the same as this constraints statement.");
        }
        Iterator iter = pKey.getColumnLinks();
        while (iter.hasNext()) {
            ForeignKey.ColumnLink columnReference = (ForeignKey.ColumnLink)iter.next();
            BooleanConstraint eq = this.createEQ();
            eq.addPart(new ColumnReferenceImpl(pReferencingTable, columnReference.getLocalColumn()));
            eq.addPart(new ColumnReferenceImpl(pReferencedTable, columnReference.getReferencedColumn()));
        }
    }

    public void addJoin(TableReference pReferencingTable, ColumnSet pReferencingColumnSet, TableReference pReferencedTable, ColumnSet pReferencedColumnSet) {
        if (pReferencingTable == null) {
            throw new NullPointerException("The referencing table must not be null.");
        }
        if (pReferencingColumnSet == null) {
            throw new NullPointerException("The referencing column set must not be null.");
        }
        if (pReferencedTable == null) {
            throw new NullPointerException("The referenced table must not be null.");
        }
        if (pReferencedColumnSet == null) {
            throw new NullPointerException("The referenced column set must not be null.");
        }
        if (!pReferencingTable.getTable().equals(pReferencingColumnSet.getTable())) {
            throw new IllegalStateException("The referencing column sets table " + pReferencingColumnSet.getTable().getQName() + " doesn't match the referencing table " + pReferencingTable.getTable().getQName());
        }
        if (!pReferencedTable.getTable().equals(pReferencedColumnSet.getTable())) {
            throw new IllegalStateException("The referenced column sets table " + pReferencedColumnSet.getTable().getQName() + " doesn't match the referenced table " + pReferencedTable.getTable().getQName());
        }
        Iterator referencedIter = pReferencedColumnSet.getColumns();
        Iterator iter = pReferencingColumnSet.getColumns();
        while (iter.hasNext()) {
            Column referencingColumn = (Column)iter.next();
            if (!referencedIter.hasNext()) {
                throw new IllegalStateException("The size of the referencing and referenced column sets doesn't match.");
            }
            Column referencedColumn = (Column)referencedIter.next();
            BooleanConstraint eq = this.createEQ();
            eq.addPart(pReferencingTable.newColumnReference(referencingColumn));
            eq.addPart(pReferencedTable.newColumnReference(referencedColumn));
        }
    }

    public int getNumParts() {
        return this.parts.size();
    }

    public Iterator getParts() {
        return this.parts.iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void addConstraint(Map pMap, Constraint pConstraint) {
        if (pConstraint instanceof CombinedConstraint) {
            CombinedConstraint target;
            CombinedConstraint source = (CombinedConstraint)pConstraint;
            if (source.getType().equals(this.getType())) {
                target = this;
            } else if (source.getType().equals(CombinedConstraint.Type.AND)) {
                target = this.createAndConstraint();
            } else if (source.getType().equals(CombinedConstraint.Type.OR)) {
                target = this.createOrConstraint();
            } else {
                throw new IllegalStateException("Unknown combined constraint type: " + source.getType());
            }
            Iterator iter = source.getParts();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof CombinedConstraint) {
                    target.addConstraint(pMap, (CombinedConstraint)o);
                    continue;
                }
                if (o instanceof BooleanConstraint) {
                    target.addConstraint(pMap, (BooleanConstraint)o);
                    continue;
                }
                throw new IllegalArgumentException("Invalid part: " + o.getClass().getName());
            }
        } else if (pConstraint instanceof BooleanConstraint) {
            BooleanConstraint target;
            BooleanConstraint source = (BooleanConstraint)pConstraint;
            BooleanConstraint.Type sourceType = source.getType();
            if (BooleanConstraint.Type.EQ.equals(sourceType)) {
                target = this.createEQ();
            } else if (BooleanConstraint.Type.NE.equals(sourceType)) {
                target = this.createNE();
            } else if (BooleanConstraint.Type.GT.equals(sourceType)) {
                target = this.createGT();
            } else if (BooleanConstraint.Type.LT.equals(sourceType)) {
                target = this.createLT();
            } else if (BooleanConstraint.Type.GE.equals(sourceType)) {
                target = this.createGE();
            } else if (BooleanConstraint.Type.LE.equals(sourceType)) {
                target = this.createLE();
            } else if (BooleanConstraint.Type.LIKE.equals(sourceType)) {
                target = this.createLIKE();
            } else if (BooleanConstraint.Type.ISNULL.equals(sourceType)) {
                target = this.createISNULL();
            } else if (BooleanConstraint.Type.IN.equals(sourceType)) {
                target = this.createIN();
            } else {
                throw new IllegalArgumentException("Invalid boolean constraint type: " + sourceType);
            }
            Iterator iter = source.getParts();
            while (iter.hasNext()) {
                void var4_6;
                Object o = iter.next();
                if (o instanceof Value) {
                    var4_6.addPart((Value)o);
                    continue;
                }
                if (o instanceof ColumnReference) {
                    ColumnReference colRef = (ColumnReference)o;
                    TableReference tableRef = (TableReference)pMap.get(colRef.getTableReference());
                    if (tableRef == null) {
                        throw new IllegalStateException("Unknown reference to table " + colRef.getTableReference().getTable().getQName());
                    }
                    var4_6.addPart(tableRef.newColumnReference(colRef.getColumn()));
                    continue;
                }
                throw new IllegalStateException("Unknown part type: " + o.getClass().getName());
            }
        } else {
            throw new IllegalStateException("Unknown constraint type: " + pConstraint.getClass().getName());
        }
    }

    public static class TypeImpl
    extends SQLFactoryImpl.IdentImpl
    implements CombinedConstraint.Type {
        public TypeImpl(String pName) {
            super(pName);
        }
    }
}

