/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.js.ConditionalIndentationJavaSourceObject;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.Parameter;

public abstract class AbstractJavaMethod
extends ConditionalIndentationJavaSourceObject {
    private List exceptions = new ArrayList();
    private List params = new ArrayList();

    protected AbstractJavaMethod(String pName, JavaQName pType, JavaSource.Protection pProtection) {
        super(pName, pType, pProtection);
    }

    public boolean isThrowing(JavaQName e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        Iterator iter = this.exceptions.iterator();
        while (iter.hasNext()) {
            if (!e.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowing(Class e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        return this.isThrowing(JavaQNameImpl.getInstance(e));
    }

    public void addThrows(JavaQName e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        if (!this.exceptions.contains(e)) {
            this.exceptions.add(e);
        }
    }

    public void addThrows(Class e) {
        if (e == null) {
            throw new NullPointerException("The exception argument must not be null.");
        }
        this.exceptions.add(JavaQNameImpl.getInstance(e));
    }

    public Parameter addParam(Class p, String v) {
        return this.addParam(JavaQNameImpl.getInstance(p), v);
    }

    public Parameter addParam(JavaQName pType, String pName) {
        if (pType == null) {
            throw new NullPointerException("Type argument must not be null");
        }
        if (pName == null) {
            throw new NullPointerException("Parameter name argument must not be null");
        }
        Iterator iter = this.params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)iter.next();
            if (!param.getName().equals(pName)) continue;
            throw new IllegalArgumentException("Parameter name '" + pName + "' is already used for a parameter of type " + param.getType());
        }
        Parameter p = new Parameter(pType, pName);
        this.params.add(p);
        return p;
    }

    public Parameter addParam(Parameter pParam) {
        return this.addParam(pParam.getType(), pParam.getName());
    }

    public void clearParams() {
        this.params.clear();
    }

    public JavaQName[] getExceptions() {
        return this.exceptions.toArray(new JavaQName[this.exceptions.size()]);
    }

    public Parameter[] getParams() {
        return this.params.toArray(new Parameter[this.params.size()]);
    }

    public String[] getParamNames() {
        String[] res = new String[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            res[i++] = ((Parameter)this.params.get(i)).getName();
        }
        return res;
    }

    public JavaQName[] getParamTypes() {
        JavaQName[] res = new JavaQName[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            res[i++] = ((Parameter)this.params.get(i)).getType();
        }
        return res;
    }

    public void removeThrows(JavaQName exc) {
        this.exceptions.remove(exc);
    }

    public void removeThrows(Class exc) {
        this.removeThrows(JavaQNameImpl.getInstance(exc));
    }

    public void clearThrows() {
        this.exceptions.clear();
    }
}

