/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.js.AbstractJavaMethod;
import org.apache.ws.jaxme.js.ConditionalIndentationJavaSourceObject;
import org.apache.ws.jaxme.js.IncreasingTarget;
import org.apache.ws.jaxme.js.IndentationEngineImpl;
import org.apache.ws.jaxme.js.IndentationTarget;
import org.apache.ws.jaxme.js.JavaClassInitializer;
import org.apache.ws.jaxme.js.JavaComment;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.WriterTarget;

public class JavaSource
extends IndentationEngineImpl {
    public static final Type CLASS = new Type("class");
    public static final Type INTERFACE = new Type("interface");
    public static final Protection PUBLIC = new Protection("public");
    public static final Protection PROTECTED = new Protection("protected");
    public static final Protection PRIVATE = new Protection("private");
    public static final Protection DEFAULT_PROTECTION = new Protection("");
    List myObjects = new ArrayList();
    private JavaSourceFactory factory;
    private JavaQName myQName;
    private Protection myProtection;
    private Type type = CLASS;
    private JavaComment comment;
    private List extendedClasses;
    private ArrayList imports = new ArrayList();
    private ArrayList myImplements = new ArrayList();
    private ArrayList myFields = new ArrayList();
    private List innerClasses;
    private boolean isStatic;
    private List rawJavaSources;
    private boolean bAbstract;
    private boolean forcingFullyQualifiedName = false;
    private boolean hasDynamicImports = true;
    static /* synthetic */ Class class$org$apache$ws$jaxme$js$JavaConstructor;
    static /* synthetic */ Class class$org$apache$ws$jaxme$js$JavaMethod;

    JavaSource(JavaSourceFactory pFactory, JavaQName pName, Protection pProtection) {
        this.factory = pFactory;
        this.setQName(pName);
        this.setProtection(pProtection);
    }

    public JavaClassInitializer[] getClassInitializers() {
        ArrayList<ConditionalIndentationJavaSourceObject> result = new ArrayList<ConditionalIndentationJavaSourceObject>(this.myObjects);
        Iterator iter = this.myObjects.iterator();
        while (iter.hasNext()) {
            ConditionalIndentationJavaSourceObject object = (ConditionalIndentationJavaSourceObject)iter.next();
            if (!(object instanceof JavaClassInitializer)) continue;
            result.add(object);
        }
        return result.toArray(new JavaClassInitializer[result.size()]);
    }

    public JavaSourceFactory getFactory() {
        return this.factory;
    }

    public JavaQName getQName() {
        return this.myQName;
    }

    public void setQName(JavaQName pQName) {
        this.myQName = pQName;
    }

    public String getClassName() {
        return this.myQName.getClassName();
    }

    public String getPackageName() {
        return this.myQName.getPackageName();
    }

    public Protection getProtection() {
        return this.myProtection;
    }

    public void setProtection(Protection protection) {
        this.myProtection = protection == null ? DEFAULT_PROTECTION : protection;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type pType) {
        this.type = pType == null ? CLASS : pType;
    }

    public JavaComment getComment() {
        return this.comment;
    }

    public JavaComment newComment() {
        if (this.comment == null) {
            this.comment = new JavaComment();
            return this.comment;
        }
        throw new IllegalStateException("A Javadoc comment has already been created for this object.");
    }

    public void clearExtends() {
        this.extendedClasses = null;
    }

    public JavaQName[] getExtends() {
        if (this.extendedClasses == null) {
            return new JavaQName[0];
        }
        return this.extendedClasses.toArray(new JavaQName[this.extendedClasses.size()]);
    }

    public void addExtends(JavaQName pExtends) {
        if (this.extendedClasses == null) {
            this.extendedClasses = new ArrayList();
        } else if ("class".equals(this.getType())) {
            throw new IllegalStateException("Only interfaces may extend multiple classes.");
        }
        this.extendedClasses.add(pExtends);
    }

    public void addExtends(Class pExtends) {
        this.addExtends(JavaQNameImpl.getInstance(pExtends));
    }

    public boolean isExtending(JavaQName pClass) {
        Iterator iter = this.extendedClasses.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(pClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtending(Class pClass) {
        return this.isExtending(JavaQNameImpl.getInstance(pClass));
    }

    public JavaQName[] getImports() {
        return this.imports.toArray(new JavaQName[this.imports.size()]);
    }

    public void addImport(JavaQName s) {
        if (s.isArray()) {
            throw new IllegalArgumentException("Arrays cannot be imported");
        }
        this.imports.add(s);
    }

    public void addImport(Class s) {
        this.imports.add(JavaQNameImpl.getInstance(s));
    }

    public void clearImports() {
        this.imports.clear();
    }

    public JavaQName[] getImplements() {
        return this.myImplements.toArray(new JavaQName[this.myImplements.size()]);
    }

    public void addImplements(JavaQName s) {
        this.myImplements.add(s);
    }

    public void addImplements(Class s) {
        this.myImplements.add(JavaQNameImpl.getInstance(s));
    }

    public void clearImplements() {
        this.myImplements.clear();
    }

    public boolean isImplementing(JavaQName pClass) {
        Iterator iter = this.myImplements.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(pClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isImplementing(Class pClass) {
        return this.isImplementing(JavaQNameImpl.getInstance(pClass));
    }

    public JavaField getField(String pName) {
        if (pName == null) {
            throw new NullPointerException("A field name must not be null.");
        }
        JavaField[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!pName.equals(fields[i].getName())) continue;
            return fields[i];
        }
        return null;
    }

    public JavaField[] getFields() {
        return this.myFields.toArray(new JavaField[this.myFields.size()]);
    }

    void addField(JavaField f) {
        String s = f.getName();
        for (int i = 0; i < this.myFields.size(); ++i) {
            if (!s.equals(((JavaField)this.myFields.get(i)).getName())) continue;
            throw new IllegalStateException("The class " + this.getQName() + " already has a field " + s + ".");
        }
        this.myFields.add(f);
    }

    public JavaConstructor[] getConstructors() {
        ArrayList<ConditionalIndentationJavaSourceObject> result = new ArrayList<ConditionalIndentationJavaSourceObject>();
        Iterator iter = this.myObjects.iterator();
        while (iter.hasNext()) {
            ConditionalIndentationJavaSourceObject object = (ConditionalIndentationJavaSourceObject)iter.next();
            if (!(object instanceof JavaConstructor)) continue;
            result.add(object);
        }
        return result.toArray(new JavaConstructor[result.size()]);
    }

    void addConstructor(JavaConstructor c) {
        this.myObjects.add(c);
    }

    public Iterator getConstructorIterator() {
        return new MyObjectIterator(class$org$apache$ws$jaxme$js$JavaConstructor == null ? (class$org$apache$ws$jaxme$js$JavaConstructor = JavaSource.class$("org.apache.ws.jaxme.js.JavaConstructor")) : class$org$apache$ws$jaxme$js$JavaConstructor);
    }

    public JavaMethod[] getMethods() {
        ArrayList<ConditionalIndentationJavaSourceObject> result = new ArrayList<ConditionalIndentationJavaSourceObject>();
        Iterator iter = this.myObjects.iterator();
        while (iter.hasNext()) {
            ConditionalIndentationJavaSourceObject object = (ConditionalIndentationJavaSourceObject)iter.next();
            if (!(object instanceof JavaMethod)) continue;
            result.add(object);
        }
        return result.toArray(new JavaMethod[result.size()]);
    }

    private boolean isMatching(Parameter[] parameters, JavaQName[] pParams) {
        if (parameters.length == pParams.length) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].getType().equals(pParams[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JavaMethod getMethod(String pMethodName, JavaQName[] pParams) {
        Iterator iter = this.myObjects.iterator();
        while (iter.hasNext()) {
            JavaMethod jm;
            ConditionalIndentationJavaSourceObject object = (ConditionalIndentationJavaSourceObject)iter.next();
            if (!(object instanceof JavaMethod) || !(jm = (JavaMethod)object).getName().equals(pMethodName) || !this.isMatching(jm.getParams(), pParams)) continue;
            return jm;
        }
        return null;
    }

    public JavaConstructor getConstructor(JavaQName[] pParams) {
        Iterator iter = this.myObjects.iterator();
        while (iter.hasNext()) {
            JavaConstructor jc;
            ConditionalIndentationJavaSourceObject object = (ConditionalIndentationJavaSourceObject)iter.next();
            if (!(object instanceof JavaConstructor) || !this.isMatching((jc = (JavaConstructor)object).getParams(), pParams)) continue;
            return jc;
        }
        return null;
    }

    public Iterator getMethodIterator() {
        return new MyObjectIterator(class$org$apache$ws$jaxme$js$JavaMethod == null ? (class$org$apache$ws$jaxme$js$JavaMethod = JavaSource.class$("org.apache.ws.jaxme.js.JavaMethod")) : class$org$apache$ws$jaxme$js$JavaMethod);
    }

    void addMethod(JavaMethod m) {
        this.myObjects.add(m);
    }

    public void write(IndentationTarget pTarget) throws IOException {
        int i;
        int i2;
        String packageName;
        if (!this.isInnerClass() && (packageName = this.getPackageName()).length() > 0) {
            pTarget.indent(0);
            pTarget.write("package ");
            pTarget.write(packageName);
            pTarget.write(";");
            pTarget.write();
            pTarget.indent(0);
            pTarget.write();
        }
        JavaQName[] myExtendedClasses = this.getExtends();
        JavaQName[] implementedInterfaces = this.getImplements();
        JavaInnerClass[] myInnerClasses = this.getInnerClasses();
        JavaField[] fields = this.getFields();
        this.getConstructors();
        this.getMethods();
        Object[] myImports = this.getImports();
        Arrays.sort(myImports);
        if (myImports.length > 0) {
            for (int i3 = 0; i3 < myImports.length; ++i3) {
                pTarget.indent(0);
                pTarget.write("import ");
                pTarget.write(myImports[i3].toString());
                pTarget.write(";");
                pTarget.write();
            }
            pTarget.indent(0);
            pTarget.write();
            pTarget.indent(0);
            pTarget.write();
        }
        if (this.comment != null) {
            this.comment.write(pTarget);
            pTarget.indent(0);
            pTarget.write();
        }
        pTarget.indent(0);
        if (this.myProtection != null && !this.myProtection.equals(DEFAULT_PROTECTION)) {
            pTarget.write(this.myProtection.toString());
            pTarget.write(" ");
        }
        if (this.isStatic) {
            pTarget.write("static ");
        }
        if (this.isAbstract()) {
            pTarget.write("abstract ");
        }
        pTarget.write(this.getType().toString());
        pTarget.write(" ");
        String s = this.getClassName();
        int offset = s.lastIndexOf(46);
        if (offset > -1) {
            s = s.substring(offset + 1);
        }
        if ((offset = s.lastIndexOf(36)) > -1) {
            s = s.substring(offset + 1);
        }
        pTarget.write(s);
        pTarget.write(" ");
        for (i2 = 0; i2 < myExtendedClasses.length; ++i2) {
            if (i2 > 0) {
                pTarget.write(", ");
            } else {
                pTarget.write("extends ");
            }
            pTarget.write(pTarget.asString(myExtendedClasses[i2]));
            pTarget.write(" ");
        }
        if (implementedInterfaces.length > 0) {
            for (i2 = 0; i2 < implementedInterfaces.length; ++i2) {
                if (i2 == 0) {
                    pTarget.write("implements ");
                } else {
                    pTarget.write(", ");
                }
                pTarget.write(pTarget.asString(implementedInterfaces[i2]));
                pTarget.write(" ");
            }
        }
        pTarget.write("{");
        pTarget.write();
        IncreasingTarget increasingTarget = new IncreasingTarget(pTarget);
        for (i = 0; i < myInnerClasses.length; ++i) {
            increasingTarget.setInterface(myInnerClasses[i].isInterface() ? Boolean.TRUE : Boolean.FALSE);
            myInnerClasses[i].write(increasingTarget);
            increasingTarget.setInterface(null);
            pTarget.indent(0);
            pTarget.write();
        }
        if (fields != null && fields.length > 0) {
            for (i = 0; i < fields.length; ++i) {
                fields[i].write(increasingTarget);
                pTarget.indent(0);
                pTarget.write();
            }
            pTarget.indent(0);
            pTarget.write();
        }
        Iterator iter = this.myObjects.iterator();
        while (iter.hasNext()) {
            ConditionalIndentationJavaSourceObject object = (ConditionalIndentationJavaSourceObject)iter.next();
            object.write(increasingTarget);
            pTarget.indent(0);
            pTarget.write();
        }
        String[] myRawJavaSources = this.getRawJavaSources();
        for (int i4 = 0; i4 < myRawJavaSources.length; ++i4) {
            StringTokenizer st = new StringTokenizer(myRawJavaSources[i4], "\r\n");
            while (st.hasMoreTokens()) {
                pTarget.indent(0);
                String tok = st.nextToken();
                if (tok.length() > 0) {
                    pTarget.write(tok);
                }
                pTarget.write();
            }
            pTarget.indent(0);
            pTarget.write();
        }
        pTarget.indent(0);
        pTarget.write("}");
        pTarget.write();
    }

    public static String getQuotedNoQuotes(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getQuoted(String s) {
        return "\"" + JavaSource.getQuotedNoQuotes(s) + "\"";
    }

    public void addInnerClass(JavaInnerClass pClass) {
        if (this.innerClasses == null) {
            this.innerClasses = new ArrayList();
        }
        this.innerClasses.add(pClass);
    }

    public void clearInnerClasses() {
        this.innerClasses = null;
    }

    public JavaInnerClass[] getInnerClasses() {
        if (this.innerClasses == null) {
            return new JavaInnerClass[0];
        }
        return this.innerClasses.toArray(new JavaInnerClass[this.innerClasses.size()]);
    }

    public JavaInnerClass getInnerClass(String pName) {
        if (this.innerClasses == null) {
            return null;
        }
        for (int i = 0; i < this.innerClasses.size(); ++i) {
            JavaInnerClass jic = (JavaInnerClass)this.innerClasses.get(i);
            if (!jic.getQName().getInnerClassName().equals(pName)) continue;
            return jic;
        }
        return null;
    }

    protected boolean getStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean pStatic) {
        this.isStatic = pStatic;
    }

    public void addRawJavaSource(String pSource) {
        if (pSource != null && pSource.length() > 0) {
            if (this.rawJavaSources == null) {
                this.rawJavaSources = new ArrayList();
            }
            this.rawJavaSources.add(pSource);
        }
    }

    public void clearRawJavaSources() {
        this.rawJavaSources = null;
    }

    public String[] getRawJavaSources() {
        if (this.rawJavaSources == null) {
            return new String[0];
        }
        return this.rawJavaSources.toArray(new String[this.rawJavaSources.size()]);
    }

    public boolean isAbstract() {
        return this.bAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.bAbstract = isAbstract;
    }

    public boolean isInterface() {
        return INTERFACE.equals(this.getType());
    }

    public String asString(JavaQName pQName, boolean pAddIfPossible) {
        return this._asString(pQName, pAddIfPossible).replace('$', '.');
    }

    private String _asString(JavaQName pQName, boolean pAddIfPossible) {
        String className;
        if (this.isForcingFullyQualifiedName()) {
            return pQName.toString();
        }
        if (pQName.isArray()) {
            return this.asString(pQName.getInstanceClass(), pAddIfPossible) + "[]";
        }
        if (!pQName.isImportable()) {
            return pQName.toString();
        }
        if ("".equals(pQName.getPackageName())) {
            return pQName.getClassName();
        }
        JavaQName outerQName = pQName;
        int offset = outerQName.getClassName().indexOf(36);
        if (offset >= 0) {
            className = outerQName.getClassName().substring(0, offset);
            outerQName = JavaQNameImpl.getInstance(outerQName.getPackageName(), className);
        }
        if ((offset = outerQName.getClassName().indexOf(46)) >= 0) {
            className = pQName.getClassName().substring(0, offset);
            outerQName = JavaQNameImpl.getInstance(outerQName.getPackageName(), className);
        }
        if (this.getQName().equals(outerQName)) {
            return pQName.getClassName();
        }
        if (this.getQName().getClassName().equals(outerQName.getClassName())) {
            return pQName.toString();
        }
        boolean done = false;
        boolean imported = false;
        Iterator iter = this.imports.iterator();
        while (!done && iter.hasNext()) {
            JavaQName jqName = (JavaQName)iter.next();
            if (jqName.equals(outerQName)) {
                done = true;
                imported = true;
                continue;
            }
            if (!outerQName.getClassName().equals(jqName.getClassName())) continue;
            done = true;
            imported = false;
        }
        if (!done) {
            String packageName = pQName.getPackageName();
            if (packageName.equals(this.getPackageName()) || packageName.equals("java.lang")) {
                imported = true;
                done = true;
            }
            if (!done) {
                if (pAddIfPossible) {
                    this.addImport(outerQName);
                    done = true;
                    imported = true;
                } else {
                    done = true;
                    imported = false;
                }
            }
        }
        if (imported) {
            return pQName.getClassName();
        }
        return pQName.toString();
    }

    public boolean isForcingFullyQualifiedName() {
        return this.forcingFullyQualifiedName;
    }

    public void setForcingFullyQualifiedName(boolean pForcingFullyQualifiedName) {
        this.forcingFullyQualifiedName = pForcingFullyQualifiedName;
    }

    public boolean hasDynamicImports() {
        return this.hasDynamicImports;
    }

    public void setDynamicImports(boolean pDynamicImports) {
        this.hasDynamicImports = pDynamicImports;
    }

    public void write(Writer pTarget) throws IOException {
        if (this.hasDynamicImports()) {
            IndentationTarget devNullTarget = new IndentationTarget(){

                public boolean isInterface() {
                    return JavaSource.this.isInterface();
                }

                public String asString(JavaQName pQName) {
                    return JavaSource.this.asString(pQName, true);
                }

                public void write(String pValue) {
                }

                public void write() {
                }

                public void indent(int i) {
                }
            };
            this.write(devNullTarget);
        }
        WriterTarget wt = new WriterTarget(){

            public boolean isInterface() {
                return JavaSource.this.isInterface();
            }

            public String asString(JavaQName pQName) {
                return JavaSource.this.asString(pQName, false);
            }
        };
        wt.setTarget(pTarget);
        this.write(wt);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexcpected IOException while writing into a StringWriter: " + e.getMessage());
        }
    }

    public JavaClassInitializer newJavaClassInitializer() {
        JavaClassInitializer result = new JavaClassInitializer();
        result.setJavaSource(this);
        this.myObjects.add(result);
        return result;
    }

    public JavaConstructor newJavaConstructor() {
        return this.newJavaConstructor(DEFAULT_PROTECTION);
    }

    public JavaConstructor newJavaConstructor(Protection pProtection) {
        JavaConstructor result = new JavaConstructor(this.getClassName(), pProtection);
        result.setJavaSource(this);
        this.addConstructor(result);
        return result;
    }

    public JavaConstructor newJavaConstructor(String pProtection) {
        return this.newJavaConstructor(Protection.valueOf(pProtection));
    }

    public JavaConstructor newJavaConstructor(JavaConstructor pConstructor) {
        return this.newJavaConstructor(pConstructor, false);
    }

    public JavaConstructor newJavaConstructor(JavaConstructor pConstructor, boolean pSuper) {
        JavaConstructor result = this.newJavaConstructor(pConstructor.getProtection());
        ArrayList<Object> superParams = pSuper ? new ArrayList<Object>() : null;
        Parameter[] params = pConstructor.getParams();
        for (int i = 0; i < params.length; ++i) {
            Parameter p = result.addParam(params[i]);
            if (!pSuper) continue;
            if (!superParams.isEmpty()) {
                superParams.add(", ");
            }
            superParams.add(p);
        }
        JavaQName[] exceptions = pConstructor.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            result.addThrows(exceptions[i]);
        }
        if (pSuper) {
            result.addLine("super(", superParams, ");");
        }
        return result;
    }

    public JavaMethod newJavaMethod(String pName, String pType) {
        return this.newJavaMethod(pName, JavaQNameImpl.getInstance(pType), (Protection)null);
    }

    public JavaMethod newJavaMethod(String pName, String pType, Protection pProtection) {
        return this.newJavaMethod(pName, JavaQNameImpl.getInstance(pType), pProtection);
    }

    public JavaMethod newJavaMethod(String pName, String pType, String pProtection) {
        return this.newJavaMethod(pName, JavaQNameImpl.getInstance(pType), Protection.valueOf(pProtection));
    }

    public JavaMethod newJavaMethod(String pName, JavaQName pType) {
        return this.newJavaMethod(pName, pType, DEFAULT_PROTECTION);
    }

    public JavaMethod newJavaMethod(String pName, JavaQName pType, Protection pProtection) {
        JavaMethod result = new JavaMethod(pName, pType, pProtection);
        result.setJavaSource(this);
        this.addMethod(result);
        return result;
    }

    public JavaMethod newJavaMethod(String pName, JavaQName pType, String pProtection) {
        JavaMethod result = new JavaMethod(pName, pType, Protection.valueOf(pProtection));
        result.setJavaSource(this);
        this.addMethod(result);
        return result;
    }

    public JavaMethod newJavaMethod(String pName, Class pType) {
        return this.newJavaMethod(pName, JavaQNameImpl.getInstance(pType), DEFAULT_PROTECTION);
    }

    public JavaMethod newJavaMethod(String pName, Class pType, Protection pProtection) {
        return this.newJavaMethod(pName, JavaQNameImpl.getInstance(pType), pProtection);
    }

    public JavaMethod newJavaMethod(String pName, Class pType, String pProtection) {
        return this.newJavaMethod(pName, JavaQNameImpl.getInstance(pType), Protection.valueOf(pProtection));
    }

    public JavaField newJavaField(Field pField) {
        int modifiers = pField.getModifiers();
        JavaField result = this.newJavaField(pField.getName(), pField.getType(), Protection.valueOf(modifiers));
        result.setFinal(Modifier.isFinal(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        result.setTransient(Modifier.isTransient(modifiers));
        return result;
    }

    public JavaConstructor newJavaConstructor(Constructor pConstructor) {
        int modifiers = pConstructor.getModifiers();
        JavaConstructor result = this.newJavaConstructor(Protection.valueOf(modifiers));
        this.addParameters(result, pConstructor.getParameterTypes());
        this.addExceptions(result, pConstructor.getExceptionTypes());
        return result;
    }

    public JavaMethod newJavaMethod(Method pMethod) {
        int modifiers = pMethod.getModifiers();
        JavaMethod result = this.newJavaMethod(pMethod.getName(), JavaQNameImpl.getInstance(pMethod.getReturnType()), Protection.valueOf(modifiers));
        result.setAbstract(Modifier.isAbstract(modifiers));
        result.setFinal(Modifier.isFinal(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        result.setSynchronized(Modifier.isSynchronized(modifiers));
        this.addParameters(result, pMethod.getParameterTypes());
        this.addExceptions(result, pMethod.getExceptionTypes());
        return result;
    }

    private void addExceptions(AbstractJavaMethod pMethod, Class[] pExceptions) {
        if (pExceptions != null) {
            for (int i = 0; i < pExceptions.length; ++i) {
                pMethod.addThrows(pExceptions[i]);
            }
        }
    }

    private void addParameters(AbstractJavaMethod pMethod, Class[] pParameters) {
        if (pParameters != null) {
            for (int i = 0; i < pParameters.length; ++i) {
                String parameterName = "p" + i;
                pMethod.addParam(pParameters[i], parameterName);
            }
        }
    }

    public JavaMethod newJavaMethod(JavaMethod pMethod) {
        JavaMethod jm = this.newJavaMethod(pMethod.getName(), pMethod.getType(), pMethod.getProtection());
        Parameter[] params = pMethod.getParams();
        for (int i = 0; i < params.length; ++i) {
            jm.addParam(params[i].getType(), params[i].getName());
        }
        JavaQName[] exceptions = pMethod.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            jm.addThrows(exceptions[i]);
        }
        return jm;
    }

    public JavaField newJavaField(String pName, JavaQName pType, Protection pProtection) {
        JavaField result = new JavaField(pName, pType, pProtection);
        result.setJavaSource(this);
        this.addField(result);
        return result;
    }

    public JavaField newJavaField(String pName, JavaQName pType, String pProtection) {
        JavaField result = new JavaField(pName, pType, Protection.valueOf(pProtection));
        result.setJavaSource(this);
        this.addField(result);
        return result;
    }

    public JavaField newJavaField(String pName, JavaQName pType) {
        return this.newJavaField(pName, pType, DEFAULT_PROTECTION);
    }

    public JavaField newJavaField(String pName, String pType, Protection pProtection) {
        return this.newJavaField(pName, JavaQNameImpl.getInstance(pType), pProtection);
    }

    public JavaField newJavaField(String pName, String pType, String pProtection) {
        return this.newJavaField(pName, JavaQNameImpl.getInstance(pType), Protection.valueOf(pProtection));
    }

    public JavaField newJavaField(String pName, String pType) {
        return this.newJavaField(pName, JavaQNameImpl.getInstance(pType), (Protection)null);
    }

    public JavaField newJavaField(String pName, Class pType, Protection pProtection) {
        return this.newJavaField(pName, JavaQNameImpl.getInstance(pType), pProtection);
    }

    public JavaField newJavaField(String pName, Class pType, String pProtection) {
        return this.newJavaField(pName, JavaQNameImpl.getInstance(pType), Protection.valueOf(pProtection));
    }

    public JavaField newJavaField(String pName, Class pType) {
        return this.newJavaField(pName, JavaQNameImpl.getInstance(pType));
    }

    public JavaInnerClass newJavaInnerClass(String pName) {
        return this.newJavaInnerClass(pName, DEFAULT_PROTECTION);
    }

    public JavaInnerClass newJavaInnerClass(String pName, Protection pProtection) {
        JavaQName innerClassName = JavaQNameImpl.getInnerInstance(this.getQName(), pName);
        JavaInnerClass result = new JavaInnerClass(this, innerClassName, pProtection);
        this.addInnerClass(result);
        return result;
    }

    public JavaInnerClass newJavaInnerClass(String pName, String pProtection) {
        return this.newJavaInnerClass(pName, Protection.valueOf(pProtection));
    }

    public boolean isInnerClass() {
        return false;
    }

    public void newBeanProperty(JavaQName pType, String pName) {
        String upperCaseName = Character.toUpperCase(pName.charAt(0)) + pName.substring(1);
        if (JavaQNameImpl.BOOLEAN.equals(pType)) {
            this.newBeanProperty(pType, pName, "is" + upperCaseName, "set" + upperCaseName);
        } else {
            this.newBeanProperty(pType, pName, "get" + upperCaseName, "set" + upperCaseName);
        }
    }

    public void newBeanProperty(Class pClass, String pName) {
        this.newBeanProperty(JavaQNameImpl.getInstance(pClass), pName);
    }

    public void newBeanProperty(JavaQName pType, String pFieldName, String pGetMethodName, String pSetMethodName) {
        this.newJavaField(pFieldName, pType, PRIVATE);
        if (pGetMethodName != null) {
            JavaMethod getMethod = this.newJavaMethod(pGetMethodName, pType, PUBLIC);
            getMethod.addLine("return this.", pFieldName, ";");
        }
        if (pSetMethodName != null) {
            JavaMethod setMethod = this.newJavaMethod(pSetMethodName, JavaQNameImpl.VOID, PUBLIC);
            setMethod.addParam(pType, pFieldName);
            setMethod.addLine("this.", pFieldName, " = ", pFieldName, ";");
        }
    }

    public void newBeanProperty(Class pClass, String pFieldName, String pGetMethodName, String pSetMethodName) {
        this.newBeanProperty(JavaQNameImpl.getInstance(pClass), pFieldName, pGetMethodName, pSetMethodName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyObjectIterator
    implements Iterator {
        private final Class instanceClass;
        private Object result = null;
        private boolean mayRemove;
        private Iterator inner;

        MyObjectIterator(Class pInstanceClass) {
            this.inner = JavaSource.this.myObjects.iterator();
            this.instanceClass = pInstanceClass;
        }

        public void remove() {
            if (!this.mayRemove) {
                throw new IllegalStateException("remove() is only allowed immediately after next()");
            }
            this.inner.remove();
            this.mayRemove = false;
        }

        public boolean hasNext() {
            this.mayRemove = false;
            if (this.result != null) {
                return true;
            }
            while (this.inner.hasNext()) {
                Object o = this.inner.next();
                if (!this.instanceClass.isAssignableFrom(o.getClass())) continue;
                this.result = o;
                return true;
            }
            this.result = null;
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object myResult = this.result;
            this.result = null;
            this.mayRemove = true;
            return myResult;
        }
    }

    public static class Protection
    implements Serializable {
        private static final long serialVersionUID = 1184782160268911467L;
        private String name;

        Protection(String pName) {
            this.name = pName;
        }

        public String toString() {
            return this.name;
        }

        public static Protection valueOf(String pProtection) {
            if ("public".equals(pProtection)) {
                return PUBLIC;
            }
            if ("protected".equals(pProtection)) {
                return PROTECTED;
            }
            if ("private".equals(pProtection)) {
                return PRIVATE;
            }
            if (pProtection == null || "".equals(pProtection)) {
                return DEFAULT_PROTECTION;
            }
            throw new IllegalArgumentException("Protection must be either 'public', 'protected', 'private', null or '' (default protection).");
        }

        public static Protection valueOf(int pModifiers) {
            if (Modifier.isPublic(pModifiers)) {
                return PUBLIC;
            }
            if (Modifier.isProtected(pModifiers)) {
                return PROTECTED;
            }
            if (Modifier.isPrivate(pModifiers)) {
                return PRIVATE;
            }
            return DEFAULT_PROTECTION;
        }
    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = -9130708752353639211L;
        private String name;

        Type(String pName) {
            this.name = pName;
        }

        public String toString() {
            return this.name;
        }

        public static Type valueOf(String pType) {
            if ("class".equals(pType)) {
                return CLASS;
            }
            if ("interface".equals(pType)) {
                return INTERFACE;
            }
            throw new IllegalArgumentException("Type must be either 'class' or 'interface'.");
        }
    }
}

