/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.apps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaComment;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.apps.JavaSourceResolver;
import org.apache.ws.jaxme.js.pattern.MethodKey;

public class XmlRpcClientGenerator {
    private final JavaSourceFactory factory;
    private final String targetPackage;
    private final Map methods = new HashMap();
    private boolean dispatcherImplementsXmlRpcHandler = true;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$ws$jaxme$js$apps$XmlRpcCaller;
    static /* synthetic */ Class class$java$lang$reflect$UndeclaredThrowableException;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$IllegalStateException;
    static /* synthetic */ Class class$org$apache$ws$jaxme$js$apps$XmlRpcClientGenerator;

    public boolean isDispatcherImplementsXmlRpcHandler() {
        return this.dispatcherImplementsXmlRpcHandler;
    }

    public void setDispatcherImplementsXmlRpcHandler(boolean pDispatcherImplementsXmlRpcHandler) {
        this.dispatcherImplementsXmlRpcHandler = pDispatcherImplementsXmlRpcHandler;
    }

    public XmlRpcClientGenerator(JavaSourceFactory pFactory, String pTargetPackage) {
        this.factory = pFactory;
        this.targetPackage = pTargetPackage;
    }

    public JavaSourceFactory getFactory() {
        return this.factory;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    protected String addMethod(JavaMethod pMethod) {
        String className = pMethod.getJavaSource().getQName().toString();
        String methodName = pMethod.getName();
        int i = 0;
        while (true) {
            String name = className + "-" + methodName;
            if (i > 0) {
                name = name + i;
            }
            if (!this.methods.containsKey(name)) {
                this.methods.put(name, pMethod);
                return name;
            }
            ++i;
        }
    }

    protected Object getResultValue(JavaMethod pMethod, JavaQName pType, Object pValue) {
        if (JavaQNameImpl.BOOLEAN.equals(pType)) {
            return new Object[]{"((", class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlRpcClientGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean, ") ", pValue, ").booleanValue()"};
        }
        if (JavaQNameImpl.BYTE.equals(pType)) {
            return new Object[]{"((", class$java$lang$Byte == null ? (class$java$lang$Byte = XmlRpcClientGenerator.class$("java.lang.Byte")) : class$java$lang$Byte, ") ", pValue, ").byteValue()"};
        }
        if (JavaQNameImpl.SHORT.equals(pType)) {
            return new Object[]{"((", class$java$lang$Short == null ? (class$java$lang$Short = XmlRpcClientGenerator.class$("java.lang.Short")) : class$java$lang$Short, ") ", pValue, ").shortValue()"};
        }
        if (JavaQNameImpl.INT.equals(pType)) {
            return new Object[]{"((", class$java$lang$Integer == null ? (class$java$lang$Integer = XmlRpcClientGenerator.class$("java.lang.Integer")) : class$java$lang$Integer, ") ", pValue, ").intValue()"};
        }
        if (JavaQNameImpl.LONG.equals(pType)) {
            return new Object[]{"((", class$java$lang$Long == null ? (class$java$lang$Long = XmlRpcClientGenerator.class$("java.lang.Long")) : class$java$lang$Long, ") ", pValue, ").longValue()"};
        }
        if (JavaQNameImpl.FLOAT.equals(pType)) {
            return new Object[]{"((", class$java$lang$Float == null ? (class$java$lang$Float = XmlRpcClientGenerator.class$("java.lang.Float")) : class$java$lang$Float, ") ", pValue, ").floatValue()"};
        }
        if (JavaQNameImpl.DOUBLE.equals(pType)) {
            return new Object[]{"((", class$java$lang$Double == null ? (class$java$lang$Double = XmlRpcClientGenerator.class$("java.lang.Double")) : class$java$lang$Double, ") ", pValue, ").doubleValue()"};
        }
        if (pType.isArray()) {
            LocalJavaField resultV = pMethod.newJavaField(class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector);
            resultV.addLine("(", class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector, ") ", pValue, ";");
            LocalJavaField resultA = pMethod.newJavaField(pType);
            pMethod.addIf(resultV, (Object)" == null");
            pMethod.addLine(resultA, " = null;");
            pMethod.addElse();
            pMethod.addLine(resultA, " = new ", pType.getInstanceClass(), "[", resultV, ".size()];");
            DirectAccessible i = pMethod.addForArray(resultA);
            Object[] element = new Object[]{resultV, ".elementAt(", i, ")"};
            pMethod.addLine(resultA, "[", i, "] = ", this.getResultValue(pMethod, pType.getInstanceClass(), element), ";");
            pMethod.addEndFor();
            pMethod.addEndIf();
            return resultA;
        }
        if (JavaQNameImpl.getInstance(class$java$lang$Object == null ? (class$java$lang$Object = XmlRpcClientGenerator.class$("java.lang.Object")) : class$java$lang$Object).equals(pType)) {
            return pValue;
        }
        return new Object[]{"(", pType, ") ", pValue};
    }

    protected Object getInputValue(JavaMethod pMethod, JavaQName pType, Object pValue) {
        if (pType.equals(JavaQNameImpl.BOOLEAN)) {
            return new Object[]{pValue, " ? ", class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlRpcClientGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean, ".TRUE : ", class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlRpcClientGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean, ".FALSE"};
        }
        if (pType.equals(JavaQNameImpl.BYTE)) {
            return new Object[]{"new ", class$java$lang$Byte == null ? (class$java$lang$Byte = XmlRpcClientGenerator.class$("java.lang.Byte")) : class$java$lang$Byte, "(", pValue, ")"};
        }
        if (pType.equals(JavaQNameImpl.SHORT)) {
            return new Object[]{"new ", class$java$lang$Short == null ? (class$java$lang$Short = XmlRpcClientGenerator.class$("java.lang.Short")) : class$java$lang$Short, "(", pValue, ")"};
        }
        if (pType.equals(JavaQNameImpl.INT)) {
            return new Object[]{"new ", class$java$lang$Integer == null ? (class$java$lang$Integer = XmlRpcClientGenerator.class$("java.lang.Integer")) : class$java$lang$Integer, "(", pValue, ")"};
        }
        if (pType.equals(JavaQNameImpl.LONG)) {
            return new Object[]{"new ", class$java$lang$Long == null ? (class$java$lang$Long = XmlRpcClientGenerator.class$("java.lang.Long")) : class$java$lang$Long, "(", pValue, ")"};
        }
        if (pType.equals(JavaQNameImpl.FLOAT)) {
            return new Object[]{"new ", class$java$lang$Float == null ? (class$java$lang$Float = XmlRpcClientGenerator.class$("java.lang.Float")) : class$java$lang$Float, "(", pValue, ")"};
        }
        if (pType.equals(JavaQNameImpl.DOUBLE)) {
            return new Object[]{"new ", class$java$lang$Double == null ? (class$java$lang$Double = XmlRpcClientGenerator.class$("java.lang.Double")) : class$java$lang$Double, "(", pValue, ")"};
        }
        if (pType.isArray()) {
            if (!(pValue instanceof DirectAccessible)) {
                LocalJavaField val = pMethod.newJavaField(pType);
                val.addLine(pValue);
                pValue = val;
            }
            LocalJavaField v = pMethod.newJavaField(class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector);
            pMethod.addIf(pValue, (Object)" == null");
            pMethod.addLine(v, " = null;");
            pMethod.addElse();
            pMethod.addLine(v, " = new ", class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector, "();");
            DirectAccessible i = pMethod.addForArray(pValue);
            Object[] element = new Object[]{pValue, "[", i, "]"};
            pMethod.addLine(v, ".add(", this.getInputValue(pMethod, pType.getInstanceClass(), element), ");");
            pMethod.addEndFor();
            pMethod.addEndIf();
            return v;
        }
        return pValue;
    }

    protected JavaMethod getMethod(JavaSource pJs, JavaField pCaller, String pName, JavaMethod pMethod) throws SecurityException, NoSuchMethodException {
        Method m = (class$org$apache$ws$jaxme$js$apps$XmlRpcCaller == null ? (class$org$apache$ws$jaxme$js$apps$XmlRpcCaller = XmlRpcClientGenerator.class$("org.apache.ws.jaxme.js.apps.XmlRpcCaller")) : class$org$apache$ws$jaxme$js$apps$XmlRpcCaller).getMethod("xmlRpcCall", class$java$lang$String == null ? (class$java$lang$String = XmlRpcClientGenerator.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector);
        Class<?>[] exceptions = m.getExceptionTypes();
        ArrayList<JavaQName> exceptionList = new ArrayList<JavaQName>();
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                JavaQName qName = JavaQNameImpl.getInstance(exceptions[i]);
                if (pMethod.isThrowing(qName)) continue;
                exceptionList.add(qName);
            }
        }
        JavaMethod jm = pJs.newJavaMethod(pMethod);
        LocalJavaField v = jm.newJavaField(class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector);
        v.addLine("new ", class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector, "()");
        Parameter[] params = jm.getParams();
        for (int i = 0; i < params.length; ++i) {
            Parameter p = params[i];
            jm.addLine(v, ".add(", this.getInputValue(jm, p.getType(), p), ");");
        }
        if (!exceptionList.isEmpty()) {
            jm.addTry();
        }
        Object[] result = new Object[]{pCaller, ".xmlRpcCall(", JavaSource.getQuoted(pName), ", ", v, ")"};
        if (JavaQNameImpl.VOID.equals(jm.getType())) {
            jm.addLine(result, ";");
        } else {
            jm.addLine("return ", this.getResultValue(jm, jm.getType(), result), ";");
        }
        if (!exceptionList.isEmpty()) {
            for (int i = 0; i < exceptionList.size(); ++i) {
                JavaQName exClass = (JavaQName)exceptionList.get(i);
                DirectAccessible e = jm.addCatch(exClass);
                jm.addThrowNew(class$java$lang$reflect$UndeclaredThrowableException == null ? XmlRpcClientGenerator.class$("java.lang.reflect.UndeclaredThrowableException") : class$java$lang$reflect$UndeclaredThrowableException, (Object)e);
            }
            jm.addEndTry();
        }
        return jm;
    }

    protected JavaField getXmlRpcCaller(JavaSource pJs) {
        JavaField jf = pJs.newJavaField("caller", class$org$apache$ws$jaxme$js$apps$XmlRpcCaller == null ? (class$org$apache$ws$jaxme$js$apps$XmlRpcCaller = XmlRpcClientGenerator.class$("org.apache.ws.jaxme.js.apps.XmlRpcCaller")) : class$org$apache$ws$jaxme$js$apps$XmlRpcCaller, JavaSource.PRIVATE);
        jf.setFinal(true);
        return jf;
    }

    protected JavaConstructor getConstructor(JavaSource pJs, JavaField jf) {
        JavaConstructor jcon = pJs.newJavaConstructor(JavaSource.PUBLIC);
        Parameter param = jcon.addParam(class$org$apache$ws$jaxme$js$apps$XmlRpcCaller == null ? (class$org$apache$ws$jaxme$js$apps$XmlRpcCaller = XmlRpcClientGenerator.class$("org.apache.ws.jaxme.js.apps.XmlRpcCaller")) : class$org$apache$ws$jaxme$js$apps$XmlRpcCaller, "pCaller");
        jcon.addLine(jf, " = ", param, ";");
        return jcon;
    }

    protected boolean isMethodGenerated(JavaMethod pMethod) {
        return JavaSource.PUBLIC.equals(pMethod.getProtection()) && !pMethod.isStatic();
    }

    public JavaSource addClass(JavaSource pSource, JavaSourceResolver pResolver) throws SecurityException, NoSuchMethodException {
        JavaSource js = this.getFactory().newJavaSource(JavaQNameImpl.getInstance(this.getTargetPackage(), pSource.getQName().getClassName()), JavaSource.PUBLIC);
        JavaField jf = this.getXmlRpcCaller(js);
        this.getConstructor(js, jf);
        HashMap keys = new HashMap();
        this.addMethods(js, pSource, keys, jf, pResolver);
        return js;
    }

    protected void addMethods(JavaSource pResult, JavaSource pSource, Map pKeys, JavaField pField, JavaSourceResolver pResolver) throws SecurityException, NoSuchMethodException {
        JavaMethod[] methods = pSource.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodKey key;
            JavaMethod m = methods[i];
            if (!this.isMethodGenerated(m) || pKeys.containsKey(key = new MethodKey(m))) continue;
            String name = this.addMethod(m);
            pKeys.put(key, this.getMethod(pResult, pField, name, m));
        }
        if (pResolver != null) {
            JavaQName[] qNames = pSource.getExtends();
            for (int i = 0; i < qNames.length; ++i) {
                JavaSource js = pResolver.getJavaSource(qNames[i]);
                if (js == null) continue;
                this.addMethods(pResult, js, pKeys, pField, pResolver);
            }
        }
    }

    public JavaSource getInvokerClass(JavaSource pSource) {
        JavaInnerClass invoker = pSource.newJavaInnerClass("Invoker", JavaSource.PUBLIC);
        JavaComment comment = invoker.newComment();
        comment.addLine("The dispatcher is implemented with a {@link java.util.Map}.");
        comment.addLine("The map keys are the method names, the values");
        comment.addLine("are instances of <code>Invoker</code>.");
        invoker.setType(JavaSource.INTERFACE);
        JavaMethod jm = invoker.newJavaMethod("invoke", class$java$lang$Object == null ? (class$java$lang$Object = XmlRpcClientGenerator.class$("java.lang.Object")) : class$java$lang$Object, JavaSource.PUBLIC);
        comment = jm.newComment();
        comment.addLine("This method creates a new instance of the class being");
        comment.addLine("called, converts the parameter objects (if required)");
        comment.addLine("and invokes the requested method. If required, the");
        comment.addLine("result is converted also and returned.");
        jm.addParam(class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector, "pParams");
        jm.addThrows(class$java$lang$Throwable == null ? (class$java$lang$Throwable = XmlRpcClientGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        return invoker;
    }

    protected JavaField getInvokerMap(JavaSource pSource) {
        JavaField result = pSource.newJavaField("map", class$java$util$Map == null ? (class$java$util$Map = XmlRpcClientGenerator.class$("java.util.Map")) : class$java$util$Map, JavaSource.PRIVATE);
        result.addLine("new ", class$java$util$HashMap == null ? (class$java$util$HashMap = XmlRpcClientGenerator.class$("java.util.HashMap")) : class$java$util$HashMap, "()");
        return result;
    }

    protected JavaSource getInvoker(JavaSource pSource, JavaMethod pMethod, JavaQName pInvoker, int pNum) {
        Parameter[] params = pMethod.getParams();
        JavaInnerClass js = pSource.newJavaInnerClass("Invoker" + pNum, JavaSource.PUBLIC);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(params[i].getType());
        }
        JavaComment comment = js.newComment();
        comment.addLine("Invoker for method " + pMethod.getName() + "(" + sb + ")");
        comment.addLine("in class " + pMethod.getJavaSource().getQName() + ".");
        js.setStatic(true);
        js.addImplements(pInvoker);
        JavaMethod jm = js.newJavaMethod("invoke", class$java$lang$Object == null ? (class$java$lang$Object = XmlRpcClientGenerator.class$("java.lang.Object")) : class$java$lang$Object, JavaSource.PUBLIC);
        Parameter param = jm.addParam(class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector, "params");
        JavaQName[] classes = pMethod.getExceptions();
        for (int i = 0; i < classes.length; ++i) {
            jm.addThrows(classes[i]);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                args.add(", ");
            }
            Parameter p = params[i];
            args.add(this.getResultValue(jm, p.getType(), new Object[]{param, ".elementAt(" + i + ")"}));
        }
        Object[] o = new Object[]{"new ", pMethod.getJavaSource().getQName(), "().", pMethod.getName(), "(", args, ")"};
        if (JavaQNameImpl.VOID.equals(pMethod.getType())) {
            jm.addLine(o, ";");
            jm.addLine("return null;");
        } else {
            jm.addLine("return ", this.getInputValue(jm, pMethod.getType(), o), ";");
        }
        return js;
    }

    public JavaConstructor getDispatcherConstructor(JavaSource pSource, JavaField pMap, JavaQName pInvoker) {
        JavaConstructor con = pSource.newJavaConstructor(JavaSource.PUBLIC);
        JavaComment comment = con.newComment();
        comment.addLine("Creates a new dispatcher.");
        int num = 0;
        Iterator iter = this.methods.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            JavaMethod method = (JavaMethod)entry.getValue();
            JavaSource innerClass = this.getInvoker(pSource, method, pInvoker, num++);
            con.addLine(pMap, ".put(", JavaSource.getQuoted(name), ", new ", innerClass.getQName(), "());");
        }
        return con;
    }

    protected JavaMethod getGetInvokerMethod(JavaSource pSource, JavaQName pInvoker, JavaField pMap) {
        JavaMethod jm = pSource.newJavaMethod("getInvoker", pInvoker, JavaSource.PROTECTED);
        Parameter param = jm.addParam(class$java$lang$String == null ? (class$java$lang$String = XmlRpcClientGenerator.class$("java.lang.String")) : class$java$lang$String, "pName");
        jm.addLine("return (", pInvoker, ") ", pMap, ".get(", param, ");");
        return jm;
    }

    protected JavaMethod getDispatcherInvokeMethod(JavaSource pSource, JavaQName pInvoker) {
        JavaMethod jm = pSource.newJavaMethod("execute", class$java$lang$Object == null ? (class$java$lang$Object = XmlRpcClientGenerator.class$("java.lang.Object")) : class$java$lang$Object, JavaSource.PUBLIC);
        JavaComment comment = jm.newComment();
        comment.addLine("Called for invocation of method <code>pName</code> with");
        comment.addLine("the parameters given by <code>pParams</code>.");
        Parameter name = jm.addParam(class$java$lang$String == null ? (class$java$lang$String = XmlRpcClientGenerator.class$("java.lang.String")) : class$java$lang$String, "pName");
        Parameter args = jm.addParam(class$java$util$Vector == null ? (class$java$util$Vector = XmlRpcClientGenerator.class$("java.util.Vector")) : class$java$util$Vector, "pParams");
        jm.addThrows(class$java$lang$Exception == null ? (class$java$lang$Exception = XmlRpcClientGenerator.class$("java.lang.Exception")) : class$java$lang$Exception);
        LocalJavaField invoker = jm.newJavaField(pInvoker);
        invoker.addLine("getInvoker(", name, ")");
        jm.addIf(invoker, (Object)" == null");
        jm.addThrowNew(class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = XmlRpcClientGenerator.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException, (Object)JavaSource.getQuoted("Unknown method name: "), (Object)" + ", (Object)name);
        jm.addEndIf();
        jm.addTry();
        jm.addLine("return ", invoker, ".invoke(", args, ");");
        DirectAccessible e = jm.addCatch(class$java$lang$Exception == null ? (class$java$lang$Exception = XmlRpcClientGenerator.class$("java.lang.Exception")) : class$java$lang$Exception);
        jm.addLine("throw ", e, ";");
        DirectAccessible t = jm.addCatch(class$java$lang$Throwable == null ? (class$java$lang$Throwable = XmlRpcClientGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        jm.addThrowNew(class$java$lang$reflect$UndeclaredThrowableException == null ? (class$java$lang$reflect$UndeclaredThrowableException = XmlRpcClientGenerator.class$("java.lang.reflect.UndeclaredThrowableException")) : class$java$lang$reflect$UndeclaredThrowableException, (Object)t);
        jm.addEndTry();
        return jm;
    }

    public JavaSource getDispatcher(JavaQName pQName) {
        JavaSource js = this.getFactory().newJavaSource(pQName, JavaSource.PUBLIC);
        if (this.isDispatcherImplementsXmlRpcHandler()) {
            js.addImport(JavaQNameImpl.getInstance("org.apache.xmlrpc.XmlRpcHandler"));
        }
        JavaComment comment = js.newComment();
        comment.addLine("The dispatcher is being used by the XmlRpcServer.");
        comment.addLine("It delegates incoming XML-RPC calls to the classes");
        comment.addLine("and methods, for which client classes have been");
        comment.addLine("created by the " + (class$org$apache$ws$jaxme$js$apps$XmlRpcClientGenerator == null ? (class$org$apache$ws$jaxme$js$apps$XmlRpcClientGenerator = XmlRpcClientGenerator.class$("org.apache.ws.jaxme.js.apps.XmlRpcClientGenerator")) : class$org$apache$ws$jaxme$js$apps$XmlRpcClientGenerator).getName() + ".");
        JavaSource invoker = this.getInvokerClass(js);
        JavaField map = this.getInvokerMap(js);
        this.getDispatcherConstructor(js, map, invoker.getQName());
        this.getGetInvokerMethod(js, invoker.getQName(), map);
        this.getDispatcherInvokeMethod(js, invoker.getQName());
        return js;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

