/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.beanreader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.apps.JavaSourceResolver;
import org.apache.ws.jaxme.js.beanreader.BeanInfo;
import org.apache.ws.jaxme.js.beanreader.BeanProperty;
import org.apache.ws.jaxme.js.beanreader.BeanReaderException;

public class BeanInfoFactory {
    private static final JavaQName OBJECT_TYPE = JavaQNameImpl.getInstance(class$java$lang$Object == null ? (class$java$lang$Object = BeanInfoFactory.class$("java.lang.Object")) : class$java$lang$Object);
    private static final JavaQName STRING_TYPE = JavaQNameImpl.getInstance(class$java$lang$String == null ? (class$java$lang$String = BeanInfoFactory.class$("java.lang.String")) : class$java$lang$String);
    private static final JavaQName BYTE_TYPE = JavaQNameImpl.getInstance(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanInfoFactory.class$("java.lang.Byte")) : class$java$lang$Byte);
    private static final JavaQName BYTE_ARRAY_TYPE = JavaQNameImpl.getArray(JavaQNameImpl.BYTE);
    private static final JavaQName SHORT_TYPE = JavaQNameImpl.getInstance(class$java$lang$Short == null ? (class$java$lang$Short = BeanInfoFactory.class$("java.lang.Short")) : class$java$lang$Short);
    private static final JavaQName INTEGER_TYPE = JavaQNameImpl.getInstance(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanInfoFactory.class$("java.lang.Integer")) : class$java$lang$Integer);
    private static final JavaQName LONG_TYPE = JavaQNameImpl.getInstance(class$java$lang$Long == null ? (class$java$lang$Long = BeanInfoFactory.class$("java.lang.Long")) : class$java$lang$Long);
    private static final JavaQName FLOAT_TYPE = JavaQNameImpl.getInstance(class$java$lang$Float == null ? (class$java$lang$Float = BeanInfoFactory.class$("java.lang.Float")) : class$java$lang$Float);
    private static final JavaQName DOUBLE_TYPE = JavaQNameImpl.getInstance(class$java$lang$Double == null ? (class$java$lang$Double = BeanInfoFactory.class$("java.lang.Double")) : class$java$lang$Double);
    private static final JavaQName BOOLEAN_TYPE = JavaQNameImpl.getInstance(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanInfoFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    private static final JavaQName CALENDAR_TYPE = JavaQNameImpl.getInstance(class$java$util$Calendar == null ? (class$java$util$Calendar = BeanInfoFactory.class$("java.util.Calendar")) : class$java$util$Calendar);
    private static final JavaQName BIG_DECIMAL_TYPE = JavaQNameImpl.getInstance(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BeanInfoFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    private static final JavaQName BIG_INTEGER_TYPE = JavaQNameImpl.getInstance(class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeanInfoFactory.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    private static final Map xsTypesByJavaTypes = new HashMap();
    private static final JavaQName[] SIMPLE_TYPES;
    private final JavaSourceResolver resolver;
    private String targetNamespace;
    private Map beans = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public BeanInfoFactory(JavaSourceResolver pClassLoader, JavaQName pQName) throws BeanReaderException {
        this.resolver = pClassLoader;
        JavaSource js = pClassLoader.getJavaSource(pQName);
        if (js == null) {
            throw new BeanReaderException("Failed to resolve class " + pQName);
        }
        this.createBeanInfo(js, false);
    }

    private void verifyAvailable(JavaSource pJs, boolean pIsSuperClass) throws BeanReaderException {
        if (!pIsSuperClass && !pJs.getProtection().equals(JavaSource.PUBLIC)) {
            throw new BeanReaderException("The class " + pJs.getType() + " is not public.");
        }
        if (!pIsSuperClass && pJs.isAbstract()) {
            throw new BeanReaderException("The class " + pJs.getType() + " is abstract.");
        }
        if (pJs.isInterface()) {
            throw new BeanReaderException("The class " + pJs.getType() + " is an interface.");
        }
    }

    private void verifyDefaultConstructor(JavaSource pJs) throws BeanReaderException {
        JavaConstructor[] constructors = pJs.getConstructors();
        if (constructors.length == 0) {
            return;
        }
        for (int i = 0; i < constructors.length; ++i) {
            JavaConstructor jc = constructors[i];
            if (!jc.getProtection().equals(JavaSource.PUBLIC) || jc.getParams().length != 0) continue;
            return;
        }
        throw new BeanReaderException("The class " + pJs.getType() + " doesn't have a default constructor.");
    }

    private JavaQName getSuperClass(JavaSource pJs) throws BeanReaderException {
        JavaQName[] superClasses = pJs.getExtends();
        switch (superClasses.length) {
            case 0: {
                return null;
            }
            case 1: {
                JavaQName superClass = superClasses[0];
                if (OBJECT_TYPE.equals(superClass)) {
                    return null;
                }
                JavaSource js = this.resolver.getJavaSource(superClass);
                if (js == null) {
                    throw new BeanReaderException("Failed to resolve class: " + superClass);
                }
                this.createBeanInfo(js, true);
                return superClass;
            }
        }
        throw new BeanReaderException("The class " + pJs.getQName() + " is extending multiple classes.");
    }

    private BeanProperty[] getBeanProperties(JavaSource pJs, BeanProperty[] pSuperTypeProperties) throws BeanReaderException {
        HashSet propertyNames = new HashSet();
        JavaMethod[] methods = pJs.getMethods();
        ArrayList<BeanProperty> result = new ArrayList<BeanProperty>();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod m = methods[i];
            if (!JavaSource.PUBLIC.equals(m.getProtection()) || m.isStatic() || !m.getName().startsWith("set")) continue;
            String name = m.getName().substring(3);
            Parameter[] parameters = m.getParams();
            if (parameters.length != 1) continue;
            JavaQName type = parameters[0].getType();
            JavaQName[] zeroParameters = new JavaQName[]{};
            JavaMethod getter = pJs.getMethod("get" + name, zeroParameters);
            if (getter == null) {
                if (JavaQNameImpl.BOOLEAN.equals(type)) {
                    getter = pJs.getMethod("is" + name, zeroParameters);
                }
                if (getter == null) continue;
            }
            if (!type.equals(getter.getType()) || !JavaSource.PUBLIC.equals(getter.getProtection()) || getter.isStatic()) continue;
            BeanProperty p = this.createBeanProperty(propertyNames, name, type);
            boolean isSuperTypeProperty = false;
            for (int j = 0; j < pSuperTypeProperties.length; ++j) {
                if (!pSuperTypeProperties[j].equals(p)) continue;
                isSuperTypeProperty = true;
                break;
            }
            if (isSuperTypeProperty) continue;
            result.add(p);
        }
        return result.toArray(new BeanProperty[result.size()]);
    }

    private JavaQName getInstanceType(JavaQName pType) {
        if (pType.isArray() && !BYTE_ARRAY_TYPE.equals(pType)) {
            return pType.getInstanceClass();
        }
        return pType;
    }

    private QName getXsType(JavaQName pType) throws BeanReaderException {
        JavaQName instanceType = this.getInstanceType(pType);
        if (instanceType.isArray() && instanceType.isArray() && !BYTE_ARRAY_TYPE.equals(instanceType)) {
            throw new BeanReaderException("Multidimensional arrays are unsupported: " + pType);
        }
        return (QName)xsTypesByJavaTypes.get(instanceType);
    }

    private String getXsTypeName(Set pPropertyNames, JavaQName pType) throws BeanReaderException {
        String propertyPrefix;
        JavaQName instanceType = this.getInstanceType(pType);
        JavaSource js = this.resolver.getJavaSource(instanceType);
        if (js == null) {
            throw new BeanReaderException("Failed to resolve property type " + instanceType);
        }
        this.createBeanInfo(js, false);
        String propertyName = propertyPrefix = this.asXmlIdentifier(pType.getInnerClassName());
        int i = 0;
        while (pPropertyNames.contains(propertyName)) {
            propertyName = propertyPrefix + i;
            ++i;
        }
        pPropertyNames.add(propertyName);
        return propertyName;
    }

    private BeanProperty createBeanProperty(Set pPropertyNames, String pName, JavaQName pType) throws BeanReaderException {
        QName xsType = this.getXsType(pType);
        String xsTypeName = xsType == null ? this.getXsTypeName(pPropertyNames, pType) : null;
        return new BeanPropertyImpl(pType, xsType, xsTypeName, pName);
    }

    private String asBeanKey(JavaQName pQName) {
        return pQName.toString().replace('$', '.');
    }

    private void createBeanInfo(JavaSource pJs, boolean pIsSuperClass) throws BeanReaderException {
        JavaQName superType;
        JavaQName type = pJs.getQName();
        String key = this.asBeanKey(type);
        if (this.beans.containsKey(key)) {
            return;
        }
        this.verifyAvailable(pJs, pIsSuperClass);
        if (!pIsSuperClass) {
            this.verifyDefaultConstructor(pJs);
        }
        BeanProperty[] superTypeProperties = (superType = this.getSuperClass(pJs)) == null ? new BeanProperty[]{} : this.getBeanInfo(superType).getBeanProperties();
        String elementName = this.asXmlIdentifier(type.getInnerClassName());
        BeanInfoImpl beanInfo = new BeanInfoImpl(elementName, type, superType);
        this.beans.put(key, beanInfo);
        BeanProperty[] properties = this.getBeanProperties(pJs, superTypeProperties);
        beanInfo.setBeanProperties(properties);
    }

    private String asXmlIdentifier(String pJavaIdentifier) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pJavaIdentifier.length(); ++i) {
            int c = pJavaIdentifier.charAt(i);
            if (i == 0) {
                if ((c = Character.toLowerCase((char)c)) < 97 || c > 122) {
                    c = 95;
                }
            } else if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57)) {
                c = 95;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public boolean isSimpleType(JavaQName pType) {
        for (int i = 0; i < SIMPLE_TYPES.length; ++i) {
            if (!SIMPLE_TYPES[i].equals(pType)) continue;
            return true;
        }
        return false;
    }

    public BeanInfo getBeanInfo(JavaQName pType) {
        BeanInfo result = (BeanInfo)this.beans.get(this.asBeanKey(pType));
        if (result == null) {
            throw new IllegalStateException("Unknown bean type: " + pType);
        }
        return result;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String pTargetNamespace) {
        this.targetNamespace = pTargetNamespace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        xsTypesByJavaTypes.put(STRING_TYPE, new QName("http://www.w3.org/2001/XMLSchema-instance", "string"));
        QName byteQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "byte");
        xsTypesByJavaTypes.put(BYTE_TYPE, byteQName);
        xsTypesByJavaTypes.put(JavaQNameImpl.BYTE, byteQName);
        xsTypesByJavaTypes.put(BYTE_ARRAY_TYPE, new QName("http://www.w3.org/2001/XMLSchema-instance", "base64"));
        QName shortQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "short");
        xsTypesByJavaTypes.put(SHORT_TYPE, shortQName);
        xsTypesByJavaTypes.put(JavaQNameImpl.SHORT, shortQName);
        QName intQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "int");
        xsTypesByJavaTypes.put(INTEGER_TYPE, intQName);
        xsTypesByJavaTypes.put(JavaQNameImpl.INT, intQName);
        QName longQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "long");
        xsTypesByJavaTypes.put(LONG_TYPE, longQName);
        xsTypesByJavaTypes.put(JavaQNameImpl.LONG, longQName);
        QName floatQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "float");
        xsTypesByJavaTypes.put(FLOAT_TYPE, floatQName);
        xsTypesByJavaTypes.put(JavaQNameImpl.FLOAT, floatQName);
        QName doubleQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "double");
        xsTypesByJavaTypes.put(DOUBLE_TYPE, doubleQName);
        xsTypesByJavaTypes.put(JavaQNameImpl.DOUBLE, doubleQName);
        QName booleanQName = new QName("http://www.w3.org/2001/XMLSchema-instance", "boolean");
        xsTypesByJavaTypes.put(BOOLEAN_TYPE, booleanQName);
        xsTypesByJavaTypes.put(JavaQNameImpl.BOOLEAN, booleanQName);
        xsTypesByJavaTypes.put(CALENDAR_TYPE, new QName("http://www.w3.org/2001/XMLSchema-instance", "dateTime"));
        xsTypesByJavaTypes.put(BIG_DECIMAL_TYPE, new QName("http://www.w3.org/2001/XMLSchema-instance", "decimal"));
        xsTypesByJavaTypes.put(BIG_INTEGER_TYPE, new QName("http://www.w3.org/2001/XMLSchema-instance", "integer"));
        SIMPLE_TYPES = xsTypesByJavaTypes.keySet().toArray(new JavaQName[xsTypesByJavaTypes.size()]);
    }

    private class BeanInfoImpl
    implements BeanInfo {
        private BeanProperty[] properties;
        private final String elementName;
        private final JavaQName type;
        private final JavaQName superType;

        BeanInfoImpl(String pElementName, JavaQName pType, JavaQName pSuperType) {
            this.elementName = pElementName;
            this.type = pType;
            this.superType = pSuperType;
        }

        public String getTargetNamespace() {
            return BeanInfoFactory.this.getTargetNamespace();
        }

        void setBeanProperties(BeanProperty[] pProperties) {
            this.properties = pProperties;
        }

        public BeanProperty[] getBeanProperties() {
            return this.properties;
        }

        public String getElementName() {
            return this.elementName;
        }

        public JavaQName getType() {
            return this.type;
        }

        public JavaQName getSuperType() {
            return this.superType;
        }
    }

    private class BeanPropertyImpl
    implements BeanProperty {
        private final JavaQName type;
        private final QName xsType;
        private final String xsTypeName;
        private final String name;

        BeanPropertyImpl(JavaQName pType, QName pXsType, String pXsTypeName, String pName) {
            this.type = pType;
            this.xsType = pXsType;
            this.xsTypeName = pXsTypeName;
            this.name = pName;
        }

        public JavaQName getType() {
            return this.type;
        }

        public QName getXsType() {
            return this.xsType == null ? new QName(BeanInfoFactory.this.getTargetNamespace(), this.xsTypeName) : this.xsType;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object pOther) {
            if (pOther == null || !(pOther instanceof BeanPropertyImpl)) {
                return false;
            }
            BeanPropertyImpl other = (BeanPropertyImpl)pOther;
            return this.type.equals(other.type) && this.name.equals(other.name);
        }

        public int hashCode() {
            return (this.type.hashCode() << 7) + this.name.hashCode();
        }
    }
}

