/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.lang.reflect.Method;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.pattern.Reflector;

public class CompiledClassReflector
implements Reflector {
    private final Class compiledClass;

    public CompiledClassReflector(Class pClass) {
        this.compiledClass = pClass;
    }

    public CompiledClassReflector(String pName, ClassLoader pClassLoader) throws ClassNotFoundException {
        this(pClassLoader.loadClass(pName));
    }

    protected JavaMethod getMethod(JavaSource pSource, Method pMethod) {
        JavaMethod method = pSource.newJavaMethod(pMethod.getName(), JavaQNameImpl.getInstance(pMethod.getReturnType()), JavaSource.PUBLIC);
        Class<?>[] classes = pMethod.getParameterTypes();
        for (int i = 0; i < classes.length; ++i) {
            method.addParam(classes[i], "arg" + i);
        }
        Class<?>[] exceptions = pMethod.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            method.addThrows(exceptions[i]);
        }
        return method;
    }

    public Class getCompiledClass() {
        return this.compiledClass;
    }

    public JavaSource getJavaSource(JavaSourceFactory pFactory) {
        Class c = this.getCompiledClass();
        JavaSource js = new JavaSourceFactory().newJavaSource(JavaQNameImpl.getInstance(c.getName()));
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            this.getMethod(js, m);
        }
        return js;
    }
}

