/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.impl.ColumnImpl;
import org.apache.ws.jaxme.sqls.impl.ForeignKeyImpl;
import org.apache.ws.jaxme.sqls.impl.IndexImpl;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;

public class TableImpl
implements Table {
    private Schema schema;
    private Table.Name name;
    private List columns = new ArrayList();
    private List indexes = new ArrayList();
    private List foreignKeys = new ArrayList();
    int indexNameCounter;

    protected TableImpl(Schema pSchema, Table.Name pName) {
        this.schema = pSchema;
        this.name = pName;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Table.Name getName() {
        return this.name;
    }

    public String getQName() {
        Schema mySchema = this.getSchema();
        if (mySchema.getName() == null) {
            return this.getName().getName();
        }
        return mySchema.getName().getName() + "." + this.getName().getName();
    }

    public Iterator getColumns() {
        return this.columns.iterator();
    }

    public Column newColumn(String pName, Column.Type pType) {
        return this.newColumn(new ColumnImpl.NameImpl(pName), pType);
    }

    public Column newColumn(Column.Name pName, Column.Type pType) {
        if (pName == null) {
            throw new NullPointerException("The column name must not be null.");
        }
        Integer maxLength = this.getSchema().getSQLFactory().getMaxColumnNameLength();
        if (maxLength != null && pName.getName().length() > maxLength) {
            throw new IllegalArgumentException("The column name " + pName + " exceeds the maximum column length of " + maxLength);
        }
        if (pType == null) {
            throw new NullPointerException("The column type must not be null.");
        }
        Column column = this.getColumn(pName);
        if (column != null) {
            throw new IllegalStateException("A column named " + column.getName() + " already exists in the table " + this.getQName());
        }
        column = ((SQLFactoryImpl)this.getSchema().getSQLFactory()).newColumnImpl(this, pName, pType);
        this.columns.add(column);
        return column;
    }

    public Column getColumn(Column.Name pName) {
        if (pName == null) {
            throw new NullPointerException("Column names must not be null.");
        }
        Iterator iter = this.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!(this.getSchema().getSQLFactory().isColumnNameCaseSensitive() ? pName.getName().equalsIgnoreCase(column.getName().getName()) : pName.equals(column.getName()))) continue;
            return column;
        }
        return null;
    }

    public Column getColumn(String pName) {
        return this.getColumn(new ColumnImpl.NameImpl(pName));
    }

    public Index newKey() {
        IndexImpl result = new IndexImpl(this, true, false);
        this.indexes.add(result);
        return result;
    }

    public Index newIndex() {
        IndexImpl result = new IndexImpl(this, false, false);
        this.indexes.add(result);
        return result;
    }

    public Index getPrimaryKey() {
        Iterator iter = this.getIndexes();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            if (!index.isPrimaryKey()) continue;
            return index;
        }
        return null;
    }

    public Iterator getIndexes() {
        return this.indexes.iterator();
    }

    public Index newPrimaryKey() {
        Index pk = this.getPrimaryKey();
        if (pk != null) {
            throw new IllegalStateException("A primary key is already defined on table " + this.getName());
        }
        IndexImpl result = new IndexImpl(this, true, true);
        this.indexes.add(result);
        return result;
    }

    public Iterator getForeignKeys() {
        return this.foreignKeys.iterator();
    }

    public ForeignKey newForeignKey(Table pTable) {
        ForeignKeyImpl foreignKey = new ForeignKeyImpl(this, pTable);
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!this.getSchema().equals(other.getSchema())) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getSchema().hashCode() + this.getName().hashCode();
    }

    public InsertStatement getInsertStatement() {
        InsertStatement result = this.getSchema().getSQLFactory().newInsertStatement();
        result.setTable(this);
        Iterator iter = this.getColumns();
        while (iter.hasNext()) {
            result.addSet((Column)iter.next());
        }
        return result;
    }

    public SelectStatement getSelectStatement() {
        SQLFactory factory = this.getSchema().getSQLFactory();
        SelectStatement result = factory.newSelectStatement();
        result.setTable(this);
        TableReference ref = result.getTableReference();
        Iterator iter = this.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            result.addResultColumn(factory.getObjectFactory().newColumnReference(ref, column));
        }
        return result;
    }

    public UpdateStatement getUpdateStatement() {
        UpdateStatement result = this.getSchema().getSQLFactory().newUpdateStatement();
        result.setTable(this);
        TableReference ref = result.getTableReference();
        boolean hasPrimaryKey = false;
        Iterator iter = this.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (column.isPrimaryKeyPart()) {
                hasPrimaryKey = true;
                continue;
            }
            result.addSet(column);
        }
        if (!hasPrimaryKey) {
            throw new IllegalStateException("Cannot create a default update statement without a primary key.");
        }
        result.getWhere().addColumnSetQuery(this.getPrimaryKey(), ref);
        return result;
    }

    public DeleteStatement getDeleteStatement() {
        DeleteStatement result = this.getSchema().getSQLFactory().newDeleteStatement();
        result.setTable(this);
        Index primaryKey = this.getPrimaryKey();
        if (primaryKey == null) {
            throw new IllegalStateException("Cannot create a default delete statement without a primary key.");
        }
        result.getWhere().addColumnSetQuery(primaryKey, result.getTableReference());
        return result;
    }

    public static class NameImpl
    extends SQLFactoryImpl.IdentImpl
    implements Table.Name {
        public NameImpl(String pName) {
            super(pName);
        }
    }
}

