/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.proxy.container.ProxyAdvisorDomain;

public class ContainerCache {
    private static volatile int counter;
    public static final Object mapLock;
    private static WeakHashMap containerCache;
    private AspectManager manager;
    private ContainerProxyCacheKey key;
    private Advisor classAdvisor;
    private InstanceProxyContainer instanceContainer;
    boolean isClassProxyContainer;
    Class[] interfaces;

    public ContainerCache(AspectManager manager, Class proxiedClass, Class[] interfaces) {
        this.manager = manager;
        this.interfaces = interfaces;
        this.key = new ContainerProxyCacheKey(proxiedClass, interfaces);
    }

    public static ContainerCache initialise(AspectManager manager, Class proxiedClass) {
        return ContainerCache.initialise(manager, proxiedClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContainerCache initialise(AspectManager manager, Class proxiedClass, Class[] interfaces) {
        ContainerCache factory = new ContainerCache(manager, proxiedClass, interfaces);
        Object object = mapLock;
        synchronized (object) {
            factory.initClassContainer();
            factory.initInstanceContainer();
        }
        return factory;
    }

    public ContainerProxyCacheKey getKey() {
        return this.key;
    }

    public Advisor getAdvisor() {
        return this.instanceContainer != null ? this.instanceContainer : this.classAdvisor;
    }

    public Advisor getClassAdvisor() {
        return this.classAdvisor;
    }

    public InstanceProxyContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public boolean hasAspects() {
        if (this.instanceContainer != null) {
            return this.instanceContainer.hasAspects();
        }
        return this.classAdvisor.hasAspects();
    }

    public boolean requiresInstanceAdvisor() {
        return this.interfaces != null && this.interfaces.length > 0;
    }

    public boolean isAdvised() {
        return Advised.class.isAssignableFrom(this.key.getClazz());
    }

    private void initClassContainer() {
        if (Advised.class.isAssignableFrom(this.key.getClazz())) {
            this.classAdvisor = AspectManager.instance().getAdvisor(this.key.getClazz());
        } else {
            this.classAdvisor = this.getCachedContainer(this.manager);
            if (this.classAdvisor == null) {
                this.classAdvisor = this.createAndCacheContainer();
            }
        }
    }

    private ClassProxyContainer getCachedContainer(AspectManager manager) {
        Map map = (Map)containerCache.get(this.key.getClazz());
        ClassProxyContainer container = null;
        if (map != null) {
            container = (ClassProxyContainer)map.get(this.key);
        }
        return container;
    }

    private ClassProxyContainer createAndCacheContainer() {
        ClassProxyContainer container = this.createContainer();
        this.cacheContainer(this.key, this.key.getClazz(), container);
        return container;
    }

    private ClassProxyContainer createContainer() {
        ProxyAdvisorDomain domain = new ProxyAdvisorDomain(this.manager, this.key.getClazz(), false);
        String classname = this.key.getClazz() != null ? this.key.getClazz().getName() : "AOP$Hollow";
        ClassProxyContainer container = new ClassProxyContainer(classname, domain);
        domain.setAdvisor(container);
        container.initialise(this.key.getClazz());
        return container;
    }

    private void cacheContainer(ContainerProxyCacheKey key, Class proxiedClass, ClassProxyContainer container) {
        HashMap<ContainerProxyCacheKey, ClassProxyContainer> map = (HashMap<ContainerProxyCacheKey, ClassProxyContainer>)containerCache.get(proxiedClass);
        if (map == null) {
            map = new HashMap<ContainerProxyCacheKey, ClassProxyContainer>();
            containerCache.put(proxiedClass, map);
        }
        map.put(key, container);
    }

    private InterfaceIntroduction getInterfaceIntroduction(Class proxiedClass, Class[] interfaces) {
        String[] classNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classNames[i] = interfaces[i].getName();
        }
        Class clazz = proxiedClass != null ? proxiedClass : Object.class;
        InterfaceIntroduction intro = new InterfaceIntroduction("Introduction" + counter++, clazz.getName(), classNames);
        return intro;
    }

    private void initInstanceContainer() {
        if (this.requiresInstanceAdvisor()) {
            InterfaceIntroduction introduction = null;
            if (this.interfaces != null && this.interfaces.length > 0) {
                introduction = this.getInterfaceIntroduction(this.classAdvisor.getClazz(), this.interfaces);
            }
            this.instanceContainer = InstanceProxyContainer.createInstanceProxyContainer(this.classAdvisor, introduction);
        }
    }

    static {
        mapLock = new Object();
        containerCache = new WeakHashMap();
    }
}

