/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.array;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aop.advice.PrecedenceSorter;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.array.ArrayBinding;
import org.jboss.aop.array.ArrayRegistry;
import org.jboss.aop.array.BooleanArrayElementReadInvocation;
import org.jboss.aop.array.BooleanArrayElementWriteInvocation;
import org.jboss.aop.array.ByteArrayElementReadInvocation;
import org.jboss.aop.array.ByteArrayElementWriteInvocation;
import org.jboss.aop.array.ByteBooleanConverter;
import org.jboss.aop.array.CharArrayElementReadInvocation;
import org.jboss.aop.array.CharArrayElementWriteInvocation;
import org.jboss.aop.array.DoubleArrayElementReadInvocation;
import org.jboss.aop.array.DoubleArrayElementWriteInvocation;
import org.jboss.aop.array.FloatArrayElementReadInvocation;
import org.jboss.aop.array.FloatArrayElementWriteInvocation;
import org.jboss.aop.array.IntArrayElementReadInvocation;
import org.jboss.aop.array.IntArrayElementWriteInvocation;
import org.jboss.aop.array.LongArrayElementReadInvocation;
import org.jboss.aop.array.LongArrayElementWriteInvocation;
import org.jboss.aop.array.ObjectArrayElementReadInvocation;
import org.jboss.aop.array.ObjectArrayElementWriteInvocation;
import org.jboss.aop.array.ShortArrayElementReadInvocation;
import org.jboss.aop.array.ShortArrayElementWriteInvocation;

public class ArrayAdvisor {
    static HashSet<ArrayBinding> bindings = new LinkedHashSet<ArrayBinding>();
    static boolean updated;

    public static void addBinding(ArrayBinding arrayBinding) {
        ChainCreator.addBinding(arrayBinding);
    }

    public static void removeBinding(ArrayBinding arrayBinding) {
        ChainCreator.removeBinding(arrayBinding);
    }

    public static Interceptor[] getReadInterceptors() {
        return ChainCreator.getReadInterceptors();
    }

    public static Interceptor[] getWriteInterceptors() {
        return ChainCreator.getWriteInterceptors();
    }

    public static void updateArrayField(Object target, String fieldName, Object oldValue, Object newValue) {
        ArrayRegistry registry = ArrayRegistry.getInstance();
        registry.removeFieldReference(target, fieldName, oldValue);
        registry.addFieldReference(target, fieldName, newValue);
    }

    public static void arrayWriteObject(Object array, int index, Object value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        ArrayRegistry registry = ArrayRegistry.getInstance();
        if (registry.isRegistered(array)) {
            boolean ignoreUpdate;
            Object oldValue = ((Object[])array)[index];
            boolean bl = ignoreUpdate = oldValue == value;
            if (!ignoreUpdate) {
                registry.removeElementReference(array, index, oldValue);
                if (value != null && value.getClass().isArray()) {
                    registry.addElementReference(array, index, value);
                }
                if (interceptors != null) {
                    ObjectArrayElementWriteInvocation invocation = new ObjectArrayElementWriteInvocation(interceptors, (Object[])array, index, value);
                    invocation.invokeNext();
                    return;
                }
            }
        }
        ((Object[])array)[index] = value;
    }

    public static void arrayWriteInt(Object array, int index, int value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array) && ((int[])array)[index] != value) {
            IntArrayElementWriteInvocation invocation = new IntArrayElementWriteInvocation(interceptors, (int[])array, index, value);
            invocation.invokeNext();
        } else {
            ((int[])array)[index] = value;
        }
    }

    public static void arrayWriteByteOrBoolean(Object array, int index, byte value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            if (array instanceof boolean[]) {
                if (((boolean[])array)[index] != ByteBooleanConverter.toBoolean(value)) {
                    BooleanArrayElementWriteInvocation invocation = new BooleanArrayElementWriteInvocation(interceptors, (boolean[])array, index, ByteBooleanConverter.toBoolean(value));
                    invocation.invokeNext();
                    return;
                }
                ((boolean[])array)[index] = ByteBooleanConverter.toBoolean(value);
            } else {
                if (((byte[])array)[index] != value) {
                    ByteArrayElementWriteInvocation invocation = new ByteArrayElementWriteInvocation(interceptors, (byte[])array, index, value);
                    invocation.invokeNext();
                    return;
                }
                ((byte[])array)[index] = value;
            }
        }
    }

    public static void arrayWriteChar(Object array, int index, char value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array) && ((char[])array)[index] != value) {
            CharArrayElementWriteInvocation invocation = new CharArrayElementWriteInvocation(interceptors, (char[])array, index, value);
            invocation.invokeNext();
        } else {
            ((char[])array)[index] = value;
        }
    }

    public static void arrayWriteDouble(Object array, int index, double value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array) && ((double[])array)[index] != value) {
            DoubleArrayElementWriteInvocation invocation = new DoubleArrayElementWriteInvocation(interceptors, (double[])array, index, value);
            invocation.invokeNext();
        } else {
            ((double[])array)[index] = value;
        }
    }

    public static void arrayWriteShort(Object array, int index, short value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array) && ((short[])array)[index] != value) {
            ShortArrayElementWriteInvocation invocation = new ShortArrayElementWriteInvocation(interceptors, (short[])array, index, value);
            invocation.invokeNext();
        } else {
            ((short[])array)[index] = value;
        }
    }

    public static void arrayWriteFloat(Object array, int index, float value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array) && ((float[])array)[index] != value) {
            FloatArrayElementWriteInvocation invocation = new FloatArrayElementWriteInvocation(interceptors, (float[])array, index, value);
            invocation.invokeNext();
        } else {
            ((float[])array)[index] = value;
        }
    }

    public static void arrayWriteLong(Object array, int index, long value) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getWriteInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array) && ((long[])array)[index] != value) {
            LongArrayElementWriteInvocation invocation = new LongArrayElementWriteInvocation(interceptors, (long[])array, index, value);
            invocation.invokeNext();
        } else {
            ((long[])array)[index] = value;
        }
    }

    public static Object arrayReadObject(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            ObjectArrayElementReadInvocation invocation = new ObjectArrayElementReadInvocation(interceptors, (Object[])array, index);
            return invocation.invokeNext();
        }
        return ((Object[])array)[index];
    }

    public static int arrayReadInt(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            IntArrayElementReadInvocation invocation = new IntArrayElementReadInvocation(interceptors, (int[])array, index);
            return (Integer)invocation.invokeNext();
        }
        return ((int[])array)[index];
    }

    public static byte arrayReadByteOrBoolean(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            if (array instanceof boolean[]) {
                BooleanArrayElementReadInvocation invocation = new BooleanArrayElementReadInvocation(interceptors, (boolean[])array, index);
                boolean b = (Boolean)invocation.invokeNext();
                return ByteBooleanConverter.toByte(b);
            }
            ByteArrayElementReadInvocation invocation = new ByteArrayElementReadInvocation(interceptors, (byte[])array, index);
            return (Byte)invocation.invokeNext();
        }
        if (array instanceof boolean[]) {
            return ByteBooleanConverter.toByte(((boolean[])array)[index]);
        }
        return ((byte[])array)[index];
    }

    public static char arrayReadChar(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            CharArrayElementReadInvocation invocation = new CharArrayElementReadInvocation(interceptors, (char[])array, index);
            return ((Character)invocation.invokeNext()).charValue();
        }
        return ((char[])array)[index];
    }

    public static double arrayReadDouble(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            DoubleArrayElementReadInvocation invocation = new DoubleArrayElementReadInvocation(interceptors, (double[])array, index);
            return (Double)invocation.invokeNext();
        }
        return ((double[])array)[index];
    }

    public static float arrayReadFloat(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            FloatArrayElementReadInvocation invocation = new FloatArrayElementReadInvocation(interceptors, (float[])array, index);
            return ((Float)invocation.invokeNext()).floatValue();
        }
        return ((float[])array)[index];
    }

    public static long arrayReadLong(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            LongArrayElementReadInvocation invocation = new LongArrayElementReadInvocation(interceptors, (long[])array, index);
            return (Long)invocation.invokeNext();
        }
        return ((long[])array)[index];
    }

    public static short arrayReadShort(Object array, int index) throws Throwable {
        Interceptor[] interceptors = ArrayAdvisor.getReadInterceptors();
        if (interceptors != null && ArrayRegistry.getInstance().isRegistered(array)) {
            ShortArrayElementReadInvocation invocation = new ShortArrayElementReadInvocation(interceptors, (short[])array, index);
            return (Short)invocation.invokeNext();
        }
        return ((short[])array)[index];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainCreator {
        private static ReadWriteLock lock = new ReentrantReadWriteLock();
        static Interceptor[] readInterceptors;
        static Interceptor[] writeInterceptors;

        private ChainCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void addBinding(ArrayBinding arrayBinding) {
            Lock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                bindings.add(arrayBinding);
                updated = true;
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void removeBinding(ArrayBinding arrayBinding) {
            Lock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                bindings.remove(arrayBinding);
                updated = true;
            }
            finally {
                writeLock.unlock();
            }
        }

        public static Interceptor[] getReadInterceptors() {
            return ChainCreator.getInterceptors(true);
        }

        public static Interceptor[] getWriteInterceptors() {
            return ChainCreator.getInterceptors(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Interceptor[] getInterceptors(boolean read) {
            Lock readLock = lock.readLock();
            readLock.lock();
            boolean lockedRead = true;
            try {
                if (updated) {
                    readLock.unlock();
                    lockedRead = false;
                    Lock writeLock = lock.writeLock();
                    writeLock.lock();
                    try {
                        if (updated) {
                            ArrayList<Interceptor> newReadInterceptors = new ArrayList<Interceptor>();
                            ArrayList<Interceptor> newWriteInterceptors = new ArrayList<Interceptor>();
                            for (ArrayBinding binding : bindings) {
                                InterceptorFactory[] factories = binding.getInterceptorFactories();
                                for (int i = 0; i < factories.length; ++i) {
                                    Interceptor icptr = ChainCreator.createInterceptor(factories[i]);
                                    if (icptr == null) continue;
                                    if (binding.isWrite()) {
                                        newWriteInterceptors.add(icptr);
                                    }
                                    if (!binding.isRead()) continue;
                                    newReadInterceptors.add(icptr);
                                }
                            }
                            readInterceptors = ChainCreator.finalizeChain(newReadInterceptors);
                            writeInterceptors = ChainCreator.finalizeChain(newWriteInterceptors);
                            updated = false;
                            Interceptor[] interceptorArray = read ? readInterceptors : writeInterceptors;
                            return interceptorArray;
                        }
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                Interceptor[] interceptorArray = read ? readInterceptors : writeInterceptors;
                return interceptorArray;
            }
            finally {
                if (lockedRead) {
                    readLock.unlock();
                }
            }
        }

        private static Interceptor[] finalizeChain(ArrayList<Interceptor> newinterceptors) {
            Interceptor[] interceptors;
            Interceptor[] interceptorArray = interceptors = newinterceptors.size() > 0 ? newinterceptors.toArray(new Interceptor[newinterceptors.size()]) : null;
            if (interceptors != null) {
                if (interceptors[0] instanceof GeneratedAdvisorInterceptor) {
                    // empty if block
                }
                interceptors = PrecedenceSorter.applyPrecedence(interceptors, AspectManager.instance());
            }
            return interceptors;
        }

        private static Interceptor createInterceptor(InterceptorFactory factory) {
            try {
                if (factory.isDeployed()) {
                    if (factory instanceof AdviceFactory) {
                        return PerVmAdvice.generateOptimized(null, AspectManager.instance(), factory.getAdvice(), factory.getAspect());
                    }
                    if (factory instanceof ScopedInterceptorFactory) {
                        return (Interceptor)AspectManager.instance().getPerVMAspect(factory.getAspect());
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

