/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceBinding {
    private static final Logger logger = AOPLogger.getLogger(AdviceBinding.class);
    private static volatile long counter = 0L;
    protected String name;
    protected Pointcut pointcut;
    protected ASTCFlowExpression cflow;
    protected String cflowString;
    protected Map<Advisor, Boolean> advisors = new WeakHashMap<Advisor, Boolean>();
    protected InterceptorFactory[] interceptorFactories = new InterceptorFactory[0];

    public AdviceBinding() {
    }

    public AdviceBinding(String name, Pointcut p, ASTCFlowExpression cflow, String cflowString, InterceptorFactory[] factories) throws ParseException {
        this.name = name;
        this.interceptorFactories = factories;
        this.cflow = cflow;
        this.pointcut = p;
        this.cflowString = cflowString;
    }

    public AdviceBinding(String pointcutExpression, String cflow) throws ParseException {
        this(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression, cflow);
    }

    public AdviceBinding(String name, String pointcutExpression, String cflow) throws ParseException {
        this.name = name;
        this.setPointcutExpression(pointcutExpression);
        this.setCFlowExpression(cflow);
        this.interceptorFactories = new InterceptorFactory[0];
    }

    public void setCFlowExpression(String cflow) throws ParseException {
        if (cflow != null) {
            this.cflowString = cflow;
            this.cflow = new PointcutExpressionParser(new StringReader(this.cflowString)).CFlowExpression();
        }
    }

    public void setPointcutExpression(String pointcutExpression) throws ParseException {
        this.pointcut = new PointcutExpression(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression);
    }

    public void addInterceptorFactory(InterceptorFactory factory) {
        List<InterceptorFactory> list = Arrays.asList(this.interceptorFactories);
        list = new ArrayList<InterceptorFactory>(list);
        list.add(factory);
        this.interceptorFactories = list.toArray(new InterceptorFactory[list.size()]);
    }

    public void addInterceptor(Class<?> clazz) {
        this.addInterceptorFactory(new GenericInterceptorFactory(clazz));
    }

    public String getName() {
        return this.name;
    }

    public InterceptorFactory[] getInterceptorFactories() {
        return this.interceptorFactories;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public ASTCFlowExpression getCFlow() {
        return this.cflow;
    }

    public String getCFlowString() {
        return this.cflowString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdvisor(Advisor advisor) {
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("added advisor: " + advisor.getName() + " from binding: " + this.name));
        }
        Map<Advisor, Boolean> map = this.advisors;
        synchronized (map) {
            this.advisors.put(advisor, Boolean.TRUE);
        }
    }

    public boolean hasAdvisors() {
        return this.advisors.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Advisor> getAdvisors() {
        ArrayList<Advisor> list = new ArrayList<Advisor>(this.advisors.size());
        Map<Advisor, Boolean> map = this.advisors;
        synchronized (map) {
            list.addAll(this.advisors.keySet());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAdvisors() {
        Map<Advisor, Boolean> map = this.advisors;
        synchronized (map) {
            for (Advisor advisor : this.advisors.keySet()) {
                if (!advisor.getManager().isAdvisorRegistered(advisor)) continue;
                advisor.removeAdviceBinding(this);
            }
            this.advisors.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdviceBinding)) {
            return false;
        }
        return ((AdviceBinding)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

