/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.instrument.ConstructionJoinPointGenerator;
import org.jboss.aop.instrument.ConstructionTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.util.JavassistMethodHashing;

public class GeneratedAdvisorConstructionTransformer
extends ConstructionTransformer {
    public GeneratedAdvisorConstructionTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected void generateConstructionInfoField(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException {
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
        String ciname = this.addConstructionInfoField(4, genadvisor, constructor, index);
        this.addJoinpoint(constructor, ciname, index);
        long constructorHash = JavassistMethodHashing.constructorHash(constructor);
        ((GeneratedAdvisorInstrumentor)this.instrumentor).initialiseConstructionInfoField(ciname, index, constructorHash);
    }

    private void addJoinpoint(CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException {
        CtClass clazz = constructor.getDeclaringClass();
        CtClass joinpoint = this.createJoinpointClass(clazz, constructor, ciname, index);
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
        CtField field = new CtField(joinpoint, ConstructionJoinPointGenerator.getGeneratedJoinPointFieldName(clazz.getSimpleName(), index), genadvisor);
        field.setModifiers(1);
        genadvisor.addField(field);
    }

    private CtClass createJoinpointClass(CtClass clazz, CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException {
        return ConstructionJoinPointGenerator.createJoinpointBaseClass((GeneratedAdvisorInstrumentor)this.instrumentor, clazz, constructor, ciname, index);
    }

    protected void generateNotMatchedConstructionInfoField(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException {
        this.generateConstructionInfoField(constructor, index);
    }

    protected boolean addInfoAsWeakReference() {
        return false;
    }

    public static String constructionFactory(String className) {
        if (className.indexOf(46) >= 0) {
            throw new RuntimeException("constructorFactory() takes a simple class name:" + className);
        }
        return className + "_construction_" + "$aop";
    }

    protected void insertInterception(CtConstructor constructor, int index) throws Exception {
        String constructionWrapperName = constructor.getDeclaringClass().getSimpleName() + "_con_" + "$aop";
        String body = this.createInterceptingWrapperBody(constructor, index);
        CtMethod wrapper = this.createWrapperMethod(constructor, constructionWrapperName, body);
        this.insertWrapperCallInCtor(constructor, constructionWrapperName);
    }

    private CtMethod createWrapperMethod(CtConstructor constructor, String wrapperName, String body) throws CannotCompileException, NotFoundException {
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.instrumentor).getGenadvisor();
        CtClass[] params = constructor.getParameterTypes();
        CtClass[] wrapperParams = new CtClass[params.length + 1];
        wrapperParams[0] = constructor.getDeclaringClass();
        System.arraycopy(params, 0, wrapperParams, 1, params.length);
        CtMethod wrapper = CtNewMethod.make((CtClass)CtClass.voidType, (String)wrapperName, (CtClass[])wrapperParams, (CtClass[])constructor.getExceptionTypes(), (String)body, (CtClass)genadvisor);
        genadvisor.addMethod(wrapper);
        return wrapper;
    }

    private void insertWrapperCallInCtor(CtConstructor constructor, String wrapperName) throws NotFoundException, CannotCompileException {
        String wrapperCall = "((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(constructor.getDeclaringClass()) + ")" + "getCurrentAdvisor$aop()" + ")." + wrapperName + "(this" + (constructor.getParameterTypes().length == 0 ? "" : ", $$") + ");";
        constructor.insertAfter(wrapperCall, false);
    }

    private String createInterceptingWrapperBody(CtConstructor constructor, int index) throws NotFoundException, CannotCompileException {
        String joinpointName = ConstructionJoinPointGenerator.getGeneratedJoinPointFieldName(constructor.getDeclaringClass().getSimpleName(), index);
        String infoName = GeneratedAdvisorConstructionTransformer.getConstructionInfoFieldName(constructor.getDeclaringClass().getSimpleName(), index);
        String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName) + "      try" + "      {" + "         if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "         {" + "            super." + "generateJoinPointClass" + "(" + infoName + ");" + "         }" + "      } finally {" + GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName) + "      }" + "   }" + "   if (" + joinpointName + " != null)" + "   { " + "    " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
        return code;
    }
}

