/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.NullLoggerPlugin;

public class Logger
implements Serializable {
    static final long serialVersionUID = 4232175575988879434L;
    protected static String PLUGIN_CLASS_PROP = "org.jboss.logging.Logger.pluginClass";
    protected static final String LOG4J_PLUGIN_CLASS_NAME = "org.jboss.logging.Log4jLoggerPlugin";
    protected static Class pluginClass = null;
    protected static String pluginClassName = null;
    private final String name;
    protected transient LoggerPlugin loggerDelegate = null;

    public static String getPluginClassName() {
        return pluginClassName;
    }

    public static void setPluginClassName(String pluginClassName) {
        if (!pluginClassName.equals(Logger.pluginClassName)) {
            Logger.pluginClassName = pluginClassName;
            Logger.init();
        }
    }

    protected Logger(String name) {
        this.name = name;
        this.loggerDelegate = Logger.getDelegatePlugin(name);
    }

    public String getName() {
        return this.name;
    }

    public LoggerPlugin getLoggerPlugin() {
        return this.loggerDelegate;
    }

    public boolean isTraceEnabled() {
        return this.loggerDelegate.isTraceEnabled();
    }

    public void trace(Object message) {
        this.loggerDelegate.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.loggerDelegate.trace(message, t);
    }

    public boolean isDebugEnabled() {
        return this.loggerDelegate.isDebugEnabled();
    }

    public void debug(Object message) {
        this.loggerDelegate.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.loggerDelegate.debug(message, t);
    }

    public boolean isInfoEnabled() {
        return this.loggerDelegate.isInfoEnabled();
    }

    public void info(Object message) {
        this.loggerDelegate.info(message);
    }

    public void info(Object message, Throwable t) {
        this.loggerDelegate.info(message, t);
    }

    public void warn(Object message) {
        this.loggerDelegate.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.loggerDelegate.warn(message, t);
    }

    public void error(Object message) {
        this.loggerDelegate.error(message);
    }

    public void error(Object message, Throwable t) {
        this.loggerDelegate.error(message, t);
    }

    public void fatal(Object message) {
        this.loggerDelegate.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.loggerDelegate.fatal(message, t);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (pluginClass == null) {
            Logger.init();
        }
        this.loggerDelegate = Logger.getDelegatePlugin(this.name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(String name, String suffix) {
        return new Logger(name + "." + suffix);
    }

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz.getName());
    }

    public static Logger getLogger(Class clazz, String suffix) {
        return new Logger(clazz.getName() + "." + suffix);
    }

    protected static LoggerPlugin getDelegatePlugin(String name) {
        LoggerPlugin plugin = null;
        try {
            plugin = (LoggerPlugin)pluginClass.newInstance();
        }
        catch (Throwable e) {
            plugin = new NullLoggerPlugin();
        }
        try {
            plugin.init(name);
        }
        catch (Throwable e) {
            String extraInfo = e.getMessage();
            System.err.println("Failed to initalize plugin: " + plugin + (extraInfo != null ? ", cause: " + extraInfo : ""));
            plugin = new NullLoggerPlugin();
        }
        return plugin;
    }

    protected static void init() {
        try {
            if (pluginClassName == null) {
                pluginClassName = System.getProperty(PLUGIN_CLASS_PROP, LOG4J_PLUGIN_CLASS_NAME);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            pluginClass = cl.loadClass(pluginClassName);
        }
        catch (Throwable e) {
            pluginClass = NullLoggerPlugin.class;
        }
    }

    static {
        Logger.init();
    }
}

