/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.ConstructionInfo;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.MethodInterceptors;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.FieldComparator;
import org.jboss.aop.util.MethodHashing;
import org.jboss.util.NotImplementedException;

public class ClassAdvisor
extends Advisor {
    public static final String NOT_TRANSFORMABLE_SUFFIX = "$aop";
    protected TLongObjectHashMap unadvisedMethods = new TLongObjectHashMap();
    protected TLongObjectHashMap methodCalledByMethodBindings = new TLongObjectHashMap();
    protected HashMap backrefMethodCalledByMethodBindings = new HashMap();
    protected TLongObjectHashMap methodCalledByMethodInterceptors = new TLongObjectHashMap();
    protected TLongObjectHashMap conCalledByMethodBindings = new TLongObjectHashMap();
    protected HashMap backrefConCalledByMethodBindings = new HashMap();
    protected TLongObjectHashMap conCalledByMethodInterceptors = new TLongObjectHashMap();
    protected HashMap[] methodCalledByConBindings;
    protected HashMap[] methodCalledByConInterceptors;
    protected HashMap backrefMethodCalledByConstructorBindings = new HashMap();
    protected HashMap[] conCalledByConBindings;
    protected HashMap[] conCalledByConInterceptors;
    protected HashMap backrefConCalledByConstructorBindings = new HashMap();
    private Interceptor[][] fieldReadInterceptors;
    private FieldInfo[] fieldReadInfos;
    private Interceptor[][] fieldWriteInterceptors;
    private FieldInfo[] fieldWriteInfos;
    protected Field[] advisedFields;
    private HashMap fieldAspectsWithNoInstance = new HashMap();
    protected boolean initialized = false;
    private InterceptorChainObserver interceptorChainObserver;

    public ClassAdvisor(String classname, AspectManager manager) {
        super(classname, manager);
    }

    public ClassAdvisor(Class clazz, AspectManager manager) {
        this(clazz.getName(), manager);
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFieldAspect(FieldJoinpoint joinpoint, AspectDefinition def) {
        Object aspect;
        HashMap map = (HashMap)this.fieldAspectsWithNoInstance.get(def);
        if (map == null) {
            HashMap hashMap = this.fieldAspectsWithNoInstance;
            synchronized (hashMap) {
                map = (HashMap)this.fieldAspectsWithNoInstance.get(def);
                if (map == null) {
                    map = new HashMap();
                    this.fieldAspectsWithNoInstance.put(def, map);
                }
            }
        }
        if ((aspect = map.get(joinpoint)) == null) {
            HashMap hashMap = map;
            synchronized (hashMap) {
                aspect = map.get(joinpoint);
                if (aspect == null) {
                    aspect = def.getFactory().createPerJoinpoint(this, joinpoint);
                    map.put(joinpoint, aspect);
                }
            }
        }
        return aspect;
    }

    public Field[] getAdvisedFields() {
        return this.advisedFields;
    }

    public TLongObjectHashMap getAdvisedMethods() {
        return this.advisedMethods;
    }

    protected TLongObjectHashMap getUnadvisedMethods() {
        return this.unadvisedMethods;
    }

    public Constructor[] getConstructors() {
        return this.constructors;
    }

    public TLongObjectHashMap getMethodCalledByMethodInterceptors() {
        return this.methodCalledByMethodInterceptors;
    }

    public HashMap[] getMethodCalledByConInterceptors() {
        return this.methodCalledByConInterceptors;
    }

    public HashMap[] getConCalledByConInterceptors() {
        return this.conCalledByConInterceptors;
    }

    public TLongObjectHashMap getConCalledByMethodInterceptors() {
        return this.conCalledByMethodInterceptors;
    }

    public TLongObjectHashMap getMethodCalledByMethodBindings() {
        return this.methodCalledByMethodBindings;
    }

    public Interceptor[][] getFieldReadInterceptors() {
        throw new NotImplementedException("Use getFieldReadInfos");
    }

    public FieldInfo[] getFieldReadInfos() {
        return this.fieldReadInfos;
    }

    public Interceptor[][] getFieldWriteInterceptors() {
        throw new NotImplementedException("Use getFieldWriteInfos");
    }

    public FieldInfo[] getFieldWriteInfos() {
        return this.fieldWriteInfos;
    }

    public TLongObjectHashMap getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public synchronized void attachClass(final Class clazz) {
        if (this.initialized) {
            return;
        }
        try {
            final ClassAdvisor THIS = this;
            final AspectManager theManager = this.manager;
            this.manager.registerClassLoader(clazz.getClassLoader());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    theManager.attachMetaData(THIS, clazz);
                    ClassAdvisor.this.interfaceIntroductions.clear();
                    THIS.clazz = clazz;
                    ClassAdvisor.this.rebindClassMetaData();
                    theManager.applyInterfaceIntroductions((Advisor)THIS, clazz);
                    ClassAdvisor.this.createFieldTable();
                    ClassAdvisor.this.createMethodTables();
                    ClassAdvisor.this.createConstructorTables();
                    ClassAdvisor.this.populateMixinMethods();
                    ClassAdvisor.this.rebindClassMetaData();
                    ClassAdvisor.this.createInterceptorChains();
                    ClassAdvisor.this.initialized = true;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getException());
        }
    }

    private static Method getMethod(Class clazz, Method method) throws NoSuchMethodException {
        if (clazz == null || clazz.equals(Object.class)) {
            throw new NoSuchMethodException(method.getName());
        }
        try {
            String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
            return clazz.getMethod(wrappedName, method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return ClassAdvisor.getMethod(clazz.getSuperclass(), method);
        }
    }

    public int getConstructorIndex(Constructor constructor) {
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!constructor.equals(this.constructors[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFieldIndex(Field field) {
        for (int i = 0; i < this.advisedFields.length; ++i) {
            if (!field.equals(this.advisedFields[i])) continue;
            return i;
        }
        return -1;
    }

    protected void populateMixinMethods() throws Exception {
        ArrayList pointcuts = this.getInterfaceIntroductions();
        for (InterfaceIntroduction pointcut : pointcuts) {
            ArrayList mixins = pointcut.getMixins();
            for (int i = 0; i < mixins.size(); ++i) {
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixins.get(i);
                Thread.currentThread().getContextClassLoader().loadClass(mixin.getClassName());
                String[] interfaces = mixin.getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    Class<?> intf = Thread.currentThread().getContextClassLoader().loadClass(interfaces[j]);
                    Method[] methods = intf.getMethods();
                    for (int k = 0; k < methods.length; ++k) {
                        Method method = ClassAdvisor.getMethod(this.clazz, methods[k]);
                        long hash = MethodHashing.methodHash(method);
                        this.unadvisedMethods.put(hash, (Object)method);
                    }
                }
            }
        }
    }

    public synchronized void removeAdviceBinding(AdviceBinding binding) {
        this.removeCallerPointcut(binding);
        super.removeAdviceBinding(binding);
    }

    public synchronized void removeAdviceBindings(ArrayList bindings) {
        for (int i = 0; i < bindings.size(); ++i) {
            AdviceBinding binding = (AdviceBinding)bindings.get(i);
            this.removeCallerPointcut(binding);
        }
        this.adviceBindings.removeAll(bindings);
        this.rebuildInterceptors();
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    private void resolveFieldPointcut(ArrayList newFieldInfos, AdviceBinding binding, boolean write) {
        for (int i = 0; i < this.advisedFields.length; ++i) {
            Field field = this.advisedFields[i];
            if ((write || !binding.getPointcut().matchesGet((Advisor)this, field)) && (!write || !binding.getPointcut().matchesSet((Advisor)this, field))) continue;
            if (AspectManager.verbose) {
                System.err.println("[debug] field matched " + (write ? "write" : "read") + " binding: " + field);
            }
            this.adviceBindings.add(binding);
            binding.addAdvisor(this);
            FieldInfo info = (FieldInfo)newFieldInfos.get(i);
            this.pointcutResolved(info, binding, new FieldJoinpoint(field));
        }
    }

    protected MethodInterceptors initializeMethodChain() {
        MethodInterceptors newInterceptors = new MethodInterceptors(this);
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo info = new MethodInfo();
            Method amethod = (Method)this.advisedMethods.get(keys[i]);
            info.setAdvisedMethod(amethod);
            Method umethod = (Method)this.unadvisedMethods.get(keys[i]);
            if (umethod == null) {
                umethod = amethod;
            }
            info.setUnadvisedMethod(umethod);
            info.setHash(keys[i]);
            info.setAdvisor(this);
            newInterceptors.put(keys[i], info);
            try {
                Field infoField = this.clazz.getDeclaredField(MethodExecutionTransformer.getMethodInfoFieldName(amethod.getName(), keys[i]));
                infoField.setAccessible(true);
                infoField.set(null, new WeakReference<MethodInfo>(info));
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return newInterceptors;
    }

    protected ArrayList initializeFieldReadChain() {
        ArrayList<FieldInfo> chain = new ArrayList<FieldInfo>(this.advisedFields.length);
        for (int i = 0; i < this.advisedFields.length; ++i) {
            FieldInfo info = new FieldInfo();
            info.setAdvisedField(this.advisedFields[i]);
            info.setAdvisor(this);
            info.setIndex(i);
            try {
                info.setWrapper(this.clazz.getDeclaredMethod(FieldAccessTransformer.fieldRead(this.advisedFields[i].getName()), Object.class));
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            chain.add(info);
            try {
                Field infoField = this.clazz.getDeclaredField(FieldAccessTransformer.getFieldReadInfoFieldName(this.advisedFields[i].getName()));
                infoField.setAccessible(true);
                infoField.set(null, new WeakReference<FieldInfo>(info));
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return chain;
    }

    protected ArrayList initializeFieldWriteChain() {
        ArrayList<FieldInfo> chain = new ArrayList<FieldInfo>(this.advisedFields.length);
        for (int i = 0; i < this.advisedFields.length; ++i) {
            FieldInfo info = new FieldInfo();
            info.setAdvisedField(this.advisedFields[i]);
            info.setAdvisor(this);
            info.setIndex(i);
            try {
                info.setWrapper(this.clazz.getDeclaredMethod(FieldAccessTransformer.fieldWrite(this.advisedFields[i].getName()), Object.class, this.advisedFields[i].getType()));
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            chain.add(info);
            try {
                Field infoField = this.clazz.getDeclaredField(FieldAccessTransformer.getFieldWriteInfoFieldName(this.advisedFields[i].getName()));
                infoField.setAccessible(true);
                infoField.set(null, new WeakReference<FieldInfo>(info));
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return chain;
    }

    protected void finalizeFieldReadChain(ArrayList newFieldInfos) {
        for (int i = 0; i < newFieldInfos.size(); ++i) {
            FieldInfo info = (FieldInfo)newFieldInfos.get(i);
            ArrayList list = info.getInterceptorChain();
            Interceptor[] interceptors = null;
            if (list.size() > 0) {
                interceptors = this.applyPrecedence(list.toArray(new Interceptor[list.size()]));
            }
            info.setInterceptors(interceptors);
        }
    }

    protected void finalizeFieldWriteChain(ArrayList newFieldInfos) {
        for (int i = 0; i < newFieldInfos.size(); ++i) {
            FieldInfo info = (FieldInfo)newFieldInfos.get(i);
            ArrayList list = info.getInterceptorChain();
            Interceptor[] interceptors = null;
            if (list.size() > 0) {
                interceptors = this.applyPrecedence(list.toArray(new Interceptor[list.size()]));
            }
            info.setInterceptors(interceptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInterceptorChains() throws Exception {
        if (AspectManager.verbose) {
            System.out.println("[debug] Creating chains for " + this.clazz + " " + (this.clazz != null ? this.clazz.getClassLoader() : null));
        }
        MethodInterceptors newMethodInfos = this.initializeMethodChain();
        ArrayList newFieldReadInfos = this.initializeFieldReadChain();
        ArrayList newFieldWriteInfos = this.initializeFieldWriteChain();
        ArrayList newConstructorInfos = this.initializeConstructorChain();
        ArrayList newConstructionInfos = this.initializeConstructionChain();
        LinkedHashMap linkedHashMap = this.manager.getBindings();
        synchronized (linkedHashMap) {
            for (AdviceBinding binding : this.manager.getBindings().values()) {
                if (AspectManager.verbose) {
                    System.out.println("[debug] iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr());
                }
                this.resolveMethodPointcut(newMethodInfos, binding);
                this.resolveFieldPointcut(newFieldReadInfos, binding, false);
                this.resolveFieldPointcut(newFieldWriteInfos, binding, true);
                this.resolveConstructorPointcut(newConstructorInfos, binding);
                this.resolveConstructionPointcut(newConstructionInfos, binding);
            }
        }
        this.finalizeMethodChain(newMethodInfos);
        this.finalizeFieldReadChain(newFieldReadInfos);
        this.finalizeFieldWriteChain(newFieldWriteInfos);
        this.finalizeConstructorChain(newConstructorInfos);
        this.finalizeConstructionChain(newConstructionInfos);
        this.fieldReadInfos = newFieldReadInfos.toArray(new FieldInfo[newFieldReadInfos.size()]);
        this.fieldWriteInfos = newFieldWriteInfos.toArray(new FieldInfo[newFieldWriteInfos.size()]);
        this.constructorInfos = newConstructorInfos.toArray(new ConstructorInfo[newConstructorInfos.size()]);
        this.constructionInfos = newConstructionInfos.toArray(new ConstructionInfo[newConstructionInfos.size()]);
        this.populateInterceptorsFromInfos();
        boolean bl = this.doesHaveAspects = this.adviceBindings.size() > 0;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.interceptorChainsUpdated(this.fieldReadInterceptors, this.fieldWriteInterceptors, this.constructorInterceptors, this.methodInterceptors);
        }
    }

    private MethodByMethodInfo initializeCallerInterceptorsMap(long callingMethodHash, String calledClass, long calledMethodHash, Method callingMethod, Method calledMethod) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodInterceptors.get(callingMethodHash);
        if (calledClassesMap == null) {
            calledClassesMap = new HashMap<String, TLongObjectHashMap>();
            this.methodCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        calledMethod.setAccessible(true);
        Class<?> calledClazz = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
        MethodByMethodInfo info = new MethodByMethodInfo((Advisor)this, calledClazz, calledMethod, callingMethodHash, calledMethodHash, null);
        calledMethodsMap.put(calledMethodHash, (Object)info);
        return info;
    }

    private ConByMethodInfo initializeConCalledByMethodInterceptorsMap(long callingMethodHash, String calledClass, long calledConHash, Constructor calledCon) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodInterceptors.get(callingMethodHash);
        if (calledClassesMap == null) {
            calledClassesMap = new HashMap<String, TLongObjectHashMap>();
            this.conCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        ConByMethodInfo info = this.createConByMethodInfo(calledClass, callingMethodHash, calledCon, calledConHash);
        calledMethodsMap.put(calledConHash, (Object)info);
        return info;
    }

    private ConByMethodInfo createConByMethodInfo(String calledClass, long callingMethodHash, Constructor calledCon, long calledConHash) throws Exception {
        calledCon.setAccessible(true);
        Class<?> calledClazz = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
        try {
            int index = calledClass.lastIndexOf(46);
            String baseClassName = calledClass.substring(index + 1);
            Method wrapper = calledCon.getDeclaringClass().getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(baseClassName), calledCon.getParameterTypes());
            return new ConByMethodInfo((Advisor)this, calledClazz, callingMethodHash, calledCon, calledConHash, wrapper, null);
        }
        catch (NoSuchMethodException e) {
            return new ConByMethodInfo((Advisor)this, calledClazz, callingMethodHash, calledCon, calledConHash, null, null);
        }
    }

    private MethodByConInfo initializeConstructorCallerInterceptorsMap(int callingIndex, String calledClass, long calledMethodHash, Method calledMethod) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = this.methodCalledByConInterceptors[callingIndex];
        if (calledClassesMap == null) {
            this.methodCalledByConInterceptors[callingIndex] = calledClassesMap = new HashMap<String, TLongObjectHashMap>();
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        calledMethod.setAccessible(true);
        Class<?> calledClazz = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
        MethodByConInfo info = new MethodByConInfo((Advisor)this, calledClazz, callingIndex, calledMethod, calledMethodHash, null);
        calledMethodsMap.put(calledMethodHash, (Object)info);
        return info;
    }

    private ConByConInfo initializeConCalledByConInterceptorsMap(int callingIndex, String calledClass, long calledConHash, Constructor calledCon) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = this.conCalledByConInterceptors[callingIndex];
        if (calledClassesMap == null) {
            this.conCalledByConInterceptors[callingIndex] = calledClassesMap = new HashMap<String, TLongObjectHashMap>();
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        ConByConInfo info = this.createConByConInfo(callingIndex, calledClass, calledCon, calledConHash);
        calledMethodsMap.put(calledConHash, (Object)info);
        return info;
    }

    private ConByConInfo createConByConInfo(int callingIndex, String calledClass, Constructor calledCon, long calledConHash) throws Exception {
        calledCon.setAccessible(true);
        Class<?> calledClazz = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
        try {
            int index = calledClass.lastIndexOf(46);
            String baseClassName = calledClass.substring(index + 1);
            Method wrapper = calledCon.getDeclaringClass().getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(baseClassName), calledCon.getParameterTypes());
            return new ConByConInfo((Advisor)this, calledClazz, callingIndex, calledCon, calledConHash, wrapper, null);
        }
        catch (NoSuchMethodException e) {
            return new ConByConInfo((Advisor)this, calledClazz, callingIndex, calledCon, calledConHash, null, null);
        }
    }

    protected void rebuildCallerInterceptors() throws Exception {
        long[] calledKeys;
        TLongObjectHashMap calledMethods;
        String cname;
        ArrayList bindings;
        int j;
        long[] calledKeys2;
        String cname2;
        HashMap calledClasses;
        int i;
        long[] callingKeys = this.methodCalledByMethodInterceptors.keys();
        for (i = 0; i < callingKeys.length; ++i) {
            long callingHash = callingKeys[i];
            calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingHash);
            for (Map.Entry entry : calledClasses.entrySet()) {
                cname2 = (String)entry.getKey();
                TLongObjectHashMap calledMethods2 = (TLongObjectHashMap)entry.getValue();
                calledKeys2 = calledMethods2.keys();
                for (j = 0; j < calledKeys2.length; ++j) {
                    long calledHash = calledKeys2[j];
                    bindings = this.getCallerBindings(callingHash, cname2, calledHash);
                    Method calling = MethodHashing.findMethodByHash(this.clazz, callingHash);
                    this.bindCallerInterceptorChain(bindings, callingHash, cname2, calledHash, calling);
                }
            }
        }
        for (i = 0; i < this.methodCalledByConInterceptors.length; ++i) {
            HashMap calledClasses2 = this.methodCalledByConInterceptors[i];
            if (calledClasses2 == null) continue;
            for (Map.Entry entry : calledClasses2.entrySet()) {
                cname = (String)entry.getKey();
                calledMethods = (TLongObjectHashMap)entry.getValue();
                calledKeys = calledMethods.keys();
                for (int j2 = 0; j2 < calledKeys.length; ++j2) {
                    long calledHash = calledKeys[j2];
                    ArrayList bindings2 = this.getConstructorCallerBindings(i, cname, calledHash);
                    this.bindConstructorCallerInterceptorChain(bindings2, i, cname, calledHash);
                }
            }
        }
        callingKeys = this.conCalledByMethodInterceptors.keys();
        for (i = 0; i < callingKeys.length; ++i) {
            long callingHash = callingKeys[i];
            calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingHash);
            for (Map.Entry entry : calledClasses.entrySet()) {
                cname2 = (String)entry.getKey();
                TLongObjectHashMap calledMethods3 = (TLongObjectHashMap)entry.getValue();
                calledKeys2 = calledMethods3.keys();
                for (j = 0; j < calledKeys2.length; ++j) {
                    long calledHash = calledKeys2[j];
                    bindings = this.getConCalledByMethodBindings(callingHash, cname2, calledHash);
                    this.bindConCalledByMethodInterceptorChain(bindings, callingHash, cname2, calledHash);
                }
            }
        }
        for (i = 0; i < this.conCalledByConInterceptors.length; ++i) {
            HashMap calledClasses3 = this.conCalledByConInterceptors[i];
            if (calledClasses3 == null) continue;
            for (Map.Entry entry : calledClasses3.entrySet()) {
                cname = (String)entry.getKey();
                calledMethods = (TLongObjectHashMap)entry.getValue();
                calledKeys = calledMethods.keys();
                for (int j3 = 0; j3 < calledKeys.length; ++j3) {
                    long calledHash = calledKeys[j3];
                    ArrayList bindings3 = this.getConCalledByConBindings(i, cname, calledHash);
                    this.bindConCalledByConInterceptorChain(bindings3, i, cname, calledHash);
                }
            }
        }
    }

    private ArrayList getCallerBindings(long callingHash, String cname, long calledHash) {
        HashMap calledClasses = (HashMap)this.methodCalledByMethodBindings.get(callingHash);
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledMethods.get(calledHash);
    }

    private ArrayList getConCalledByMethodBindings(long callingHash, String cname, long calledHash) {
        HashMap calledClasses = (HashMap)this.conCalledByMethodBindings.get(callingHash);
        TLongObjectHashMap calledCons = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledCons.get(calledHash);
    }

    private ArrayList getConstructorCallerBindings(int callingIndex, String cname, long calledHash) {
        HashMap calledClasses = this.methodCalledByConBindings[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledMethods.get(calledHash);
    }

    private ArrayList getConCalledByConBindings(int callingIndex, String cname, long calledHash) {
        HashMap calledClasses = this.conCalledByConBindings[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledMethods.get(calledHash);
    }

    private void bindCallerInterceptorChain(ArrayList bindings, long callingHash, String cname, long calledHash, Method calling) {
        MethodByMethodInfo info = this.getCallerMethodInfo(callingHash, cname, calledHash);
        info.clear();
        for (AdviceBinding binding : bindings) {
            this.pointcutResolved(info, binding, new MethodCalledByMethodJoinpoint(info.getCallingMethod(), info.getMethod()));
        }
        this.finalizeMethodCalledByMethodInterceptorChain(info);
    }

    protected void finalizeMethodCalledByMethodInterceptorChain(MethodByMethodInfo info) {
        ArrayList list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = list.toArray(new Interceptor[list.size()]);
        }
        info.setInterceptors(interceptors);
    }

    private void bindConCalledByMethodInterceptorChain(ArrayList bindings, long callingHash, String cname, long calledHash) throws Exception {
        ConByMethodInfo info = this.getConCalledByMethod(callingHash, cname, calledHash);
        info.clear();
        for (AdviceBinding binding : bindings) {
            this.pointcutResolved(info, binding, new ConstructorCalledByMethodJoinpoint(info.getCallingMethod(), info.getConstructor()));
        }
        this.finalizeConCalledByMethodInterceptorChain(info);
    }

    protected void finalizeConCalledByMethodInterceptorChain(ConByMethodInfo info) {
        ArrayList list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = list.toArray(new Interceptor[list.size()]);
        }
        info.setInterceptors(interceptors);
    }

    private void bindConCalledByConInterceptorChain(ArrayList bindings, int callingIndex, String cname, long calledHash) {
        ConByConInfo info = this.getConCalledByCon(callingIndex, cname, calledHash);
        info.clear();
        for (AdviceBinding binding : bindings) {
            this.pointcutResolved(info, binding, new ConstructorCalledByConstructorJoinpoint(info.getCalling(), info.getConstructor()));
        }
        this.finalizeConCalledByConInterceptorChain(info);
    }

    protected void finalizeConCalledByConInterceptorChain(ConByConInfo info) {
        ArrayList list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = list.toArray(new Interceptor[list.size()]);
        }
        info.setInterceptors(interceptors);
    }

    private void bindConstructorCallerInterceptorChain(ArrayList bindings, int callingIndex, String cname, long calledHash) {
        MethodByConInfo info = this.getConstructorCallerMethodInfo(callingIndex, cname, calledHash);
        info.clear();
        for (AdviceBinding binding : bindings) {
            this.pointcutResolved(info, binding, new MethodCalledByConstructorJoinpoint(info.getCalling(), info.getMethod()));
        }
        this.finalizeMethodCalledByConInterceptorChain(info);
    }

    protected void finalizeMethodCalledByConInterceptorChain(MethodByConInfo info) {
        ArrayList list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = list.toArray(new Interceptor[list.size()]);
        }
        info.setInterceptors(interceptors);
    }

    protected void rebuildInterceptors() {
        if (this.initialized) {
            if (System.getSecurityManager() == null) {
                RebuildInterceptorsAction.NON_PRIVILEGED.rebuildInterceptors(this);
            } else {
                RebuildInterceptorsAction.PRIVILEGED.rebuildInterceptors(this);
            }
        }
    }

    protected void doRebuildInterceptors() {
        try {
            this.adviceBindings.clear();
            this.createInterceptorChains();
            this.rebuildCallerInterceptors();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void bindClassMetaData(ClassMetaDataBinding data) {
        try {
            Constructor[] cons;
            ClassMetaDataLoader loader = data.getLoader();
            Object[] objs = this.advisedMethods.getValues();
            Method[] methods = new Method[objs.length];
            Field[] fields = this.advisedFields;
            if (fields == null) {
                fields = new Field[]{};
            }
            if ((cons = this.constructors) == null) {
                cons = new Constructor[]{};
            }
            for (int i = 0; i < objs.length; ++i) {
                methods[i] = (Method)objs[i];
            }
            loader.bind((Advisor)this, data, methods, fields, cons);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void rebindClassMetaData() {
        this.defaultMetaData.clear();
        this.methodMetaData.clear();
        this.fieldMetaData.clear();
        this.constructorMetaData.clear();
        this.classMetaData.clear();
        for (int i = 0; i < this.classMetaDataBindings.size(); ++i) {
            ClassMetaDataBinding data = (ClassMetaDataBinding)this.classMetaDataBindings.get(i);
            this.bindClassMetaData(data);
        }
        this.deployAnnotationOverrides();
    }

    public synchronized void addClassMetaData(ClassMetaDataBinding data) {
        this.classMetaDataBindings.add(data);
        if (this.clazz == null) {
            return;
        }
        this.bindClassMetaData(data);
        this.adviceBindings.clear();
        this.doesHaveAspects = false;
        this.rebuildInterceptors();
    }

    public synchronized void removeClassMetaData(ClassMetaDataBinding data) {
        if (this.classMetaDataBindings.remove(data)) {
            if (this.clazz == null) {
                return;
            }
            this.rebindClassMetaData();
            this.adviceBindings.clear();
            this.doesHaveAspects = false;
            this.rebuildInterceptors();
        }
    }

    private void initializeEmptyCallerChain(long callingMethodHash, String calledClass, long calledMethodHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledMethodHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledMethodHash, bindings);
        }
    }

    private void initializeConCalledByMethodEmptyChain(long callingMethodHash, String calledClass, long calledConHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledConHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledConHash, bindings);
        }
    }

    private void initializeEmptyConstructorCallerChain(int callingIndex, String calledClass, long calledMethodHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingCon = this.methodCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.methodCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledMethodHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledMethodHash, bindings);
        }
    }

    private void initializeConCalledByConEmptyChain(int callingIndex, String calledClass, long calledConHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingCon = this.conCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.conCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledConHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledConHash, bindings);
        }
    }

    private void addMethodCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("method call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledMethodHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefMethodCalledByMethodBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefMethodCalledByMethodBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    private void addConstructorCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("method call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledMethodHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefConCalledByMethodBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefConCalledByMethodBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    public void addConstructorCallerPointcut(int callingIndex, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("constructor call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingCon = this.methodCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.methodCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledMethodHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefMethodCalledByConstructorBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefMethodCalledByConstructorBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    private void addConstructorCalledByConPointcut(int callingIndex, String calledClass, long calledConHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("constructor call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingCon = this.conCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.conCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledConHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledConHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefConCalledByConstructorBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefConCalledByConstructorBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    private void removeCallerPointcut(AdviceBinding binding) {
        ArrayList backrefs = (ArrayList)this.backrefMethodCalledByMethodBindings.get(binding.getName());
        if (backrefs == null) {
            return;
        }
        for (int i = 0; i < backrefs.size(); ++i) {
            ArrayList ref = (ArrayList)backrefs.get(i);
            ref.remove(binding);
        }
    }

    public static String notAdvisedMethodName(String className, String methodName) {
        return className.replace('.', '$') + "$" + methodName + NOT_TRANSFORMABLE_SUFFIX;
    }

    public static boolean isWithoutAdvisement(String name) {
        return name.endsWith(NOT_TRANSFORMABLE_SUFFIX);
    }

    public static boolean isAdvisable(Method method) {
        int modifiers = method.getModifiers();
        return !(ClassAdvisor.isWithoutAdvisement(method.getName()) || Modifier.isAbstract(modifiers) || Modifier.isNative(modifiers) || method.getName().equals("_getAdvisor") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Advisor.class) || method.getName().equals("_getClassAdvisor") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Advisor.class) || method.getName().equals("_getInstanceAdvisor") && method.getParameterTypes().length == 0 && method.getReturnType().equals(InstanceAdvisor.class) || method.getName().equals("_setInstanceAdvisor") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(InstanceAdvisor.class));
    }

    private void populateFieldTable(ArrayList fields, Class superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateFieldTable(fields, superclass.getSuperclass());
        ArrayList<Field> temp = new ArrayList<Field>();
        Field[] declaredFields = superclass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!Advisable.isAdvisable(declaredFields[i])) continue;
            declaredFields[i].setAccessible(true);
            temp.add(declaredFields[i]);
        }
        Collections.sort(temp, FieldComparator.INSTANCE);
        fields.addAll(temp);
    }

    private void createFieldTable() throws Exception {
        ArrayList fields = new ArrayList();
        this.populateFieldTable(fields, this.clazz);
        this.advisedFields = fields.toArray(new Field[fields.size()]);
    }

    protected void addDeclaredMethods(Class superclass) throws Exception {
        Method[] declaredMethods = superclass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            if (!ClassAdvisor.isAdvisable(declaredMethods[i])) continue;
            long hash = MethodHashing.methodHash(declaredMethods[i]);
            this.advisedMethods.put(hash, (Object)declaredMethods[i]);
            try {
                Method m = declaredMethods[i];
                Method un = superclass.getDeclaredMethod(ClassAdvisor.notAdvisedMethodName(superclass.getName(), m.getName()), m.getParameterTypes());
                un.setAccessible(true);
                this.unadvisedMethods.put(hash, (Object)un);
                continue;
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
    }

    private void populateMethodTables(Class superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateMethodTables(superclass.getSuperclass());
        Advisor superAdvisor = this.manager.getAnyAdvisorIfAdvised(superclass);
        if (superAdvisor != null && superAdvisor instanceof ClassAdvisor) {
            TLongObjectHashMap superHash = ((ClassAdvisor)superAdvisor).getUnadvisedMethods();
            long[] keys = superHash.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.unadvisedMethods.put(keys[i], superHash.get(keys[i]));
            }
        }
        this.addDeclaredMethods(superclass);
    }

    private void createMethodTables() throws Exception {
        this.populateMethodTables(this.clazz.getSuperclass());
        this.addDeclaredMethods(this.clazz);
    }

    private void createConstructorTables() throws Exception {
        this.constructors = this.clazz.getDeclaredConstructors();
        this.methodCalledByConBindings = new HashMap[this.constructors.length];
        this.methodCalledByConInterceptors = new HashMap[this.constructors.length];
        this.conCalledByConBindings = new HashMap[this.constructors.length];
        this.conCalledByConInterceptors = new HashMap[this.constructors.length];
        for (int i = 0; i < this.constructors.length; ++i) {
            this.constructors[i].setAccessible(true);
        }
        Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
    }

    public MethodByMethodInfo resolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
        if (System.getSecurityManager() == null) {
            return ResolveCallerMethodInfoAction.NON_PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledMethodHash);
        }
        return ResolveCallerMethodInfoAction.PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledMethodHash);
    }

    private MethodByMethodInfo doResolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
        try {
            Method callingMethod = MethodHashing.findMethodByHash(this.clazz, callingMethodHash);
            if (callingMethod == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
            if (calledMethod == null) {
                throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
            }
            Iterator it = this.manager.getBindings().values().iterator();
            boolean matched = false;
            while (it.hasNext()) {
                AdviceBinding binding = (AdviceBinding)it.next();
                if (!binding.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingMethod, called, calledMethod)) continue;
                this.addMethodCalledByMethodPointcut(callingMethodHash, calledClass, calledMethodHash, binding);
                matched = true;
            }
            if (!matched) {
                this.initializeEmptyCallerChain(callingMethodHash, calledClass, calledMethodHash);
            }
            MethodByMethodInfo info = this.initializeCallerInterceptorsMap(callingMethodHash, calledClass, calledMethodHash, callingMethod, calledMethod);
            ArrayList bindings = this.getCallerBindings(callingMethodHash, calledClass, calledMethodHash);
            this.bindCallerInterceptorChain(bindings, callingMethodHash, calledClass, calledMethodHash, callingMethod);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public WeakReference resolveCallerMethodInfoAsWeakReference(long callingMethodHash, String calledClass, long calledMethodHash) {
        return new WeakReference<MethodByMethodInfo>(this.resolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash));
    }

    public ConByMethodInfo resolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash) {
        if (System.getSecurityManager() == null) {
            return ResolveCallerConstuctorInfoAction.NON_PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledConHash);
        }
        return ResolveCallerConstuctorInfoAction.PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledConHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConByMethodInfo doResolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash) {
        try {
            Method callingMethod = MethodHashing.findMethodByHash(this.clazz, callingMethodHash);
            if (callingMethod == null) {
                throw new RuntimeException("Unable to figure out calling method of a constructor caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Constructor calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
            if (calledCon == null) {
                throw new RuntimeException("Unable to figure out calledcon of a constructor caller pointcut");
            }
            boolean matched = false;
            LinkedHashMap linkedHashMap = this.manager.getBindings();
            synchronized (linkedHashMap) {
                for (AdviceBinding binding : this.manager.getBindings().values()) {
                    if (!binding.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingMethod, called, calledCon)) continue;
                    this.addConstructorCalledByMethodPointcut(callingMethodHash, calledClass, calledConHash, binding);
                    matched = true;
                }
            }
            if (!matched) {
                this.initializeConCalledByMethodEmptyChain(callingMethodHash, calledClass, calledConHash);
            }
            ConByMethodInfo info = this.initializeConCalledByMethodInterceptorsMap(callingMethodHash, calledClass, calledConHash, calledCon);
            ArrayList bindings = this.getConCalledByMethodBindings(callingMethodHash, calledClass, calledConHash);
            this.bindConCalledByMethodInterceptorChain(bindings, callingMethodHash, calledClass, calledConHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public WeakReference resolveCallerConstructorInfoAsWeakReference(long callingMethodHash, String calledClass, long calledConHash) {
        return new WeakReference<ConByMethodInfo>(this.resolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash));
    }

    public MethodByConInfo resolveConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
        if (System.getSecurityManager() == null) {
            return ResolveConstructorCallerMethodInfoAction.NON_PRIVILEGED.resolveInfo(this, callingIndex, calledClass, calledMethodHash);
        }
        return ResolveConstructorCallerMethodInfoAction.PRIVILEGED.resolveInfo(this, callingIndex, calledClass, calledMethodHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodByConInfo doResolveConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
            if (calledMethod == null) {
                throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
            }
            boolean matched = false;
            LinkedHashMap linkedHashMap = this.manager.getBindings();
            synchronized (linkedHashMap) {
                for (AdviceBinding binding : this.manager.getBindings().values()) {
                    if (!binding.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingConstructor, called, calledMethod)) continue;
                    this.addConstructorCallerPointcut(callingIndex, calledClass, calledMethodHash, binding);
                    matched = true;
                }
            }
            if (!matched) {
                this.initializeEmptyConstructorCallerChain(callingIndex, calledClass, calledMethodHash);
            }
            MethodByConInfo info = this.initializeConstructorCallerInterceptorsMap(callingIndex, calledClass, calledMethodHash, calledMethod);
            ArrayList bindings = this.getConstructorCallerBindings(callingIndex, calledClass, calledMethodHash);
            this.bindConstructorCallerInterceptorChain(bindings, callingIndex, calledClass, calledMethodHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public WeakReference resolveConstructorCallerMethodInfoAsWeakReference(int callingIndex, String calledClass, long calledMethodHash) {
        return new WeakReference<MethodByConInfo>(this.resolveConstructorCallerMethodInfo(callingIndex, calledClass, calledMethodHash));
    }

    public ConByConInfo resolveConstructorCallerConstructorInfo(int callingIndex, String calledClass, long calledConHash) {
        if (System.getSecurityManager() == null) {
            return ResolveConstructorCallerConstructorInfoAction.NON_PRIVILEGED.resolveInfo(this, callingIndex, calledClass, calledConHash);
        }
        return ResolveConstructorCallerConstructorInfoAction.PRIVILEGED.resolveInfo(this, callingIndex, calledClass, calledConHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConByConInfo doResolveConstructorCallerConstructorInfo(int callingIndex, String calledClass, long calledConHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Constructor calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
            if (calledCon == null) {
                throw new RuntimeException("Unable to figure out calledcon of a caller pointcut");
            }
            boolean matched = false;
            LinkedHashMap linkedHashMap = this.manager.getBindings();
            synchronized (linkedHashMap) {
                for (AdviceBinding binding : this.manager.getBindings().values()) {
                    if (!binding.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingConstructor, called, calledCon)) continue;
                    this.addConstructorCalledByConPointcut(callingIndex, calledClass, calledConHash, binding);
                    matched = true;
                }
            }
            if (!matched) {
                this.initializeConCalledByConEmptyChain(callingIndex, calledClass, calledConHash);
            }
            ConByConInfo info = this.initializeConCalledByConInterceptorsMap(callingIndex, calledClass, calledConHash, calledCon);
            ArrayList bindings = this.getConCalledByConBindings(callingIndex, calledClass, calledConHash);
            this.bindConCalledByConInterceptorChain(bindings, callingIndex, calledClass, calledConHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public WeakReference resolveConstructorCallerConstructorInfoAsWeakReference(int callingIndex, String calledClass, long calledConHash) {
        return new WeakReference<ConByConInfo>(this.resolveConstructorCallerConstructorInfo(callingIndex, calledClass, calledConHash));
    }

    public Object invokeWithoutAdvisement(Object target, long methodHash, Object[] arguments) throws Throwable {
        try {
            Method method = (Method)this.unadvisedMethods.get(methodHash);
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object invokeNewWithoutAdvisement(Object[] arguments, Constructor constructor) throws Throwable {
        try {
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException in) {
            throw new RuntimeException("failed to call constructor", in);
        }
        catch (IllegalAccessException ill) {
            throw new RuntimeException("illegal access", ill);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    public Object invokeMethod(long methodHash, Object[] arguments) throws Throwable {
        return this.invokeMethod(null, methodHash, arguments);
    }

    public Object invokeMethod(Object target, long methodHash, Object[] arguments) throws Throwable {
        InstanceAdvisor advisor = null;
        if (target != null) {
            InstanceAdvised advised = (InstanceAdvised)target;
            advisor = advised._getInstanceAdvisor();
        }
        MethodInfo info = (MethodInfo)this.methodInterceptors.get(methodHash);
        return this.invokeMethod(advisor, target, methodHash, arguments, info);
    }

    public Object invokeMethod(InstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments) throws Throwable {
        MethodInfo info = (MethodInfo)this.methodInterceptors.get(methodHash);
        if (info == null) {
            System.out.println("info is null for hash: " + methodHash + " of " + this.clazz.getName());
        }
        return this.invokeMethod(instanceAdvisor, target, methodHash, arguments, info);
    }

    public Object invokeMethod(InstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments, MethodInfo info) throws Throwable {
        Interceptor[] aspects = info.getInterceptors();
        if (instanceAdvisor != null && instanceAdvisor.hasInterceptors()) {
            aspects = instanceAdvisor.getInterceptors(aspects);
        }
        MethodInvocation invocation = new MethodInvocation(info, aspects);
        invocation.setArguments(arguments);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeCaller(long callingMethodHash, Object target, Object[] args, CallerMethodInfo info, Object callingObject) throws Throwable {
        return this.invokeCaller((MethodByMethodInfo)info, callingObject, target, args);
    }

    public Object invokeCaller(MethodByMethodInfo info, Object callingObject, Object target, Object[] args) throws Throwable {
        MethodCalledByMethodInvocation invocation = new MethodCalledByMethodInvocation(info, callingObject, target, args, info.getInterceptors());
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeConCalledByMethod(long callingMethodHash, Object[] args, CallerConstructorInfo info, Object callingObject) throws Throwable {
        return this.invokeConCalledByMethod((ConByMethodInfo)info, callingObject, args);
    }

    public Object invokeConCalledByMethod(ConByMethodInfo info, Object callingObject, Object[] args) throws Throwable {
        ConstructorCalledByMethodInvocation invocation = new ConstructorCalledByMethodInvocation(info, callingObject, args, info.getInterceptors());
        return invocation.invokeNext();
    }

    public Object invokeConstructorCaller(int callingIndex, Object target, Object[] args, CallerMethodInfo info) throws Throwable {
        return this.invokeConstructorCaller((MethodByConInfo)info, target, args);
    }

    public Object invokeConstructorCaller(MethodByConInfo info, Object target, Object[] args) throws Throwable {
        MethodCalledByConstructorInvocation invocation = new MethodCalledByConstructorInvocation(info, target, args, info.getInterceptors());
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeConCalledByCon(int callingIndex, Object[] args, CallerConstructorInfo info) throws Throwable {
        return this.invokeConCalledByCon((ConByConInfo)info, args);
    }

    public Object invokeConCalledByCon(ConByConInfo info, Object[] args) throws Throwable {
        ConstructorCalledByConstructorInvocation invocation = new ConstructorCalledByConstructorInvocation(info, args, info.getInterceptors());
        return invocation.invokeNext();
    }

    private MethodByMethodInfo getCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
        HashMap calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingMethodHash);
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        MethodByMethodInfo info = (MethodByMethodInfo)calledMethods.get(calledMethodHash);
        return info;
    }

    private ConByMethodInfo getConCalledByMethod(long callingMethodHash, String calledClass, long calledConHash) {
        HashMap calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingMethodHash);
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        ConByMethodInfo info = (ConByMethodInfo)calledMethods.get(calledConHash);
        return info;
    }

    private MethodByConInfo getConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
        HashMap calledClasses = this.methodCalledByConInterceptors[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        MethodByConInfo info = (MethodByConInfo)calledMethods.get(calledMethodHash);
        return info;
    }

    private ConByConInfo getConCalledByCon(int callingIndex, String calledClass, long calledConHash) {
        HashMap calledClasses = this.conCalledByConInterceptors[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        ConByConInfo info = (ConByConInfo)calledMethods.get(calledConHash);
        return info;
    }

    public Object invokeNew(Object[] args, int idx) throws Throwable {
        Interceptor[] cInterceptors = this.constructorInfos[idx].getInterceptors();
        if (cInterceptors == null) {
            cInterceptors = new Interceptor[]{};
        }
        ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
        invocation.setAdvisor(this);
        invocation.setArguments(args);
        invocation.setConstructor(this.constructors[idx]);
        return invocation.invokeNext();
    }

    public Object invokeRead(Object target, int index) throws Throwable {
        InstanceAdvised advised;
        InstanceAdvisor advisor;
        Interceptor[] aspects = this.fieldReadInfos[index].getInterceptors();
        if (aspects == null) {
            aspects = new Interceptor[]{};
        }
        if (target != null && (advisor = (advised = (InstanceAdvised)target)._getInstanceAdvisor()) != null && advisor.hasInterceptors()) {
            aspects = advisor.getInterceptors(aspects);
        }
        FieldReadInvocation invocation = new FieldReadInvocation(this.advisedFields[index], index, aspects);
        invocation.setAdvisor(this);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeWrite(Object target, int index, Object value) throws Throwable {
        InstanceAdvised advised;
        InstanceAdvisor advisor;
        Interceptor[] aspects = this.fieldWriteInfos[index].getInterceptors();
        if (aspects == null) {
            aspects = new Interceptor[]{};
        }
        if (target != null && (advisor = (advised = (InstanceAdvised)target)._getInstanceAdvisor()) != null && advisor.hasInterceptors()) {
            aspects = advised._getInstanceAdvisor().getInterceptors(aspects);
        }
        FieldWriteInvocation invocation = new FieldWriteInvocation(this.advisedFields[index], index, value, aspects);
        invocation.setAdvisor(this);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof FieldWriteInvocation) {
            FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
            Object target = fieldInvocation.getTargetObject();
            Object val = fieldInvocation.getValue();
            Field field = fieldInvocation.getField();
            field.set(target, val);
            return null;
        }
        if (invocation instanceof FieldReadInvocation) {
            FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
            Object target = fieldInvocation.getTargetObject();
            Field field = fieldInvocation.getField();
            return field.get(target);
        }
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            return this.invokeWithoutAdvisement(methodInvocation.getTargetObject(), methodInvocation.getMethodHash(), methodInvocation.getArguments());
        }
        if (invocation instanceof ConstructorInvocation) {
            ConstructorInvocation cInvocation = (ConstructorInvocation)invocation;
            Object[] arguments = cInvocation.getArguments();
            Constructor constructor = cInvocation.getConstructor();
            return this.invokeNewWithoutAdvisement(arguments, constructor);
        }
        throw new IllegalStateException("Unknown Invocation type: " + invocation.getClass().getName());
    }

    protected InterceptorChainObserver getInterceptorChainObserver() {
        return this.interceptorChainObserver;
    }

    protected void setInterceptorChainObserver(InterceptorChainObserver observer) {
        if (observer != null) {
            observer.initialInterceptorChains(this.clazz, this.fieldReadInterceptors, this.fieldWriteInterceptors, this.constructorInterceptors, this.methodInterceptors);
        }
        this.interceptorChainObserver = observer;
    }

    protected void populateInterceptorsFromInfos() {
        int i;
        super.populateInterceptorsFromInfos();
        this.fieldReadInterceptors = new Interceptor[this.fieldReadInfos.length][];
        for (i = 0; i < this.fieldReadInfos.length; ++i) {
            this.fieldReadInterceptors[i] = this.fieldReadInfos[i].getInterceptors();
        }
        this.fieldWriteInterceptors = new Interceptor[this.fieldWriteInfos.length][];
        for (i = 0; i < this.fieldWriteInfos.length; ++i) {
            this.fieldWriteInterceptors[i] = this.fieldWriteInfos[i].getInterceptors();
        }
        this.constructionInterceptors = new Interceptor[this.constructionInfos.length][];
        for (i = 0; i < this.constructionInfos.length; ++i) {
            this.constructionInterceptors[i] = this.constructionInfos[i].getInterceptors();
        }
    }

    static interface RebuildInterceptorsAction {
        public static final RebuildInterceptorsAction PRIVILEGED = new RebuildInterceptorsAction(){

            public void rebuildInterceptors(final ClassAdvisor advisor) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            advisor.doRebuildInterceptors();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final RebuildInterceptorsAction NON_PRIVILEGED = new RebuildInterceptorsAction(){

            public void rebuildInterceptors(ClassAdvisor advisor) {
                advisor.doRebuildInterceptors();
            }
        };

        public void rebuildInterceptors(ClassAdvisor var1);
    }

    static interface ResolveConstructorCallerConstructorInfoAction {
        public static final ResolveConstructorCallerConstructorInfoAction PRIVILEGED = new ResolveConstructorCallerConstructorInfoAction(){

            public ConByConInfo resolveInfo(final ClassAdvisor advisor, final int callingIndex, final String calledClass, final long calledConHash) {
                try {
                    return (ConByConInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return advisor.doResolveConstructorCallerConstructorInfo(callingIndex, calledClass, calledConHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveConstructorCallerConstructorInfoAction NON_PRIVILEGED = new ResolveConstructorCallerConstructorInfoAction(){

            public ConByConInfo resolveInfo(ClassAdvisor advisor, int callingIndex, String calledClass, long calledConHash) {
                return advisor.doResolveConstructorCallerConstructorInfo(callingIndex, calledClass, calledConHash);
            }
        };

        public ConByConInfo resolveInfo(ClassAdvisor var1, int var2, String var3, long var4);
    }

    static interface ResolveConstructorCallerMethodInfoAction {
        public static final ResolveConstructorCallerMethodInfoAction PRIVILEGED = new ResolveConstructorCallerMethodInfoAction(){

            public MethodByConInfo resolveInfo(final ClassAdvisor advisor, final int callingIndex, final String calledClass, final long calledMethodHash) {
                try {
                    return (MethodByConInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return advisor.doResolveConstructorCallerMethodInfo(callingIndex, calledClass, calledMethodHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveConstructorCallerMethodInfoAction NON_PRIVILEGED = new ResolveConstructorCallerMethodInfoAction(){

            public MethodByConInfo resolveInfo(ClassAdvisor advisor, int callingIndex, String calledClass, long calledMethodHash) {
                return advisor.doResolveConstructorCallerMethodInfo(callingIndex, calledClass, calledMethodHash);
            }
        };

        public MethodByConInfo resolveInfo(ClassAdvisor var1, int var2, String var3, long var4);
    }

    static interface ResolveCallerMethodInfoAction {
        public static final ResolveCallerMethodInfoAction PRIVILEGED = new ResolveCallerMethodInfoAction(){

            public MethodByMethodInfo resolveInfo(final ClassAdvisor advisor, final long callingMethodHash, final String calledClass, final long calledMethodHash) {
                try {
                    return (MethodByMethodInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return advisor.doResolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveCallerMethodInfoAction NON_PRIVILEGED = new ResolveCallerMethodInfoAction(){

            public MethodByMethodInfo resolveInfo(ClassAdvisor advisor, long callingMethodHash, String calledClass, long calledMethodHash) {
                return advisor.doResolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash);
            }
        };

        public MethodByMethodInfo resolveInfo(ClassAdvisor var1, long var2, String var4, long var5);
    }

    static interface ResolveCallerConstuctorInfoAction {
        public static final ResolveCallerConstuctorInfoAction PRIVILEGED = new ResolveCallerConstuctorInfoAction(){

            public ConByMethodInfo resolveInfo(final ClassAdvisor advisor, final long callingMethodHash, final String calledClass, final long calledConHash) {
                try {
                    return (ConByMethodInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return advisor.doResolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveCallerConstuctorInfoAction NON_PRIVILEGED = new ResolveCallerConstuctorInfoAction(){

            public ConByMethodInfo resolveInfo(ClassAdvisor advisor, long callingMethodHash, String calledClass, long calledConHash) {
                return advisor.doResolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash);
            }
        };

        public ConByMethodInfo resolveInfo(ClassAdvisor var1, long var2, String var4, long var5);
    }
}

