/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;

public class OptimizedConstructorInvocations
extends OptimizedBehaviourInvocations {
    protected static String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex) {
        return declaringClazz.getName() + "_" + constructorIndex + "OptimizedConstructorInvocation";
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtConstructor con, int index) throws NotFoundException, CannotCompileException {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        String className = OptimizedConstructorInvocations.getOptimizedInvocationClassName(clazz, index);
        boolean makeInnerClass = !Modifier.isPublic((int)con.getModifiers());
        CtClass invocation = OptimizedConstructorInvocations.makeInvocationClassNoCtors(pool, makeInnerClass, clazz, className, conInvocation);
        CtConstructor template = conInvocation.getDeclaredConstructors()[0];
        CtConstructor icon = CtNewConstructor.make((CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
        CtMethod in = conInvocation.getDeclaredMethod("invokeTarget");
        StringBuffer code = new StringBuffer("{");
        code.append("setTargetObject( new ").append(con.getDeclaringClass().getName()).append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code.append(", ");
            }
            code.append("arg").append(i);
        }
        code.append("));");
        code.append("return getTargetObject();");
        code.append("}");
        CtMethod invokeTarget = null;
        try {
            invokeTarget = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeTarget", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), (String)code.toString(), (CtClass)invocation);
        }
        catch (CannotCompileException e) {
            System.out.println(code.toString());
            throw e;
        }
        invocation.addMethod(invokeTarget);
        invokeTarget.setModifiers(in.getModifiers());
        OptimizedConstructorInvocations.addGetArguments((ClassPool)pool, invocation, con.getParameterTypes());
        OptimizedConstructorInvocations.addCopy((ClassPool)pool, invocation, con.getParameterTypes());
        TransformerCommon.compileOrLoadClass(clazz, invocation);
        return invocation.getName();
    }

    private static void addCopy(ClassPool pool, CtClass invocation, CtClass[] params) throws CannotCompileException, NotFoundException {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors); " + "   wrapper.constructor = this.constructor; " + "   wrapper.arguments = this.arguments; " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; ";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)code, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        invocation.addMethod(copy);
    }
}

