/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;

public class GlobalTransaction
implements Externalizable {
    Address addr = null;
    long id = -1L;
    private static long sid = 0L;

    public GlobalTransaction() {
    }

    private GlobalTransaction(Address addr) {
        this.addr = addr;
        this.id = GlobalTransaction.newId();
    }

    private static synchronized long newId() {
        return ++sid;
    }

    public static synchronized GlobalTransaction create(Address addr) {
        return new GlobalTransaction(addr);
    }

    public Object getAddress() {
        return this.addr;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        return (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GlobalTransaction)) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int compareTo(Object o) {
        int comp;
        if (o == null || !(o instanceof GlobalTransaction)) {
            throw new ClassCastException("GlobalTransaction.compareTo(): other object is " + o);
        }
        GlobalTransaction other = (GlobalTransaction)o;
        int n = comp = this.addr != null ? this.addr.compareTo((Object)other.addr) : 0;
        if (comp != 0) {
            return comp;
        }
        if (this.id < other.getId()) {
            return -1;
        }
        if (this.id > other.getId()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(this.addr).append(">:").append(this.id);
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.addr);
        out.writeLong(this.id);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.addr = (Address)in.readObject();
        this.id = in.readLong();
    }
}

