/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

public class IsolationLevel {
    public static final IsolationLevel NONE = new IsolationLevel("NONE");
    public static final IsolationLevel SERIALIZABLE = new IsolationLevel("SERIALIZABLE");
    public static final IsolationLevel REPEATABLE_READ = new IsolationLevel("REPEATABLE_READ");
    public static final IsolationLevel READ_COMMITTED = new IsolationLevel("READ_COMMITTED");
    public static final IsolationLevel READ_UNCOMMITTED = new IsolationLevel("READ_UNCOMMITTED");
    public static final IsolationLevel BELA = new IsolationLevel("BELA");
    private final String myName;

    private IsolationLevel(String name) {
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public static IsolationLevel stringToIsolationLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.toLowerCase().trim()).equals("none")) {
            return NONE;
        }
        if (level.equals("serializable")) {
            return SERIALIZABLE;
        }
        if (level.equals("repeatable_read") || level.equals("repeatable-read")) {
            return REPEATABLE_READ;
        }
        if (level.equals("read_committed") || level.equals("read-committed")) {
            return READ_COMMITTED;
        }
        if (level.equals("read_uncommitted") || level.equals("read-uncommitted")) {
            return READ_UNCOMMITTED;
        }
        if (level.equals("bela")) {
            return BELA;
        }
        return null;
    }
}

