/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.cache.lock.OwnerNotExistedException;

public class LockMap {
    public static final int OWNER_ANY = 0;
    public static final int OWNER_READ = 1;
    public static final int OWNER_WRITE = 2;
    private SynchronizedRef writeOwner_;
    private List readOwnerList_;

    public LockMap() {
        this.writeOwner_ = new SynchronizedRef(null);
        this.readOwnerList_ = Collections.synchronizedList(new ArrayList());
    }

    private LockMap(Object writer, List readers) {
        this.writeOwner_ = new SynchronizedRef(writer);
        this.readOwnerList_ = Collections.synchronizedList(readers);
    }

    public LockMap copy() {
        return new LockMap(this.writeOwner_.get(), new ArrayList(this.readOwnerList_));
    }

    public synchronized boolean isOwner(Object owner, int ownership) {
        this.checkOwnerNull(owner);
        boolean hasOwner = false;
        switch (ownership) {
            case 0: {
                if ((this.getWriteOwner() == null || !this.getWriteOwner().equals(owner)) && (this.readOwnerList_.size() == 0 || !this.readOwnerList_.contains(owner))) break;
                hasOwner = true;
                break;
            }
            case 1: {
                if (this.readOwnerList_.size() == 0 || !this.readOwnerList_.contains(owner)) break;
                hasOwner = true;
                break;
            }
            case 2: {
                if (this.getWriteOwner() == null || !this.getWriteOwner().equals(owner)) break;
                hasOwner = true;
                break;
            }
        }
        return hasOwner;
    }

    private void checkOwnerNull(Object owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner object is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReader(Object owner) {
        this.checkOwnerNull(owner);
        List list = this.readOwnerList_;
        synchronized (list) {
            if (!this.readOwnerList_.contains(owner)) {
                this.readOwnerList_.add(owner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriter(Object owner) {
        this.checkOwnerNull(owner);
        LockMap lockMap = this;
        synchronized (lockMap) {
            if (this.getWriteOwner() != null) {
                throw new IllegalStateException("addWriter(): owner already existed");
            }
            this.addWriteOwner(owner);
        }
    }

    private void addWriteOwner(Object owner) {
        this.writeOwner_.set(owner);
    }

    private Object getWriteOwner() {
        return this.writeOwner_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgrade(Object owner) throws OwnerNotExistedException {
        this.checkOwnerNull(owner);
        LockMap lockMap = this;
        synchronized (lockMap) {
            if (!this.readOwnerList_.contains(owner)) {
                throw new OwnerNotExistedException("Can't upgrade lock. Read lock owner not existed");
            }
            this.readOwnerList_.remove(owner);
            this.addWriteOwner(owner);
        }
        return true;
    }

    public List readerOwners() {
        return this.readOwnerList_;
    }

    public Object writerOwner() {
        return this.getWriteOwner();
    }

    public boolean removeReader(Object owner) {
        this.checkOwnerNull(owner);
        return this.readOwnerList_.remove(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeWriter(Object owner) {
        Object tmp;
        this.checkOwnerNull(owner);
        LockMap lockMap = this;
        synchronized (lockMap) {
            tmp = this.getWriteOwner();
            this.addWriteOwner(null);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        LockMap lockMap = this;
        synchronized (lockMap) {
            this.addWriteOwner(null);
            this.readOwnerList_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printInfo() {
        StringBuffer buf = new StringBuffer();
        LockMap lockMap = this;
        synchronized (lockMap) {
            buf.append("Read lock owners: ").append(this.readOwnerList_).append("\n");
            buf.append("Write lock owner: ").append(this.getWriteOwner()).append("\n");
        }
        return buf.toString();
    }
}

