/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;

public class RpcDelegatingCacheLoaderTests {
    TreeCache cache;

    public static void main(String[] args) {
        boolean client = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("client")) {
                client = true;
                continue;
            }
            if (arg.equals("server")) {
                client = false;
                continue;
            }
            RpcDelegatingCacheLoaderTests.help();
            return;
        }
        try {
            new RpcDelegatingCacheLoaderTests().start(client);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("RpcDelegatingCacheLoadeTest [client / server]");
    }

    private void start(boolean client) throws Exception {
        this.cache = new TreeCache("test-cluster", null, 3000L);
        this.cache.setCacheMode(2);
        this.cache.setFetchStateOnStartup(true);
        this.cache.setCacheLoaderFetchTransientState(true);
        this.cache.setCacheLoaderClass("org.jboss.cache.loader.RpcDelegatingCacheLoader");
        this.cache.setCacheLoaderShared(false);
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.startService();
        if (!client) {
            System.out.println("started as SERVER");
            System.out.println("populating the cache");
            this.cache.getTransactionManager().begin();
            this.cache.put("/a/b/c", (Object)"bela", (Object)"ban");
            this.cache.put("/1/2/3", (Object)"ben", (Object)"wang");
            this.cache.getTransactionManager().commit();
            System.out.println("the cache is " + this.cache.toString() + ", locks: " + this.cache.printLockInfo());
            while (true) {
                this.sleep(2000L);
                this.cache.getTransactionManager().begin();
                this.cache.put("/x/y/z", (Object)"d", (Object)"d");
                this.cache.getTransactionManager().commit();
            }
        }
        System.out.println("started as CLIENT");
        System.out.println("initial cache (fetched from SERVER) is " + this.cache.printLockInfo());
        this.sleep(1000L);
        System.out.println("evicting /a and /1 locally");
        this.cache.evict(Fqn.fromString("/a/b/c"));
        this.cache.evict(Fqn.fromString("/a/b"));
        this.cache.evict(Fqn.fromString("/a"));
        this.cache.evict(Fqn.fromString("/1/2/3"));
        this.cache.evict(Fqn.fromString("/1/2"));
        this.cache.evict(Fqn.fromString("/1"));
        System.out.println("cache contents after eviction: " + this.cache.printLockInfo());
        System.out.println("accessing /a and /1. this will trigger a fetch from the remote SERVER");
        Object val = this.cache.get("/a/b/c", (Object)"bela");
        System.out.println("value is " + val);
        val = this.cache.get("/1/2/3", (Object)"ben");
        System.out.println("value is " + val);
        System.out.println("the cache is " + this.cache.toString() + ", locks: " + this.cache.printLockInfo());
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

