/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jgroups.blocks.MethodCall;

public class CacheLoaderInterceptor
extends Interceptor {
    protected CacheLoader loader = null;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Fqn fqn = null;
        DataNode n = null;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        boolean load_attributes = false;
        if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal) || meth.equals(TreeCache.putKeyValMethodLocal)) {
            fqn = (Fqn)args[1];
            load_attributes = true;
        } else if (!meth.equals(TreeCache.removeNodeMethodLocal)) {
            if (meth.equals(TreeCache.removeKeyMethodLocal) || meth.equals(TreeCache.removeDataMethodLocal)) {
                fqn = (Fqn)args[1];
                load_attributes = true;
            } else if (meth.equals(TreeCache.addChildMethodLocal)) {
                fqn = (Fqn)args[1];
            } else if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
                fqn = (Fqn)args[0];
                load_attributes = true;
            } else if (meth.equals(TreeCache.getNodeMethodLocal)) {
                fqn = (Fqn)args[0];
            } else if (meth.equals(TreeCache.getKeysMethodLocal)) {
                fqn = (Fqn)args[0];
                load_attributes = true;
            } else if (meth.equals(TreeCache.getChildrenNamesMethodLocal) || meth.equals(TreeCache.releaseAllLocksMethodLocal) || meth.equals(TreeCache.printMethodLocal)) {
                fqn = (Fqn)args[0];
            }
        }
        CacheLoaderInterceptor cacheLoaderInterceptor = this;
        synchronized (cacheLoaderInterceptor) {
            if (fqn != null && (!this.cache.exists(fqn) || this.cache.exists(fqn, (Object)"jboss:internal:uninitialized"))) {
                n = this.getNode(fqn, true, load_attributes);
                if (load_attributes && n != null) {
                    this.loadAttributesFromCacheLoader(n);
                }
                this.lock(fqn, 2, false);
            }
            if (meth.equals(TreeCache.getChildrenNamesMethodLocal) && fqn != null) {
                Map children;
                if (n == null) {
                    n = this.getNode(fqn, false, false);
                }
                if (!(n == null || (children = n.getChildren()) != null && n.getChildrenLoaded())) {
                    Set children_names = null;
                    try {
                        children_names = this.loader.getChildrenNames(fqn);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
                    }
                    if (children_names != null) {
                        Iterator it = children_names.iterator();
                        while (it.hasNext()) {
                            String child_name = (String)it.next();
                            Fqn child_fqn = new Fqn(n.getFqn(), child_name);
                            n.createChild(child_name, child_fqn, n, "jboss:internal:uninitialized", null);
                        }
                        this.lock(fqn, 1, true);
                    }
                    n.setChildrenLoaded(true);
                }
            }
        }
        return super.invoke(m);
    }

    protected void lock(Fqn fqn, int lock_type, boolean recursive) throws Throwable {
        if (this.cache.isNodeLockingOptimistic()) {
            return;
        }
        MethodCall meth = new MethodCall(TreeCache.lockMethodLocal, new Object[]{fqn, new Integer(lock_type), new Boolean(recursive)});
        super.invoke(meth);
    }

    protected DataNode getNode(Fqn fqn, boolean load, boolean willAttrsBeLoaded) {
        TreeNode child_node = null;
        Fqn tmp_fqn = new Fqn();
        if (fqn == null) {
            return null;
        }
        int treeNodeSize = fqn.size();
        TreeNode n = this.cache.getRoot();
        int i = 0;
        while (i < treeNodeSize && n != null) {
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, child_name);
            child_node = n.getChild(child_name);
            if (child_node == null && load) {
                try {
                    if (this.loader.exists(tmp_fqn)) {
                        child_node = (DataNode)n.createChild(child_name, tmp_fqn, n, "jboss:internal:uninitialized", null);
                        if (!willAttrsBeLoaded) {
                            this.cache.notifyNodeLoaded(tmp_fqn);
                        }
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)("failed loading node " + fqn + " from CacheLoader"), t);
                }
            }
            n = child_node;
            ++i;
        }
        return n;
    }

    protected void loadAttributesFromCacheLoader(DataNode n) {
        if (n == null || !n.containsKey("jboss:internal:uninitialized")) {
            return;
        }
        try {
            Map m = this.loader.get(n.getFqn());
            n.remove("jboss:internal:uninitialized");
            n.put(m);
            this.cache.notifyNodeLoaded(n.getFqn());
        }
        catch (Throwable t) {
            this.log.error((Object)("failure when lazily loading attributes of " + n.getFqn()), t);
        }
    }
}

