/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;

public class FileExtendedCacheLoader
extends FileCacheLoader
implements ExtendedCacheLoader {
    private RegionManager manager_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadState(Fqn subtree) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            this.setUnmarshallingClassLoader(subtree);
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream(1024);
            MarshalledValueOutputStream out = new MarshalledValueOutputStream((OutputStream)out_stream);
            this.loadStateFromFilessystem(subtree, (ObjectOutputStream)out);
            out.close();
            byte[] byArray = out_stream.toByteArray();
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            return byArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeState(byte[] state, Fqn subtree) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            this.setUnmarshallingClassLoader(subtree);
            ByteArrayInputStream in_stream = new ByteArrayInputStream(state);
            MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
            this.remove(subtree);
            try {
                while (true) {
                    NodeData nd = (NodeData)in.readObject();
                    if (nd.attrs != null) {
                        this.put(nd.fqn, nd.attrs, true);
                        continue;
                    }
                    this.put(nd.fqn);
                }
            }
            catch (EOFException eof_ex) {
                Object var9_8 = null;
                Thread.currentThread().setContextClassLoader(currentCL);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            Thread.currentThread().setContextClassLoader(currentCL);
            throw throwable;
        }
    }

    public void setRegionManager(RegionManager manager) {
        this.manager_ = manager;
    }

    public byte[] loadEntireState() throws Exception {
        return this.loadState(Fqn.fromString("/"));
    }

    public void storeEntireState(byte[] state) throws Exception {
        this.storeState(state, Fqn.fromString("/"));
    }

    private void setUnmarshallingClassLoader(Fqn subtree) {
        if (this.manager_ != null) {
            ClassLoader regionCL;
            Region region = this.manager_.getRegion(subtree.toString());
            ClassLoader classLoader = regionCL = region == null ? null : region.getClassLoader();
            if (regionCL != null) {
                Thread.currentThread().setContextClassLoader(regionCL);
            }
        }
    }
}

