/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.SyncSortedMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.optimistic.Comparator;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;

public class TransactionWorkspaceImpl
implements TransactionWorkspace {
    private Map nodes;
    private TreeCache cache;

    public TransactionWorkspaceImpl() {
        this.initNodeMap();
    }

    private void initNodeMap() {
        this.nodes = new SyncSortedMap(new TreeMap(new Comparator()), (ReadWriteLock)new FIFOReadWriteLock());
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    public TreeCache getCache() {
        return this.cache;
    }

    public Map getNodes() {
        return this.nodes;
    }

    public void setNodes(Map nodes) {
        this.nodes = nodes;
    }

    public WorkspaceNode getNode(Fqn fqn) {
        return (WorkspaceNode)this.nodes.get(fqn);
    }

    public void addNode(WorkspaceNode node) {
        this.nodes.put(node.getFqn(), node);
    }

    public Object removeNode(Fqn fqn) {
        return this.nodes.remove(fqn);
    }

    public SortedMap getNodesAfter(Fqn fqn) {
        return ((SortedMap)this.nodes).tailMap(fqn);
    }

    public String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        if (this.nodes != null) {
            b.append("[Num elements: ").append(this.nodes.size()).append("]");
        } else {
            b.append("[Num elements: null]");
        }
        return b.toString();
    }
}

