/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.CacheInterceptor;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.CollectionClassHandler;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.ObjectGraphHandler;
import org.jboss.cache.aop.SerializableObjectHandler;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.util.AopUtil;

public class TreeCacheAopDelegate {
    protected TreeCacheAop cache_;
    protected static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$aop$TreeCacheAopDelegate == null ? (class$org$jboss$cache$aop$TreeCacheAopDelegate = TreeCacheAopDelegate.class$("org.jboss.cache.aop.TreeCacheAopDelegate")) : class$org$jboss$cache$aop$TreeCacheAopDelegate));
    protected InternalDelegate internal_;
    protected ObjectGraphHandler graphHandler_;
    protected CollectionClassHandler collectionHandler_;
    protected SerializableObjectHandler serializableHandler_;
    static /* synthetic */ Class class$org$jboss$cache$aop$TreeCacheAopDelegate;
    static /* synthetic */ Class class$org$jboss$aop$Advised;

    public TreeCacheAopDelegate(TreeCacheAop cache) {
        this.cache_ = cache;
        this.internal_ = new InternalDelegate(cache);
        this.graphHandler_ = new ObjectGraphHandler(this.cache_, this.internal_, this);
        this.collectionHandler_ = new CollectionClassHandler(this.cache_, this.internal_, this.graphHandler_);
        this.serializableHandler_ = new SerializableObjectHandler(this.cache_, this.internal_);
    }

    protected Object _getObject(Fqn fqn) throws CacheException {
        Object pojo = this.internal_.getPojo(fqn);
        if (pojo != null) {
            return pojo;
        }
        Class clazz = this.internal_.peekAopClazz(fqn);
        if (clazz == null) {
            return null;
        }
        CachedType type = this.cache_.getCachedType(clazz);
        Object obj = null;
        obj = this.graphHandler_.objectGraphGet(fqn);
        if (obj != null) {
            return obj;
        }
        if ((class$org$jboss$aop$Advised == null ? (class$org$jboss$aop$Advised = TreeCacheAopDelegate.class$("org.jboss.aop.Advised")) : class$org$jboss$aop$Advised).isAssignableFrom(clazz)) {
            try {
                obj = clazz.newInstance();
            }
            catch (Exception e) {
                throw new CacheException("failed creating instance of " + clazz.getName(), e);
            }
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            advisor.appendInterceptor((Interceptor)new CacheInterceptor(this.cache_, fqn, type));
        } else {
            try {
                obj = this.collectionHandler_.collectionObjectGet(fqn, clazz);
                if (obj == null) {
                    obj = this.serializableHandler_.serializableObjectGet(fqn);
                }
            }
            catch (Exception e) {
                throw new CacheException("failure creating proxy", e);
            }
        }
        this.internal_.setPojo(fqn, obj);
        return obj;
    }

    protected Object retrieveCurrentValue(Fqn fqn, Object obj) throws CacheException {
        Object oldValue = null;
        Object pojo = this.internal_.getPojo(fqn);
        return pojo;
    }

    protected Object _putObject(Fqn fqn, Object obj) throws CacheException {
        AopUtil.checkObjectType(obj);
        if (obj == null) {
            return this.cache_.removeObject(fqn);
        }
        Object oldValue = this.retrieveCurrentValue(fqn, obj);
        if (oldValue == obj) {
            return obj;
        }
        this.cache_.removeObject(fqn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("putObject(): fqn: " + fqn));
        }
        if (obj instanceof Advised) {
            CachedType type = this.cache_.getCachedType(obj.getClass());
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            if (advisor == null) {
                throw new RuntimeException("_putObject(): InstanceAdvisor is null for: " + obj);
            }
            Interceptor interceptor = AopUtil.findCacheInterceptor(advisor);
            if (this.graphHandler_.objectGraphPut(fqn, interceptor, type, obj)) {
                return oldValue;
            }
            this._regularPutObject(fqn, obj, advisor, type);
        } else if (!this.collectionHandler_.collectionObjectPut(fqn, obj) && !this.serializableHandler_.serializableObjectPut(fqn, obj)) {
            throw new RuntimeException("putObject(): obj: " + obj + " type is not recognizable.");
        }
        return oldValue;
    }

    protected void _regularPutObject(Fqn fqn, Object obj, InstanceAdvisor advisor, CachedType type) throws CacheException {
        if (advisor == null) {
            advisor = new ClassInstanceAdvisor(obj);
            ((Advised)obj)._setInstanceAdvisor(advisor);
        }
        advisor.appendInterceptor((Interceptor)new CacheInterceptor(this.cache_, fqn, type));
        this.internal_.resetRefCount(fqn);
        this.internal_.putAopClazz(fqn, type.getType());
        Iterator i = type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new CacheException("field access failed", e);
            }
            CachedType fieldType = this.cache_.getCachedType(field.getType());
            if (fieldType.isImmediate()) {
                this.cache_.put(fqn, (Object)field.getName(), value);
                continue;
            }
            Fqn tmpFqn = new Fqn(fqn, field.getName());
            this._putObject(tmpFqn, value);
            this.collectionHandler_.collectionReplaceWithProxy(obj, value, field, tmpFqn);
        }
        this.internal_.setPojo(fqn, obj);
        if (log.isDebugEnabled()) {
            log.debug((Object)("putObject(): inserting with fqn: " + fqn.toString()));
        }
    }

    public Object _removeObject(Fqn fqn, boolean removeCacheInterceptor, boolean evict) throws CacheException {
        Object result;
        Class clazz = this.internal_.peekAopClazz(fqn);
        if (clazz == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("removeObject(): clasz is null. fqn: " + fqn + " No need to remove."));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeObject(): removing object from fqn: " + fqn));
        }
        if ((result = this.cache_.getObject(fqn)) == null) {
            if (this.cache_.exists(fqn)) {
                if (!evict) {
                    this.cache_.remove(fqn);
                } else {
                    this.cache_._evict(fqn);
                }
            }
            return null;
        }
        if (this.graphHandler_.objectGraphRemove(fqn, removeCacheInterceptor, result, evict)) {
            return result;
        }
        if ((class$org$jboss$aop$Advised == null ? (class$org$jboss$aop$Advised = TreeCacheAopDelegate.class$("org.jboss.aop.Advised")) : class$org$jboss$aop$Advised).isAssignableFrom(clazz)) {
            this._regularRemoveObject(fqn, removeCacheInterceptor, result, clazz, evict);
        } else if (!this.collectionHandler_.collectionObjectRemove(fqn, removeCacheInterceptor, evict)) {
            this.serializableHandler_.serializableObjectRemove(fqn);
        }
        this.internal_.cleanUp(fqn, evict);
        return result;
    }

    protected void _regularRemoveObject(Fqn fqn, boolean removeCacheInterceptor, Object result, Class clazz, boolean evict) throws CacheException {
        CacheInterceptor interceptor;
        InstanceAdvisor advisor = ((Advised)result)._getInstanceAdvisor();
        CachedType type = this.cache_.getCachedType(clazz);
        Iterator i = type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            CachedType fieldType = this.cache_.getCachedType(field.getType());
            if (!fieldType.isImmediate()) {
                Object obj = this._removeObject(new Fqn(fqn, field.getName()), removeCacheInterceptor, evict);
                continue;
            }
            if (evict) continue;
            this.cache_.remove(fqn, (Object)field.getName());
        }
        if (removeCacheInterceptor && (interceptor = (CacheInterceptor)AopUtil.findCacheInterceptor(advisor)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("removeObject(): removed cache interceptor fqn: " + fqn + " interceptor: " + interceptor));
            }
            advisor.removeInterceptor(interceptor.getName());
        }
    }

    boolean isAopNode(Fqn fqn) {
        try {
            return this.internal_.isAopNode(fqn);
        }
        catch (Exception e) {
            log.warn((Object)("isAopNode(): cache get operation generated exception " + e));
            return false;
        }
    }

    protected Map _findObjects(Fqn fqn) throws CacheException {
        HashMap<Fqn, Object> map = new HashMap<Fqn, Object>();
        Object pojo = this._getObject(fqn);
        if (pojo != null) {
            map.put(fqn, pojo);
            return map;
        }
        this.findChildObjects(fqn, map);
        if (log.isDebugEnabled()) {
            log.debug((Object)("_findObjects(): Fqn: " + fqn + " size of pojos found: " + map.size()));
        }
        return map;
    }

    protected void findChildObjects(Fqn fqn, Map map) throws CacheException {
        Object pojo = null;
        Set set = this.cache_.getChildrenNames(fqn);
        if (set == null) {
            return;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String obj = (String)it.next();
            Fqn newFqn = new Fqn(fqn, obj);
            pojo = this._getObject(newFqn);
            if (pojo != null) {
                map.put(newFqn, pojo);
                continue;
            }
            this.findChildObjects(newFqn, map);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

