/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AopOperationNotSupportedException;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.util.NestedRuntimeException;

public class CachedListImpl
implements List {
    protected TreeCacheAop cache_;
    protected AbstractCollectionInterceptor interceptor_;

    public CachedListImpl(TreeCacheAop cache, AbstractCollectionInterceptor interceptor) {
        this.cache_ = cache;
        this.interceptor_ = interceptor;
    }

    protected Fqn getFqn() {
        return this.interceptor_.getFqn();
    }

    protected DataNode getNode() {
        try {
            return this.cache_.get(this.getFqn());
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object get(int index) {
        this.checkIndex(index);
        try {
            return this.cache_.getObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    private void checkIndex(int i) {
        if (this.size() == 0) {
            return;
        }
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound at CachedListImpl(). Index is " + i + " but size is " + this.size());
        }
    }

    private void checkArgument(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    public int size() {
        DataNode node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public void clear() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objs[i] = this.get(i);
        }
        return objs;
    }

    public Object set(int index, Object element) {
        try {
            if (index != 0) {
                this.checkIndex(index - 1);
            }
            Object oldValue = this.get(index);
            return this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object[] toArray(Object[] a) {
        throw new AopOperationNotSupportedException("CachedListImpl: List.toArray(a) operation not supported");
    }

    public void add(int index, Object element) {
        try {
            if (index != 0) {
                this.checkIndex(index - 1);
            }
            for (int i = this.size(); i > index; --i) {
                Object obj = this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i - 1)));
                this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i)), obj);
            }
            this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public int indexOf(Object o) {
        this.checkArgument(o);
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        this.checkArgument(o);
        int index = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            index = i;
        }
        return index;
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public Object remove(int index) {
        try {
            this.checkIndex(index);
            int size = this.size();
            Object result = this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)));
            if (size == index + 1) {
                return result;
            }
            for (int i = index; i < size - 1; ++i) {
                Object obj = this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i + 1)));
                this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i)), obj);
            }
            return result;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        throw new AopOperationNotSupportedException("CachedListImpl: List.addAll() operation not supported");
    }

    public boolean addAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.add(o);
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedListImpl: List.containsAll() operation not supported");
    }

    public boolean removeAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.remove(o);
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.get(i).hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (value != null) {
                if (this.contains(value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object key = this.get(i);
            buf.append("[" + key).append("]");
            if (i > size) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean retainAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedListImpl: List.retainAll() operation not supported");
    }

    public Iterator iterator() {
        return new Iterator(){
            protected int current = -1;
            protected int size_ = CachedListImpl.this.size();

            public boolean hasNext() {
                if (CachedListImpl.this.size() == 0) {
                    return false;
                }
                if (this.current > CachedListImpl.this.size()) {
                    throw new IllegalStateException("CachedSetImpl.iterator.hasNext().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                }
                return this.current < CachedListImpl.this.size() - 1;
            }

            public Object next() {
                if (this.current == CachedListImpl.this.size()) {
                    throw new IllegalStateException("CachedSetImpl.iterator.next().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                }
                try {
                    return CachedListImpl.this.cache_.getObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(++this.current)));
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }

            public void remove() {
                try {
                    int size = CachedListImpl.this.size();
                    if (CachedListImpl.this.size() == 0) {
                        return;
                    }
                    if (this.current == CachedListImpl.this.size()) {
                        throw new IllegalStateException("CachedSetImpl.iterator.remove().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                    }
                    if (this.current < size - 1) {
                        Object last = CachedListImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(this.current)));
                        for (int i = this.current + 1; i < size; ++i) {
                            last = CachedListImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(i)));
                            CachedListImpl.this.cache_.putObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(i - 1)), last);
                        }
                    } else {
                        CachedListImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(this.current)));
                    }
                    --this.current;
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        throw new AopOperationNotSupportedException("CachedListImpl: List.subList() operation not supported");
    }

    public ListIterator listIterator() {
        return new MyListIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new MyListIterator(index);
    }

    protected class MyListIterator
    implements ListIterator {
        protected int index = 0;

        public MyListIterator(int index) {
            if (index < 0 || index >= CachedListImpl.this.size()) {
                throw new AopOperationNotSupportedException("CachedListImpl: MyListIterator construction.  Index is out of bound : " + index);
            }
            this.index = index;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            throw new AopOperationNotSupportedException("CachedListImpl: ListIterator.remove() optional operation not supported");
        }

        public boolean hasNext() {
            return this.index != CachedListImpl.this.size() - 1;
        }

        public boolean hasPrevious() {
            return this.index != 0;
        }

        public Object next() {
            if (this.index == CachedListImpl.this.size()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return CachedListImpl.this.get(this.index - 1);
        }

        public Object previous() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            return CachedListImpl.this.get(this.index);
        }

        public void add(Object o) {
            throw new AopOperationNotSupportedException("CachedListImpl: ListIterator.add() optional operation not supported");
        }

        public void set(Object o) {
            throw new AopOperationNotSupportedException("CachedListImpl: ListIterator.set() optional operation not supported");
        }
    }
}

