/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Modification;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.blocks.MethodCall;

public class ActivationInterceptor
extends CacheLoaderInterceptor {
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    protected ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    protected static final Object NULL = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Transaction tx;
        Fqn fqn = null;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        Object retval = null;
        retval = super.invoke(m);
        if (this.tx_mgr != null && (tx = this.tx_mgr.getTransaction()) != null && this.isValid(tx) && !this.transactions.containsKey((Object)tx)) {
            this.transactions.put((Object)tx, NULL);
            GlobalTransaction gtx = this.cache.getCurrentTransaction(tx);
            if (gtx == null) {
                throw new Exception("failed to get global transaction");
            }
            tx.registerSynchronization((Synchronization)new SynchronizationHandler(gtx, tx, this.cache));
        }
        if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal) || meth.equals(TreeCache.putKeyValMethodLocal)) {
            fqn = (Fqn)args[1];
        } else if (meth.equals(TreeCache.removeKeyMethodLocal) || meth.equals(TreeCache.removeDataMethodLocal)) {
            fqn = (Fqn)args[1];
        } else if (meth.equals(TreeCache.addChildMethodLocal)) {
            fqn = (Fqn)args[1];
        } else if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
            fqn = (Fqn)args[0];
        } else if (meth.equals(TreeCache.getNodeMethodLocal)) {
            fqn = (Fqn)args[0];
        } else if (meth.equals(TreeCache.getKeysMethodLocal)) {
            fqn = (Fqn)args[0];
        } else if (meth.equals(TreeCache.getChildrenNamesMethodLocal) || meth.equals(TreeCache.releaseAllLocksMethodLocal) || meth.equals(TreeCache.printMethodLocal)) {
            fqn = (Fqn)args[0];
        }
        ActivationInterceptor activationInterceptor = this;
        synchronized (activationInterceptor) {
            DataNode n;
            if (fqn != null && this.cache.exists(fqn) && (n = this.getNode(fqn, false, false)) != null && !n.containsKey("jboss:internal:uninitialized")) {
                if (n.hasChildren()) {
                    if (n.getChildrenLoaded()) {
                        boolean removeNode = true;
                        Iterator it = n.getChildren().values().iterator();
                        while (it.hasNext()) {
                            DataNode child = (DataNode)it.next();
                            if (!child.containsKey("jboss:internal:uninitialized")) continue;
                            removeNode = false;
                        }
                        if (removeNode) {
                            this.loader.remove(fqn);
                            this.cache.notifyNodeActivate(fqn, false);
                        }
                    }
                } else {
                    Set children_names = null;
                    try {
                        children_names = this.loader.getChildrenNames(fqn);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
                    }
                    if (children_names == null) {
                        this.loader.remove(fqn);
                        this.cache.notifyNodeActivate(fqn, false);
                    }
                }
            }
        }
        return retval;
    }

    protected CacheLoader getLoader() {
        return this.loader != null ? this.loader : (this.loader = this.cache.getCacheLoader());
    }

    private void prepareCacheLoader(GlobalTransaction gtx) throws Exception {
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List modifications = entry.getModifications();
        if (modifications.size() == 0) {
            return;
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        Iterator it = modifications.iterator();
        while (it.hasNext()) {
            Modification mod;
            DataNode n;
            Fqn fqn;
            MethodCall methodCall = (MethodCall)it.next();
            Method method = methodCall.getMethod();
            if (method == null) {
                throw new Exception("method call has no method: " + methodCall);
            }
            Object[] args = methodCall.getArgs();
            if (!TreeCache.putDataMethodLocal.equals(method) && !TreeCache.putDataEraseMethodLocal.equals(method) && !TreeCache.putKeyValMethodLocal.equals(method) && !TreeCache.removeNodeMethodLocal.equals(method) || (fqn = (Fqn)args[1]) == null || !this.cache.exists(fqn) || (n = this.getNode(fqn, false, false)) == null || n.containsKey("jboss:internal:uninitialized")) continue;
            if (n.hasChildren()) {
                if (!n.getChildrenLoaded()) continue;
                boolean removeNode = true;
                Iterator it2 = n.getChildren().values().iterator();
                while (it2.hasNext()) {
                    DataNode child = (DataNode)it2.next();
                    if (!child.containsKey("jboss:internal:uninitialized")) continue;
                    removeNode = false;
                }
                if (!removeNode) continue;
                mod = new Modification(4, fqn);
                cache_loader_modifications.add(mod);
                this.cache.notifyNodeActivate(fqn, false);
                continue;
            }
            Set children_names = null;
            try {
                children_names = this.loader.getChildrenNames(fqn);
            }
            catch (Exception e) {
                this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
            }
            if (children_names != null) continue;
            mod = new Modification(4, fqn);
            cache_loader_modifications.add(mod);
            this.cache.notifyNodeActivate(fqn, false);
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, false);
        }
    }

    class SynchronizationHandler
    implements Synchronization {
        GlobalTransaction gtx = null;
        Transaction tx = null;
        TreeCache cache = null;
        List modifications;

        SynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.tx = tx;
            this.cache = cache;
            TransactionEntry entry = ActivationInterceptor.this.tx_table.get(gtx);
            if (entry != null) {
                this.modifications = entry.getModifications();
            }
        }

        public void beforeCompletion() {
            try {
                int status = this.tx.getStatus();
                switch (status) {
                    case 0: 
                    case 7: 
                    case 8: {
                        ActivationInterceptor.this.prepareCacheLoader(this.gtx);
                        break;
                    }
                    case 1: 
                    case 9: {
                        break;
                    }
                    default: {
                        ActivationInterceptor.this.log.error((Object)("beforeCompletion(). Illegal tx status: " + status));
                        throw new IllegalStateException("Illegal status: " + status);
                    }
                }
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("", t);
            }
        }

        public void afterCompletion(int status) {
            ActivationInterceptor.this.transactions.remove((Object)this.tx);
            switch (status) {
                case 3: {
                    try {
                        if (this.modifications == null || this.modifications.size() == 0) {
                            return;
                        }
                        ActivationInterceptor.this.getLoader().commit(this.gtx);
                    }
                    catch (Exception e) {
                        ActivationInterceptor.this.log.error((Object)"failed committing transaction to cache loader", (Throwable)e);
                    }
                    break;
                }
                case 1: 
                case 4: {
                    ActivationInterceptor.this.getLoader().rollback(this.gtx);
                }
            }
        }
    }
}

