/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticNodeInterceptor
extends OptimisticInterceptor {
    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodCall m) throws Throwable {
        GlobalTransaction gtx;
        Transaction tx = null;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        Object result = null;
        if (TreeCache.isCrudMethod(meth)) {
            if (this.txManager == null) throw new CacheException("Must be in a valid transaction " + m);
            tx = this.txManager.getTransaction();
            if (tx == null) throw new CacheException("Must be in a valid transaction " + m);
            if (!this.isValid(tx)) throw new CacheException("Must be in a valid transaction " + m);
            gtx = this.cache.getCurrentTransaction(tx);
            if (gtx == null) {
                throw new CacheException("unable to retrieve global transaction for " + tx);
            }
            TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
            WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(this.getFqn(args), workspace, this.cache);
            if (meth.equals(TreeCache.putDataMethodLocal)) {
                Boolean erase = (Boolean)args[3];
                result = this.putDataMap(args, erase, workspace, workspaceNode);
            } else if (meth.equals(TreeCache.putDataEraseMethodLocal)) {
                result = this.putDataMap(args, true, workspace, workspaceNode);
            } else if (meth.equals(TreeCache.putKeyValMethodLocal)) {
                result = this.putDataKeyValue(args, workspace, workspaceNode);
            } else if (meth.equals(TreeCache.removeNodeMethodLocal)) {
                result = this.removeNode(workspace, workspaceNode);
            } else if (meth.equals(TreeCache.removeKeyMethodLocal)) {
                result = this.removeKey(args, workspace, workspaceNode);
            } else if (meth.equals(TreeCache.removeDataMethodLocal)) {
                result = this.removeData(workspace, workspaceNode);
            } else if (this.log.isInfoEnabled()) {
                this.log.info((Object)("CRUD Method " + m + " called - don't know how to handle!"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Method " + m + " to modification list"));
            }
        } else {
            if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
                return this.getValueForKey(args);
            }
            if (meth.equals(TreeCache.getKeysMethodLocal)) {
                return this.getKeys(args);
            }
            if (meth.equals(TreeCache.getChildrenNamesMethodLocal)) {
                return this.getChildNames(args);
            }
            if (meth.equals(TreeCache.getNodeMethodLocal)) {
                return this.getNode(args);
            }
            if (!this.log.isInfoEnabled()) return super.invoke(m);
            this.log.info((Object)("read Method " + m + " called - don't know how to handle, passing on!"));
            return super.invoke(m);
        }
        this.txTable.addModification(gtx, m);
        return result;
    }

    private Fqn getFqn(Object[] args) {
        return (Fqn)args[1];
    }

    private Map getDataMap(Object[] args) {
        return (Map)args[2];
    }

    private Object getKey(Object[] args) {
        return args[2];
    }

    private Object getValue(Object[] args) {
        return args[3];
    }

    private Object putDataMap(Object[] args, boolean eraseExisitng, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        Map data = this.getDataMap(args);
        if (workspaceNode == null) {
            return null;
        }
        workspaceNode.put(data, eraseExisitng);
        workspace.addNode(workspaceNode);
        return null;
    }

    private Object putDataKeyValue(Object[] args, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        Object key = this.getKey(args);
        Object value = this.getValue(args);
        if (workspaceNode == null) {
            return null;
        }
        Object temp = workspaceNode.put(key, value);
        workspace.addNode(workspaceNode);
        return temp;
    }

    private Object removeNode(TransactionWorkspace workspace, WorkspaceNode workspaceNode) throws CacheException {
        if (workspaceNode == null) {
            return null;
        }
        Node temp = workspaceNode.getParent();
        Fqn parentFqn = temp.getFqn();
        WorkspaceNode parentNode = this.getOrCreateWorkspaceNode(parentFqn, workspace, this.cache);
        if (parentNode == null) {
            throw new CacheException("Unable to find parent node with Fqn " + parentFqn);
        }
        parentNode.removeChild(workspaceNode.getName());
        workspace.addNode(parentNode);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("added parent node " + parentNode.getFqn() + " to workspace"));
        }
        Fqn nodeFqn = workspaceNode.getFqn();
        SortedMap tailMap = workspace.getNodesAfter(workspaceNode.getFqn());
        workspaceNode.markAsDeleted();
        workspace.addNode(workspaceNode);
        Iterator it = tailMap.entrySet().iterator();
        while (it.hasNext()) {
            WorkspaceNode toDelete = (WorkspaceNode)it.next().getValue();
            if (toDelete.getFqn().isChildOf(nodeFqn) || toDelete.getFqn().equals(nodeFqn)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("marking node " + toDelete.getFqn() + " as deleted"));
                }
                toDelete.markAsDeleted();
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("ignoring " + toDelete.getFqn() + " as not a child"));
        }
        return null;
    }

    private Object removeKey(Object[] args, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        Object removeKey = args[2];
        if (workspaceNode == null) {
            return null;
        }
        workspaceNode.remove(removeKey);
        workspace.addNode(workspaceNode);
        return null;
    }

    private Object removeData(TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (workspaceNode == null) {
            return null;
        }
        workspaceNode.clear();
        workspace.addNode(workspaceNode);
        return null;
    }

    private Object getValueForKey(Object[] args) throws CacheException {
        Fqn fqn = (Fqn)args[0];
        Object key = args[1];
        GlobalTransaction gtx = this.getCurrentTxFromThread();
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, this.cache);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        Object val = workspaceNode.get(key);
        workspace.addNode(workspaceNode);
        return val;
    }

    private Object getNode(Object[] args) throws CacheException {
        Fqn fqn = (Fqn)args[0];
        GlobalTransaction gtx = this.getCurrentTxFromThread();
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, this.cache);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        workspace.addNode(workspaceNode);
        return workspaceNode.getNode();
    }

    private Object getKeys(Object[] args) throws CacheException {
        Fqn fqn = (Fqn)args[0];
        GlobalTransaction gtx = this.getCurrentTxFromThread();
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, this.cache);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        Set keySet = workspaceNode.getKeys();
        workspace.addNode(workspaceNode);
        return keySet;
    }

    private Object getChildNames(Object[] args) throws CacheException {
        Fqn fqn = (Fqn)args[0];
        GlobalTransaction gtx = this.getCurrentTxFromThread();
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, this.cache);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        Set nameSet = workspaceNode.getChildrenNames();
        workspace.addNode(workspaceNode);
        return nameSet;
    }

    private WorkspaceNode getOrCreateWorkspaceNode(Fqn fqn, TransactionWorkspace workspace, TreeCache cache) {
        WorkspaceNode workspaceNode = workspace.getNode(fqn);
        if (workspaceNode == null) {
            DataNode node = cache.peek(fqn);
            if (node == null) {
                return null;
            }
            workspaceNode = NodeFactory.getInstance().createWorkspaceNode(node, workspace);
        }
        if (workspaceNode.isDeleted()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Node " + fqn + " has been deleted in the workspace."));
            }
            return null;
        }
        return workspaceNode;
    }
}

