/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jgroups.blocks.MethodCall;

public class PassivationInterceptor
extends Interceptor {
    protected CacheLoader loader = null;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        PassivationInterceptor passivationInterceptor = this;
        synchronized (passivationInterceptor) {
            if (meth.equals(TreeCache.evictNodeMethodLocal)) {
                Fqn fqn = (Fqn)args[0];
                Map attributes = this.getNodeAttributes(fqn);
                this.cache.notifyNodePassivate(fqn, true);
                this.loader.put(fqn, attributes);
            }
        }
        return super.invoke(m);
    }

    private Map getNodeAttributes(Fqn fqn) {
        Node child_node = null;
        if (fqn == null) {
            return null;
        }
        int treeNodeSize = fqn.size();
        Node n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize && n != null; ++i) {
            child_node = n.getChild(fqn.get(i));
            n = child_node;
        }
        if (n != null) {
            return n.getData();
        }
        return null;
    }
}

