/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Replicatable;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;

public class ReplicationInterceptor
extends Interceptor
implements Replicatable {
    TransactionManager tx_mgr = null;
    TransactionTable tx_table = null;
    private ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    static final Object NULL = new Object();
    private Set remote_transactions = Collections.synchronizedSet(new HashSet());

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.tx_mgr = cache.getTransactionManager();
        cache.setReplicationHandler(this);
        this.tx_table = cache.getTransactionTable();
    }

    public Object invoke(MethodCall m) throws Throwable {
        Transaction tx = null;
        Object retval = super.invoke(m);
        if (this.tx_mgr != null && (tx = this.tx_mgr.getTransaction()) != null && this.isValid(tx)) {
            if (!this.transactions.containsKey((Object)tx)) {
                GlobalTransaction gtx = this.cache.getCurrentTransaction(tx);
                if (gtx == null) {
                    throw new Exception("failed to get global transaction");
                }
                if (this.remote_transactions.contains(gtx)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"ReplicationInterceptor: won't register for TX completion as GlobalTransaction is result of a PREPARE");
                    }
                } else {
                    OrderedSynchronizationHandler handler = OrderedSynchronizationHandler.getInstance(tx);
                    SynchronizationHandler myHandler = new SynchronizationHandler(gtx, tx, this.cache);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("registering for TX completion: SynchronizationHandler(" + myHandler + ")"));
                    }
                    handler.registerAtHead(myHandler);
                }
                this.transactions.put((Object)tx, NULL);
            }
            return retval;
        }
        if (TreeCache.isCrudMethod(m.getMethod())) {
            this.handleReplicatedMethod(m, this.cache.getCacheModeInternal());
        }
        return retval;
    }

    void handleReplicatedMethod(MethodCall m, int mode) throws Throwable {
        if (mode == 3 && m.equals(TreeCache.putFailFastKeyValueMethodLocal)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"forcing asynchronous replication for putFailFast()");
            }
            mode = 2;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invoking method " + m.getName() + "(" + m.getArgs() + ")" + ", members=" + this.cache.getMembers() + ", mode=" + this.cache.getCacheMode() + ", exclude_self=" + true + ", timeout=" + this.cache.getSyncReplTimeout()));
        }
        switch (this.cache.getCacheModeInternal()) {
            case 2: {
                if (this.cache.getUseReplQueue() && this.cache.getReplQueue() != null) {
                    this.cache.getReplQueue().add(m);
                    break;
                }
                this.cache.callRemoteMethods(this.cache.getMembers(), TreeCache.replicateMethod, new Object[]{m}, false, true, this.cache.getSyncReplTimeout());
                break;
            }
            case 3: {
                List rsps = this.cache.callRemoteMethods(this.cache.getMembers(), TreeCache.replicateMethod, new Object[]{m}, true, true, this.cache.getSyncReplTimeout());
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("responses=" + rsps));
                }
                this.checkResponses(rsps);
            }
        }
    }

    private void checkResponses(List rsps) throws Throwable {
        if (rsps != null) {
            Iterator it = rsps.iterator();
            while (it.hasNext()) {
                Object rsp = it.next();
                if (rsp == null || !(rsp instanceof Throwable)) continue;
                throw (Throwable)rsp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object replicate(MethodCall method_call) throws Throwable {
        block15: {
            Method meth;
            if (method_call == null) {
                throw new NullPointerException("method call is null");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("replicate(): received " + method_call));
            }
            if ((meth = method_call.getMethod()).equals(TreeCache.prepareMethod)) {
                Object[] args = method_call.getArgs();
                GlobalTransaction gtx = (GlobalTransaction)args[0];
                List modifications = (List)args[1];
                Address coordinator = (Address)args[2];
                boolean commit = (Boolean)args[3];
                if (coordinator != null && coordinator.equals(this.cache.getLocalAddress())) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"received my own message (discarding it)");
                    }
                    return null;
                }
                this.remote_transactions.add(gtx);
                this.handlePrepare(gtx, modifications, commit);
                return null;
            }
            if (!meth.equals(TreeCache.commitMethod) && !meth.equals(TreeCache.rollbackMethod)) break block15;
            Object[] args = method_call.getArgs();
            GlobalTransaction gtx = (GlobalTransaction)args[0];
            Transaction ltx = this.tx_table.getLocalTransaction(gtx);
            Transaction curr_tx = null;
            if (ltx != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("received " + meth.getName() + ": local TX=" + ltx + ", global TX=" + gtx));
                }
            } else {
                throw new IllegalStateException("found no local TX for global TX=" + gtx);
            }
            try {
                curr_tx = this.tx_mgr.suspend();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("executing " + meth.getName() + "() with local TX " + ltx));
                }
                this.tx_mgr.resume(ltx);
                if (meth.equals(TreeCache.rollbackMethod)) {
                    ltx.rollback();
                } else {
                    ltx.commit();
                }
                this.transactions.remove((Object)ltx);
                this.remote_transactions.remove(gtx);
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.tx_mgr.suspend();
                if (curr_tx != null) {
                    this.tx_mgr.resume(curr_tx);
                }
                throw throwable;
            }
            this.tx_mgr.suspend();
            if (curr_tx != null) {
                this.tx_mgr.resume(curr_tx);
            }
            return null;
        }
        return super.invoke(method_call);
    }

    public void replicate(List method_calls) throws Throwable {
        if (method_calls == null) {
            return;
        }
        Iterator it = method_calls.iterator();
        while (it.hasNext()) {
            MethodCall c = (MethodCall)it.next();
            try {
                super.invoke(c);
            }
            catch (Throwable t) {
                this.log.error((Object)"failed executing method call", t);
            }
        }
    }

    private Transaction createNewLocalTransaction(GlobalTransaction gtx) throws Exception {
        if (this.tx_mgr == null) {
            throw new Exception("failed to create local transaction: TransactionManager is null");
        }
        this.tx_mgr.begin();
        Transaction local_tx = this.tx_mgr.getTransaction();
        this.tx_table.put(local_tx, gtx);
        return local_tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrepare(GlobalTransaction gtx, List modifications, boolean commit) throws Exception {
        boolean success = true;
        Transaction ltx = this.tx_table.getLocalTransaction(gtx);
        Transaction curr_tx = this.tx_mgr.suspend();
        try {
            block18: {
                block20: {
                    block19: {
                        TransactionEntry entry;
                        if (ltx == null) {
                            ltx = this.createNewLocalTransaction(gtx);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("(" + this.cache.getLocalAddress() + "): started new local TX as result of PREPARE: local TX=" + ltx + ", global TX=" + gtx));
                            }
                        } else {
                            this.tx_mgr.resume(ltx);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("resuming existing transaction " + ltx + ", global TX=" + gtx));
                            }
                        }
                        if ((entry = this.tx_table.get(gtx)) == null) {
                            entry = new TransactionEntry();
                            entry.setTransaction(ltx);
                            this.tx_table.put(gtx, entry);
                        }
                        try {
                            if (modifications != null) {
                                Iterator it = modifications.iterator();
                                while (it.hasNext()) {
                                    Object retval;
                                    MethodCall method_call = (MethodCall)it.next();
                                    try {
                                        retval = super.invoke(method_call);
                                    }
                                    catch (Throwable t) {
                                        this.log.error((Object)"method invocation failed", t);
                                        retval = t;
                                    }
                                    if (retval == null || !(retval instanceof Exception)) continue;
                                    success = false;
                                    throw (Exception)retval;
                                }
                            }
                            Object var13_12 = null;
                            if (!commit) break block18;
                            if (!success) break block19;
                        }
                        catch (Throwable throwable) {
                            Object var13_13 = null;
                            if (commit) {
                                if (success) {
                                    ltx.commit();
                                } else {
                                    ltx.rollback();
                                }
                                this.transactions.remove((Object)ltx);
                                this.remote_transactions.remove(gtx);
                            }
                            throw throwable;
                        }
                        ltx.commit();
                        break block20;
                    }
                    ltx.rollback();
                }
                this.transactions.remove((Object)ltx);
                this.remote_transactions.remove(gtx);
                {
                }
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.tx_mgr.suspend();
            if (curr_tx != null) {
                this.tx_mgr.resume(curr_tx);
            }
            throw throwable;
        }
        this.tx_mgr.suspend();
        if (curr_tx != null) {
            this.tx_mgr.resume(curr_tx);
        }
    }

    protected void runPreparePhase(GlobalTransaction tx, MethodCall prepare_method, Address coordinator, List modifications, boolean async) throws Throwable {
        int num_mods;
        int n = num_mods = modifications != null ? modifications.size() : 0;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + "): running remote prepare for " + tx + " with async mode=" + async + " and coord=" + coordinator + " (" + num_mods + " modifications): " + modifications));
        }
        List rsps = this.cache.callRemoteMethods(this.cache.getMembers(), TreeCache.replicateMethod, new Object[]{prepare_method}, !async, true, this.cache.getSyncReplTimeout());
        if (!async && rsps != null) {
            this.checkResponses(rsps);
        }
    }

    protected void runCommitPhase(GlobalTransaction gtx) {
        boolean sync_commit_phase = this.cache.getSyncCommitPhase();
        try {
            MethodCall commit_method = new MethodCall(TreeCache.commitMethod, new Object[]{gtx});
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("running remote commit for " + gtx + " with async mode=" + !sync_commit_phase + " and coord=" + this.cache.getLocalAddress()));
            }
            this.cache.callRemoteMethods(this.cache.getMembers(), TreeCache.replicateMethod, new Object[]{commit_method}, sync_commit_phase, true, this.cache.getSyncReplTimeout());
        }
        catch (Throwable e) {
            this.log.error((Object)"commit failed", e);
        }
    }

    protected void runRollbackPhase(GlobalTransaction gtx) {
        boolean sync_rollback_phase = this.cache.getSyncRollbackPhase();
        try {
            MethodCall rollback_method = new MethodCall(TreeCache.rollbackMethod, new Object[]{gtx});
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("running remote rollback for " + gtx + " with async mode=" + sync_rollback_phase + " and coord=" + this.cache.getLocalAddress()));
            }
            this.cache.callRemoteMethods(this.cache.getMembers(), TreeCache.replicateMethod, new Object[]{rollback_method}, sync_rollback_phase, true, this.cache.getSyncReplTimeout());
        }
        catch (Throwable e) {
            this.log.error((Object)"rollback failed", e);
        }
    }

    void replicateAsynchronously(GlobalTransaction gtx, List modifications) {
        try {
            MethodCall mc = new MethodCall(TreeCache.prepareMethod, new Object[]{gtx, modifications, (Address)this.cache.getLocalAddress(), Boolean.TRUE});
            if (this.cache.getUseReplQueue() && this.cache.getReplQueue() != null) {
                this.cache.getReplQueue().add(new MethodCall(TreeCache.replicateMethod, new Object[]{mc}));
            } else {
                this.runPreparePhase(gtx, mc, (Address)this.cache.getLocalAddress(), modifications, true);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"failed to replicate asynchronously", t);
        }
    }

    class SynchronizationHandler
    implements Synchronization {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        TreeCache cache = null;
        List modifications = null;

        SynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.tx = tx;
            this.cache = cache;
        }

        public void beforeCompletion() {
            TransactionEntry entry = ReplicationInterceptor.this.tx_table.get(this.gtx);
            if (entry == null) {
                throw new IllegalStateException("cannot find transaction entry for " + this.gtx);
            }
            this.modifications = new LinkedList(entry.getModifications());
            if (this.modifications.size() == 0) {
                return;
            }
            if (this.cache.getCacheModeInternal() != 3) {
                return;
            }
            try {
                int status = this.tx.getStatus();
                switch (status) {
                    case 0: 
                    case 7: 
                    case 8: {
                        try {
                            MethodCall prepare_method = new MethodCall(TreeCache.prepareMethod, new Object[]{this.gtx, this.modifications, (Address)this.cache.getLocalAddress(), Boolean.FALSE});
                            ReplicationInterceptor.this.runPreparePhase(this.gtx, prepare_method, (Address)this.cache.getLocalAddress(), this.modifications, false);
                            break;
                        }
                        catch (Throwable t) {
                            ReplicationInterceptor.this.log.warn((Object)"runPreparePhase() failed. Transaction is marked as rolled back", t);
                            this.tx.setRollbackOnly();
                            throw t;
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("", t);
            }
        }

        public void afterCompletion(int status) {
            int cache_mode = this.cache.getCacheModeInternal();
            ReplicationInterceptor.this.transactions.remove((Object)this.tx);
            switch (status) {
                case 3: {
                    if (this.modifications == null || this.modifications.size() <= 0) break;
                    switch (cache_mode) {
                        case 2: {
                            ReplicationInterceptor.this.replicateAsynchronously(this.gtx, this.modifications);
                            break;
                        }
                        case 3: {
                            ReplicationInterceptor.this.runCommitPhase(this.gtx);
                        }
                    }
                    break;
                }
                case 1: 
                case 4: {
                    if (ReplicationInterceptor.this.log.isDebugEnabled()) {
                        ReplicationInterceptor.this.log.debug((Object)"afterCompletion(): rolling back transaction");
                    }
                    if (this.modifications == null || this.modifications.size() <= 0) break;
                    switch (cache_mode) {
                        case 3: {
                            ReplicationInterceptor.this.runRollbackPhase(this.gtx);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("illegal status: " + status);
                }
            }
        }

        public String toString() {
            return "ReplicationInterceptor(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }
}

