/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OptimisticMap
implements Map {
    private Map localMap = new HashMap();
    private Map removedValues = new HashMap();
    private Map originalMap;

    public OptimisticMap() {
        this(null);
    }

    public OptimisticMap(Map map) {
        this.originalMap = map == null ? new HashMap() : new HashMap(map);
        this.localMap.putAll(this.originalMap);
    }

    public int size() {
        return this.localMap.size();
    }

    public synchronized void clear() {
        Iterator it = this.localMap.keySet().iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            if (!this.originalMap.containsKey(temp)) continue;
            this.removedValues.put(temp, this.localMap.get(temp));
        }
        this.localMap.clear();
    }

    public boolean isEmpty() {
        return this.localMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.localMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.localMap.containsValue(value);
    }

    public Collection values() {
        return this.localMap.values();
    }

    public synchronized void putAll(Map t) {
        this.localMap.putAll(t);
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            if (!this.removedValues.containsKey(temp)) continue;
            this.removedValues.remove(temp);
        }
    }

    public Set entrySet() {
        return new EntrySet(this.localMap.entrySet());
    }

    Iterator newKeyIterator(Iterator it) {
        return new KeyIterator(it);
    }

    public Set keySet() {
        KeySet ks = new KeySet(this.localMap.keySet());
        return ks;
    }

    public Object get(Object key) {
        return this.localMap.get(key);
    }

    public synchronized Object remove(Object key) {
        Object temp = this.localMap.remove(key);
        if (this.originalMap.containsKey(key)) {
            this.removedValues.put(key, this.originalMap.get(key));
        }
        return temp;
    }

    public synchronized Object put(Object key, Object value) {
        this.removedValues.remove(key);
        return this.localMap.put(key, value);
    }

    public boolean equals(Object obj) {
        return ((Object)this.localMap).equals(obj);
    }

    public int hashCode() {
        return ((Object)this.localMap).hashCode();
    }

    Map getRemovedMap() {
        return this.removedValues;
    }

    Map getLocalMap() {
        return this.localMap;
    }

    Map getOriginalMap() {
        return this.originalMap;
    }

    private class KeySet
    implements Set {
        private Set keys;

        KeySet(Set keySet) {
            this.keys = keySet;
        }

        public Iterator iterator() {
            return OptimisticMap.this.newKeyIterator(this.keys.iterator());
        }

        public int size() {
            return this.keys.size();
        }

        public boolean contains(Object o) {
            return this.keys.contains(o);
        }

        public boolean remove(Object o) {
            boolean removed = this.keys.remove(o);
            if (OptimisticMap.this.originalMap.containsKey(o)) {
                OptimisticMap.this.removedValues.put(o, OptimisticMap.this.originalMap.get(o));
            }
            return removed;
        }

        public void clear() {
            this.keys.clear();
            OptimisticMap.this.clear();
        }

        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        public Object[] toArray() {
            return this.keys.toArray();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("not able to add to this set");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("not able to add to this set");
        }

        public boolean containsAll(Collection c) {
            return this.keys.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("not able to remove from this set");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("not able to remove from this set");
        }

        public Object[] toArray(Object[] a) {
            return this.keys.toArray(a);
        }

        public String toString() {
            return this.keys != null ? this.keys.toString() : "[]";
        }
    }

    private class KeyIterator
    implements Iterator {
        private Iterator localIterator = null;
        private Object currentKey = null;

        public KeyIterator(Iterator it) {
            this.localIterator = it;
        }

        public Object next() {
            this.currentKey = this.localIterator.next();
            return this.currentKey;
        }

        public void remove() {
            this.localIterator.remove();
            if (OptimisticMap.this.originalMap.containsKey(this.currentKey)) {
                OptimisticMap.this.removedValues.put(this.currentKey, OptimisticMap.this.originalMap.get(this.currentKey));
            }
        }

        public boolean hasNext() {
            return this.localIterator.hasNext();
        }
    }

    private class EntrySet
    implements Set {
        private Set entries;

        EntrySet(Set entries) {
            this.entries = entries;
        }

        public Iterator iterator() {
            return new EntryIterator(this.entries.iterator());
        }

        public int size() {
            return this.entries.size();
        }

        public boolean contains(Object o) {
            return this.entries.contains(o);
        }

        public boolean remove(Object o) {
            boolean removed = this.entries.remove(o);
            if (removed) {
                Map.Entry entry = (Map.Entry)o;
                OptimisticMap.this.removedValues.put(entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        }

        public void clear() {
            this.entries.clear();
            OptimisticMap.this.clear();
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public Object[] toArray() {
            throw new UnsupportedOperationException("not able to add to this set");
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("not able to add to this set");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("not able to add to this set");
        }

        public boolean containsAll(Collection c) {
            return this.entries.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("not able to remove from this set");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("not able to remove from this set");
        }

        public Object[] toArray(Object[] a) {
            return this.entries.toArray(a);
        }
    }

    private class EntryIterator
    implements Iterator {
        private Iterator localIterator;
        private Object currentEntry = null;

        EntryIterator(Iterator it) {
            this.localIterator = it;
        }

        public Object next() {
            this.currentEntry = this.localIterator.next();
            return this.currentEntry;
        }

        public void remove() {
            this.localIterator.remove();
            Map.Entry entry = (Map.Entry)this.currentEntry;
            if (OptimisticMap.this.originalMap.containsKey(entry.getKey())) {
                OptimisticMap.this.removedValues.put(entry.getKey(), entry.getValue());
            }
        }

        public boolean hasNext() {
            return this.localIterator.hasNext();
        }
    }
}

