/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.optimistic.DataVersioningException;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticValidatorInterceptor
extends OptimisticInterceptor {
    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        InvocationContext ctx = this.getInvocationContext();
        Transaction tx = ctx.getTransaction();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        Object retval = null;
        if (this.isBuddyGroupOrganisationMethod(m)) {
            return super.invoke(m);
        }
        if (tx == null) {
            throw new CacheException("Not in a transaction");
        }
        switch (m.getMethodId()) {
            case 18: {
                this.validateNodes(gtx);
                break;
            }
            case 11: {
                this.commit(gtx);
                break;
            }
            case 12: {
                this.rollBack(gtx);
                break;
            }
            default: {
                retval = super.invoke(m);
            }
        }
        return retval;
    }

    private void validateNodes(GlobalTransaction gtx) throws CacheException {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            throw new CacheException("unable to retrieve workspace", e);
        }
        Collection nodes = workspace.getNodes().values();
        this.log.debug((Object)"validating nodes");
        this.simpleValidate(nodes);
        this.log.debug((Object)"validated nodes");
    }

    private void simpleValidate(Collection nodes) throws CacheException {
        boolean trace = this.log.isTraceEnabled();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            OptimisticTreeNode realNode;
            WorkspaceNode workspaceNode = (WorkspaceNode)it.next();
            Fqn fqn = workspaceNode.getFqn();
            if (trace) {
                this.log.trace((Object)("validating version for node " + fqn));
            }
            if ((realNode = (OptimisticTreeNode)this.cache._get(fqn)) == null && !workspaceNode.isCreated()) {
                throw new DataVersioningException("Real node for " + fqn + " is null, and this wasn't newly created in this tx!");
            }
            if (realNode != null && workspaceNode.isCreated()) {
                throw new DataVersioningException("Tx attempted to create " + fqn + " anew.  It has already been created since this tx started by another (possibly remote) tx.");
            }
            if (workspaceNode.isCreated() || !workspaceNode.isDeleted() && !workspaceNode.isDirty() || !realNode.getVersion().newerThan(workspaceNode.getVersion())) continue;
            throw new DataVersioningException("DataNode [" + fqn + "] version " + ((OptimisticTreeNode)workspaceNode.getNode()).getVersion() + " is newer than workspace node " + workspaceNode.getVersion());
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            this.log.trace((Object)"we can't rollback", (Throwable)e);
            return;
        }
        this.log.debug((Object)"commiting validated changes ");
        Collection nodes = workspace.getNodes().values();
        boolean trace = this.log.isTraceEnabled();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            WorkspaceNode wrappedNode = (WorkspaceNode)it.next();
            if (trace) {
                this.log.trace((Object)("Analysing node " + wrappedNode.getFqn() + " in workspace."));
            }
            if (wrappedNode.isDeleted()) {
                if (trace) {
                    this.log.trace((Object)"Node's been deleted; removing");
                }
                DataNode dNode = wrappedNode.getNode();
                this.cache.notifyNodeRemove(dNode.getFqn(), true);
                if (dNode.getFqn().isRoot()) {
                    this.log.warn((Object)"Attempted to delete the root node");
                } else {
                    DataNode parent = (DataNode)dNode.getParent();
                    parent.removeChild(dNode.getName());
                }
                this.cache.notifyNodeRemoved(dNode.getFqn());
                this.cache.notifyNodeRemove(dNode.getFqn(), false);
                continue;
            }
            if (wrappedNode.isDirty()) {
                this.cache.notifyNodeModify(wrappedNode.getFqn(), true);
                OptimisticTreeNode current = (OptimisticTreeNode)wrappedNode.getNode();
                Map mergedChildren = wrappedNode.getMergedChildren();
                current.setChildren(mergedChildren);
                if (trace) {
                    this.log.trace((Object)("inserting merged data " + wrappedNode.getMergedData()));
                }
                Map mergedData = wrappedNode.getMergedData();
                current.put(mergedData, true);
                if (wrappedNode.isVersioningImplicit()) {
                    if (trace) {
                        this.log.trace((Object)"Versioning is implicit; incrementing.");
                    }
                    if (wrappedNode.getVersion() instanceof DefaultDataVersion) {
                        current.setVersion(((DefaultDataVersion)wrappedNode.getVersion()).increment());
                    } else {
                        this.log.debug((Object)"Even though no explicit version was passed in, node has an external DataVersion impl.  Don't know how to increment, not incrementing.");
                    }
                } else {
                    if (trace) {
                        this.log.trace((Object)"Versioning is explicit; not attempting an increment.");
                    }
                    current.setVersion(wrappedNode.getVersion());
                }
                if (trace) {
                    this.log.trace((Object)("Setting version of node from " + wrappedNode.getVersion() + " to " + current.getVersion()));
                }
                this.cache.notifyNodeModified(wrappedNode.getFqn());
                this.cache.notifyNodeModify(wrappedNode.getFqn(), false);
                continue;
            }
            if (trace) {
                this.log.trace((Object)"Merging not necessary since the node is not dirty");
            }
            this.cache.notifyNodeVisited(wrappedNode.getFqn());
        }
    }

    private void rollBack(GlobalTransaction gtx) {
        try {
            TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
            Map nodes = workspace.getNodes();
            nodes.clear();
        }
        catch (CacheException e) {
            this.log.info((Object)"Unable to roll back", (Throwable)e);
        }
    }
}

