/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.eviction.BaseSortedEvictionAlgorithm;
import org.jboss.cache.eviction.ElementSizeConfiguration;
import org.jboss.cache.eviction.ElementSizeQueue;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.Region;

public class ElementSizeAlgorithm
extends BaseSortedEvictionAlgorithm {
    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new ElementSizeQueue();
    }

    protected boolean shouldEvictNode(NodeEntry ne) {
        ElementSizeConfiguration config = (ElementSizeConfiguration)this.region.getEvictionConfiguration();
        int size = this.getEvictionQueue().getNumberOfNodes();
        if (config.getMaxNodes() != 0 && size > config.getMaxNodes()) {
            return true;
        }
        return ne.getNumberOfElements() > config.getMaxElementsPerNode();
    }

    protected void prune() throws EvictionException {
        super.prune();
        ((ElementSizeQueue)this.evictionQueue).prune();
    }
}

