/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoaderManager;

public class InterceptorChainFactory {
    private static Log log = LogFactory.getLog((Class)InterceptorChainFactory.class);

    public Interceptor buildInterceptorChain(TreeCache cache) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (cache.isNodeLockingOptimistic()) {
            return this.createOptimisticInterceptorChain(cache);
        }
        return this.createPessimisticInterceptorChain(cache);
    }

    private Interceptor createInterceptor(String classname, TreeCache cache) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class clazz = this.loadClass(classname);
        Interceptor i = (Interceptor)clazz.newInstance();
        i.setCache(cache);
        return i;
    }

    private void addInterceptor(Interceptor first, Interceptor i) {
        if (first == null) {
            return;
        }
        while (first.getNext() != null) {
            first = first.getNext();
        }
        first.setNext(i);
    }

    protected Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(classname);
    }

    private Interceptor createPessimisticInterceptorChain(TreeCache cache) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Interceptor call_interceptor = null;
        Interceptor lock_interceptor = null;
        Interceptor repl_interceptor = null;
        Interceptor cache_loader_interceptor = null;
        Interceptor cache_store_interceptor = null;
        Interceptor unlock_interceptor = null;
        Interceptor passivation_interceptor = null;
        Interceptor activation_interceptor = null;
        Interceptor cacheMgmtInterceptor = null;
        Interceptor txInterceptor = null;
        Interceptor eviction_interceptor = null;
        Interceptor dataGravitatorInterceptor = null;
        Interceptor first = null;
        call_interceptor = this.createInterceptor("org.jboss.cache.interceptors.CallInterceptor", cache);
        if (cache.getBuddyManager() != null) {
            dataGravitatorInterceptor = this.createInterceptor("org.jboss.cache.interceptors.DataGravitatorInterceptor", cache);
        }
        lock_interceptor = this.createInterceptor("org.jboss.cache.interceptors.PessimisticLockInterceptor", cache);
        unlock_interceptor = this.createInterceptor("org.jboss.cache.interceptors.UnlockInterceptor", cache);
        cacheMgmtInterceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheMgmtInterceptor", cache);
        txInterceptor = this.createInterceptor("org.jboss.cache.interceptors.TxInterceptor", cache);
        switch (cache.getCacheModeInternal()) {
            case 2: 
            case 3: {
                repl_interceptor = this.createInterceptor("org.jboss.cache.interceptors.ReplicationInterceptor", cache);
                break;
            }
            case 4: 
            case 5: {
                repl_interceptor = this.createInterceptor("org.jboss.cache.interceptors.InvalidationInterceptor", cache);
                break;
            }
        }
        CacheLoaderManager cacheLoaderMgr = cache.getCacheLoaderManager();
        if (cacheLoaderMgr != null && cacheLoaderMgr.getCacheLoader() != null) {
            if (cacheLoaderMgr.isPassivation()) {
                activation_interceptor = this.createInterceptor("org.jboss.cache.interceptors.ActivationInterceptor", cache);
                passivation_interceptor = this.createInterceptor("org.jboss.cache.interceptors.PassivationInterceptor", cache);
            } else {
                cache_loader_interceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheLoaderInterceptor", cache);
                cache_store_interceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheStoreInterceptor", cache);
            }
        }
        if (cache.getUseInterceptorMbeans()) {
            if (first == null) {
                first = cacheMgmtInterceptor;
            } else {
                this.addInterceptor(first, cacheMgmtInterceptor);
            }
        }
        if (first == null) {
            first = txInterceptor;
        } else {
            this.addInterceptor(first, txInterceptor);
        }
        if (activation_interceptor != null && !cacheLoaderMgr.isFetchPersistentState()) {
            if (first == null) {
                first = passivation_interceptor;
            } else {
                this.addInterceptor(first, passivation_interceptor);
            }
        }
        if (cache_loader_interceptor != null && !cacheLoaderMgr.isFetchPersistentState()) {
            if (first == null) {
                first = cache_store_interceptor;
            } else {
                this.addInterceptor(first, cache_store_interceptor);
            }
        }
        if (repl_interceptor != null) {
            if (first == null) {
                first = repl_interceptor;
            } else {
                this.addInterceptor(first, repl_interceptor);
            }
        }
        if (unlock_interceptor != null) {
            if (first == null) {
                first = unlock_interceptor;
            } else {
                this.addInterceptor(first, unlock_interceptor);
            }
        }
        if (activation_interceptor != null) {
            if (!cacheLoaderMgr.isFetchPersistentState()) {
                if (first == null) {
                    first = activation_interceptor;
                } else {
                    this.addInterceptor(first, activation_interceptor);
                }
            } else {
                if (first == null) {
                    first = activation_interceptor;
                } else {
                    this.addInterceptor(first, activation_interceptor);
                }
                if (first == null) {
                    first = passivation_interceptor;
                } else {
                    this.addInterceptor(first, passivation_interceptor);
                }
            }
        }
        if (cache_loader_interceptor != null) {
            if (!cacheLoaderMgr.isFetchPersistentState()) {
                if (first == null) {
                    first = cache_loader_interceptor;
                } else {
                    this.addInterceptor(first, cache_loader_interceptor);
                }
            } else {
                if (first == null) {
                    first = cache_loader_interceptor;
                } else {
                    this.addInterceptor(first, cache_loader_interceptor);
                }
                if (first == null) {
                    first = cache_store_interceptor;
                } else {
                    this.addInterceptor(first, cache_store_interceptor);
                }
            }
        }
        if (dataGravitatorInterceptor != null) {
            if (first == null) {
                first = dataGravitatorInterceptor;
            } else {
                this.addInterceptor(first, dataGravitatorInterceptor);
            }
        }
        if (first == null) {
            first = lock_interceptor;
        } else {
            this.addInterceptor(first, lock_interceptor);
        }
        if (cache.isUsingEviction()) {
            eviction_interceptor = this.createInterceptor(cache.getEvictionInterceptorClass(), cache);
            if (first == null) {
                first = eviction_interceptor;
            } else {
                this.addInterceptor(first, eviction_interceptor);
            }
        }
        if (first == null) {
            first = call_interceptor;
        } else {
            this.addInterceptor(first, call_interceptor);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("interceptor chain is:\n" + InterceptorChainFactory.printInterceptorChain(first)));
        }
        return first;
    }

    private Interceptor createOptimisticInterceptorChain(TreeCache cache) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Interceptor txInterceptor = null;
        Interceptor replicationInterceptor = null;
        Interceptor lockInterceptor = null;
        Interceptor validationInterceptor = null;
        Interceptor createIfNotExistsInterceptor = null;
        Interceptor nodeInterceptor = null;
        Interceptor invokerInterceptor = null;
        Interceptor activationInterceptor = null;
        Interceptor passivationInterceptor = null;
        Interceptor cacheLoaderInterceptor = null;
        Interceptor cacheStoreInterceptor = null;
        Interceptor first = null;
        Interceptor cacheMgmtInterceptor = null;
        Interceptor evictionInterceptor = null;
        Interceptor dataGravitatorInterceptor = null;
        CacheLoaderManager cacheLoaderManager = cache.getCacheLoaderManager();
        if (cacheLoaderManager != null && cacheLoaderManager.getCacheLoader() != null) {
            if (cacheLoaderManager.isPassivation()) {
                activationInterceptor = this.createInterceptor("org.jboss.cache.interceptors.ActivationInterceptor", cache);
                passivationInterceptor = this.createInterceptor("org.jboss.cache.interceptors.PassivationInterceptor", cache);
            } else {
                cacheLoaderInterceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheLoaderInterceptor", cache);
                cacheStoreInterceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheStoreInterceptor", cache);
            }
        }
        txInterceptor = this.createInterceptor("org.jboss.cache.interceptors.TxInterceptor", cache);
        if (cache.getBuddyManager() != null) {
            dataGravitatorInterceptor = this.createInterceptor("org.jboss.cache.interceptors.DataGravitatorInterceptor", cache);
        }
        switch (cache.getCacheModeInternal()) {
            case 2: 
            case 3: {
                replicationInterceptor = this.createInterceptor("org.jboss.cache.interceptors.OptimisticReplicationInterceptor", cache);
                break;
            }
            case 4: 
            case 5: {
                replicationInterceptor = this.createInterceptor("org.jboss.cache.interceptors.InvalidationInterceptor", cache);
                break;
            }
        }
        lockInterceptor = this.createInterceptor("org.jboss.cache.interceptors.OptimisticLockingInterceptor", cache);
        validationInterceptor = this.createInterceptor("org.jboss.cache.interceptors.OptimisticValidatorInterceptor", cache);
        createIfNotExistsInterceptor = this.createInterceptor("org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor", cache);
        nodeInterceptor = this.createInterceptor("org.jboss.cache.interceptors.OptimisticNodeInterceptor", cache);
        invokerInterceptor = this.createInterceptor("org.jboss.cache.interceptors.CallInterceptor", cache);
        if (cache.isUsingEviction()) {
            evictionInterceptor = this.createInterceptor(cache.getEvictionInterceptorClass(), cache);
        }
        if (cache.getUseInterceptorMbeans()) {
            cacheMgmtInterceptor = this.createInterceptor("org.jboss.cache.interceptors.CacheMgmtInterceptor", cache);
            if (first == null) {
                first = cacheMgmtInterceptor;
            } else {
                this.addInterceptor(first, cacheMgmtInterceptor);
            }
        }
        if (txInterceptor != null) {
            if (first == null) {
                first = txInterceptor;
            } else {
                this.addInterceptor(first, txInterceptor);
            }
        }
        if (first == null) {
            first = replicationInterceptor;
        } else {
            this.addInterceptor(first, replicationInterceptor);
        }
        if (passivationInterceptor != null && !cacheLoaderManager.isFetchPersistentState()) {
            if (first == null) {
                first = passivationInterceptor;
            } else {
                this.addInterceptor(first, passivationInterceptor);
            }
        }
        if (cacheStoreInterceptor != null && !cacheLoaderManager.isFetchPersistentState()) {
            if (first == null) {
                first = cacheStoreInterceptor;
            } else {
                this.addInterceptor(first, cacheStoreInterceptor);
            }
        }
        if (activationInterceptor != null) {
            if (first == null) {
                first = activationInterceptor;
            } else {
                this.addInterceptor(first, activationInterceptor);
            }
            if (cacheLoaderManager.isFetchPersistentState()) {
                if (first == null) {
                    first = passivationInterceptor;
                } else {
                    this.addInterceptor(first, passivationInterceptor);
                }
            }
        }
        if (cacheLoaderInterceptor != null) {
            if (first == null) {
                first = cacheLoaderInterceptor;
            } else {
                this.addInterceptor(first, cacheLoaderInterceptor);
            }
            if (cacheLoaderManager.isFetchPersistentState()) {
                if (first == null) {
                    first = cacheStoreInterceptor;
                } else {
                    this.addInterceptor(first, cacheStoreInterceptor);
                }
            }
        }
        if (dataGravitatorInterceptor != null) {
            if (first == null) {
                first = dataGravitatorInterceptor;
            } else {
                this.addInterceptor(first, dataGravitatorInterceptor);
            }
        }
        if (first == null) {
            first = lockInterceptor;
        } else {
            this.addInterceptor(first, lockInterceptor);
        }
        if (first == null) {
            first = validationInterceptor;
        } else {
            this.addInterceptor(first, validationInterceptor);
        }
        if (first == null) {
            first = createIfNotExistsInterceptor;
        } else {
            this.addInterceptor(first, createIfNotExistsInterceptor);
        }
        if (first == null) {
            first = evictionInterceptor;
        } else {
            this.addInterceptor(first, evictionInterceptor);
        }
        if (first == null) {
            first = nodeInterceptor;
        } else {
            this.addInterceptor(first, nodeInterceptor);
        }
        if (first == null) {
            first = invokerInterceptor;
        } else {
            this.addInterceptor(first, invokerInterceptor);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("interceptor chain is:\n" + InterceptorChainFactory.printInterceptorChain(first)));
        }
        return first;
    }

    public static String printInterceptorChain(Interceptor i) {
        StringBuffer sb = new StringBuffer();
        if (i != null) {
            if (i.getNext() != null) {
                sb.append(InterceptorChainFactory.printInterceptorChain(i.getNext())).append("\n");
            }
            sb.append(i.getClass());
        }
        return sb.toString();
    }

    public static List asList(Interceptor interceptor) {
        if (interceptor == null) {
            return null;
        }
        int num = 1;
        Interceptor tmp = interceptor;
        while ((tmp = tmp.getNext()) != null) {
            ++num;
        }
        ArrayList<Interceptor> retval = new ArrayList<Interceptor>(num);
        tmp = interceptor;
        num = 0;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return retval;
    }
}

