/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Node;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.TreeCache;
import org.jboss.cache.aop.BaseInterceptor;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.ModificationEntry;
import org.jboss.cache.aop.PojoCacheMBean;
import org.jboss.cache.aop.PojoTxSynchronizationHandler;
import org.jboss.cache.aop.TreeCacheAopDelegate;
import org.jboss.cache.aop.eviction.AopEvictionPolicy;
import org.jboss.cache.aop.util.ObjectUtil;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.cache.marshall.ObjectSerializationFactory;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionNameConflictException;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.JChannel;
import org.w3c.dom.Element;

public class PojoCache
extends TreeCache
implements PojoCacheMBean {
    protected Map cachedTypes = new WeakHashMap();
    TransactionManager localTm_ = BatchModeTransactionManager.getInstance();
    protected TreeCacheAopDelegate delegate_;
    Element config_ = null;
    protected final String LOCK = "_lock_";
    protected final int RETRY = 5;
    protected boolean marshallNonSerializable_ = false;
    protected ThreadLocal undoListLocal_ = new ThreadLocal();
    protected ThreadLocal hasSynchronizationHandler_ = new ThreadLocal();

    public PojoCache(String cluster_name, String props, long state_fetch_timeout) throws Exception {
        super(cluster_name, props, state_fetch_timeout);
        this.init();
    }

    public PojoCache() throws Exception {
        this.init();
    }

    public PojoCache(JChannel channel) throws Exception {
        super(channel);
        this.init();
    }

    protected void init() {
        this.delegate_ = new TreeCacheAopDelegate(this);
    }

    public void startService() throws Exception {
        super.startService();
        this.parseConfig();
    }

    public void stopService() {
        super.stopService();
    }

    protected void parseConfig() {
        if (this.config_ == null) {
            log.info((Object)"parseConfig(): PojoCacheConfig is empty");
            return;
        }
        this.marshallNonSerializable_ = XmlHelper.readBooleanContents(this.config_, "marshallNonSerializable");
        log.info((Object)("marshallNonSerializable flag is set: " + this.marshallNonSerializable_));
    }

    public void setEvictionPolicyClass(String eviction_policy_class) {
        this.eviction_policy_class = eviction_policy_class;
        if (eviction_policy_class == null || eviction_policy_class.length() == 0) {
            return;
        }
        try {
            Object obj = this.loadClass(eviction_policy_class).newInstance();
            if (!(obj instanceof AopEvictionPolicy)) {
                throw new RuntimeException("PojoCache.setEvictionPolicyClass(). Eviction policy provider:" + eviction_policy_class + " is not an instance of AopEvictionPolicy.");
            }
            super.setEvictionPolicyClass(eviction_policy_class);
        }
        catch (RuntimeException ex) {
            log.error((Object)("setEvictionPolicyClass(): failed creating instance of  " + eviction_policy_class), (Throwable)ex);
            throw ex;
        }
        catch (Throwable t) {
            log.error((Object)("setEvictionPolicyClass(): failed creating instance of  " + eviction_policy_class), t);
        }
    }

    public void addUndoInterceptor(InstanceAdvisor advisor, BaseInterceptor interceptor, int op) {
        ArrayList<ModificationEntry> list = (ArrayList<ModificationEntry>)this.undoListLocal_.get();
        if (list == null) {
            list = new ArrayList<ModificationEntry>();
            this.undoListLocal_.set(list);
        }
        ModificationEntry ent = new ModificationEntry(advisor, interceptor, op);
        list.add(ent);
    }

    public void addUndoCollectionProxy(Field field, Object key, Object oldValue) {
        ArrayList<ModificationEntry> list = (ArrayList<ModificationEntry>)this.undoListLocal_.get();
        if (list == null) {
            list = new ArrayList<ModificationEntry>();
            this.undoListLocal_.set(list);
        }
        ModificationEntry ent = new ModificationEntry(field, key, oldValue);
        list.add(ent);
    }

    public void resetUndoOp() {
        List list = (List)this.undoListLocal_.get();
        if (list != null) {
            list.clear();
        }
        this.hasSynchronizationHandler_.set(null);
    }

    public List getModList() {
        return (List)this.undoListLocal_.get();
    }

    public void evict(Fqn fqn) throws CacheException {
        if (this.delegate_.isAopNode(fqn)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evict(): evicting whole aop node " + fqn));
            }
            this.recursiveEvict(fqn);
        } else {
            super.evict(fqn);
        }
    }

    void recursiveEvict(Fqn fqn) throws CacheException {
        boolean create_undo_ops = true;
        boolean sendNodeEvent = false;
        this._remove((GlobalTransaction)null, fqn, create_undo_ops, sendNodeEvent);
        this.realRemove(fqn, false);
    }

    void plainEvict(Fqn fqn) throws CacheException {
        super.evict(fqn);
    }

    protected void createEvictionPolicy() {
        super.createEvictionPolicy();
        this.evictionInterceptorClass = "org.jboss.cache.aop.interceptors.PojoEvictionInterceptor";
    }

    protected void _evictSubtree(Fqn subtree) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("_evictSubtree(" + subtree + ")"));
        }
        if (this.delegate_.isAopNode(subtree)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evict(): evicting whole aop node " + subtree));
            }
            this.recursiveEvict(subtree);
        } else {
            super._evictSubtree(subtree);
        }
    }

    public void activateRegion(String subtreeFqn) throws RegionNotEmptyException, RegionNameConflictException, CacheException {
        if (!this.useRegionBasedMarshalling) {
            throw new IllegalStateException("TreeCache.activateRegion(). useRegionBasedMarshalling flag is not set!");
        }
        if ("/".equals(subtreeFqn)) {
            super.activateRegion(subtreeFqn);
        } else {
            Region region = this.regionManager_.getRegion(InternalDelegate.JBOSS_INTERNAL);
            if (region == null && this.inactiveOnStartup || region != null && region.isInactive()) {
                super.activateRegion(InternalDelegate.JBOSS_INTERNAL.toString());
            }
            if (this.get(InternalDelegate.JBOSS_INTERNAL_MAP) == null) {
                this.createSubtreeRootNode(InternalDelegate.JBOSS_INTERNAL_MAP);
            }
            super.activateRegion(subtreeFqn);
        }
    }

    protected void acquireLocksForStateTransfer(DataNode root, Object lockOwner, long timeout, boolean force) throws Exception {
        Node refMapNode;
        super.acquireLocksForStateTransfer(root, lockOwner, timeout, true, force);
        Fqn fqn = root.getFqn();
        if (fqn.size() > 0 && !fqn.isChildOf(InternalDelegate.JBOSS_INTERNAL) && (refMapNode = this.get(InternalDelegate.JBOSS_INTERNAL_MAP)) != null) {
            super.acquireLocksForStateTransfer(refMapNode, lockOwner, timeout, false, force);
            Map children = refMapNode.getChildren();
            if (children != null) {
                String targetFqn = ObjectUtil.getIndirectFqn(fqn);
                Iterator iter = children.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (!((String)entry.getKey()).startsWith(targetFqn)) continue;
                    super.acquireLocksForStateTransfer((DataNode)entry.getValue(), lockOwner, timeout, false, force);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseStateTransferLocks(DataNode root, Object lockOwner) {
        block8: {
            boolean releaseInternal = true;
            try {
                super.releaseStateTransferLocks(root, lockOwner, true);
                Fqn fqn = root.getFqn();
                releaseInternal = fqn.size() > 0 && !fqn.isChildOf(InternalDelegate.JBOSS_INTERNAL);
                Object var6_5 = null;
                if (!releaseInternal) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (releaseInternal) {
                    try {
                        Node refMapNode = this.get(InternalDelegate.JBOSS_INTERNAL_MAP);
                        if (refMapNode != null) {
                            super.releaseStateTransferLocks(refMapNode, lockOwner, true);
                        }
                    }
                    catch (CacheException ce) {
                        log.error((Object)"Caught exception releasing locks on internal RefMap", (Throwable)ce);
                    }
                }
                throw throwable;
            }
            try {
                Node refMapNode = this.get(InternalDelegate.JBOSS_INTERNAL_MAP);
                if (refMapNode != null) {
                    super.releaseStateTransferLocks(refMapNode, lockOwner, true);
                }
            }
            catch (CacheException ce) {
                log.error((Object)"Caught exception releasing locks on internal RefMap", (Throwable)ce);
            }
        }
    }

    public synchronized CachedType getCachedType(Class clazz) {
        CachedType type = (CachedType)this.cachedTypes.get(clazz);
        if (type == null) {
            type = new CachedType(clazz);
            this.cachedTypes.put(clazz, type);
            return type;
        }
        return type;
    }

    public Object getObject(String fqn) throws CacheException {
        return this.getObject(Fqn.fromString(fqn));
    }

    public Object getObject(Fqn fqn) throws CacheException {
        return this._getObject(fqn);
    }

    public Object putObject(String fqn, Object obj) throws CacheException {
        return this.putObject(Fqn.fromString(fqn), obj);
    }

    public Object putObject(Fqn fqn, Object obj) throws CacheException {
        this.checkFqnValidity(fqn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("putObject(): Fqn:" + fqn));
        }
        Object owner = null;
        if (this.hasCurrentTransaction()) {
            owner = this.getOwnerForLock();
            if (!this.lockPojo(owner, fqn)) {
                throw new CacheException("PojoCache.putObject(): Can't obtain the pojo lock under fqn: " + fqn);
            }
            return this._putObject(fqn, obj);
        }
        try {
            Object objOld;
            this.localTm_.begin();
            owner = this.getOwnerForLock();
            if (!this.lockPojo(owner, fqn)) {
                throw new CacheException("PojoCache.putObject(): Can't obtain the pojo lock under fqn: " + fqn);
            }
            Object object = objOld = this._putObject(fqn, obj);
            return object;
        }
        catch (Exception e) {
            log.warn((Object)("putObject(): exception occurred: " + e));
            try {
                this.localTm_.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new RuntimeException("PojoCache.putObject(): fqn: " + fqn, e);
        }
        finally {
            this.endTransaction(fqn);
        }
    }

    public Object removeObject(String fqn) throws CacheException {
        return this.removeObject(Fqn.fromString(fqn));
    }

    public Object removeObject(Fqn fqn) throws CacheException {
        this.checkFqnValidity(fqn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeObject(): Fqn:" + fqn));
        }
        Object owner = null;
        if (this.hasCurrentTransaction()) {
            owner = this.getOwnerForLock();
            if (!this.lockPojo(owner, fqn)) {
                throw new CacheException("PojoCache.removeObject(): Can't obtain the pojo lock under fqn: " + fqn);
            }
            return this._removeObject(fqn, true);
        }
        try {
            this.localTm_.begin();
            owner = this.getOwnerForLock();
            if (!this.lockPojo(owner, fqn)) {
                throw new CacheException("PojoCache.removeObject(): Can't obtain the pojo lock under fqn: " + fqn);
            }
            Object object = this._removeObject(fqn, true);
            return object;
        }
        catch (Exception e) {
            log.warn((Object)("removeObject(): exception occurred: " + e));
            try {
                this.localTm_.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new RuntimeException("PojoCache.removeObject(): fqn: " + fqn, e);
        }
        finally {
            this.endTransaction(fqn);
        }
    }

    public Map findObjects(String fqn) throws CacheException {
        return this.findObjects(Fqn.fromString(fqn));
    }

    public Map findObjects(Fqn fqn) throws CacheException {
        return this._findObjects(fqn);
    }

    public void setMarshallNonSerializable(boolean marshall) {
        if (marshall && !ObjectSerializationFactory.useJBossSerialization()) {
            throw new IllegalStateException("PojoCache.setMarshallNonSerializable(). Can't set MarshallNonSerializable to true since useJBossSerialization is false");
        }
        this.marshallNonSerializable_ = marshall;
    }

    public boolean isMarshallNonSerializable() {
        return this.marshallNonSerializable_;
    }

    public void setPojoCacheConfig(Element config) throws CacheException {
        this.config_ = config;
    }

    public Element getPojoCacheConfig() {
        return this.config_;
    }

    private void checkFqnValidity(Fqn fqn) {
        if (fqn.equals(InternalDelegate.JBOSS_INTERNAL)) {
            throw new IllegalArgumentException("checkFqnValidity(): fqn is not valid: " + fqn);
        }
    }

    protected boolean lockPojo(Object owner, Fqn fqn) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("lockPojo(): Fqn:" + fqn + " Owner: " + owner));
        }
        boolean isNeeded = true;
        int retry = 0;
        while (isNeeded) {
            try {
                this.put(fqn, (Object)"_lock_", (Object)"LOCK");
                isNeeded = false;
            }
            catch (UpgradeException upe) {
                log.warn((Object)("lockPojo(): can't upgrade the lock during lockPojo. Will re-try. Fqn: " + fqn + " retry times: " + retry));
                this.get(fqn).release(owner);
                if (retry++ > 5) {
                    return false;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
        }
        return true;
    }

    protected void releasePojo(Object owner, Fqn fqn) throws CacheException {
        Node node = this.get(fqn);
        if (node == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"releasePojo(): node could have been released already.");
            }
            return;
        }
        node.release(owner);
    }

    protected boolean hasCurrentTransaction() {
        try {
            if (this.getCurrentTransaction() != null || this.localTm_.getTransaction() != null) {
                return true;
            }
        }
        catch (SystemException e) {
            throw new RuntimeException("PojoCache.hasCurrentTransaction: ", e);
        }
        return false;
    }

    protected void endTransaction(Fqn fqn) {
        if (this.localTm_ == null) {
            log.warn((Object)("PojoCache.endTransaction(): tm is null for fqn: " + fqn));
            return;
        }
        try {
            if (this.localTm_.getTransaction().getStatus() != 1) {
                this.localTm_.commit();
            } else if (this.localTm_.getTransaction().getStatus() == 4) {
                log.info((Object)("PojoCache.endTransaction(): has been rolled back for fqn: " + fqn));
            } else {
                log.info((Object)("PojoCache.endTransaction(): rolling back tx for fqn: " + fqn));
                this.localTm_.rollback();
            }
        }
        catch (RollbackException re) {
            log.warn((Object)("PojoCache.endTransaction(): rolling back transaction with exception: " + (Object)((Object)re)));
        }
        catch (Exception e) {
            log.warn((Object)("PojoCache.endTransaction(): Failed with exception: " + e));
        }
    }

    public Object _getObject(Fqn fqn) throws CacheException {
        return this.delegate_._getObject(fqn);
    }

    public Object _putObject(Fqn fqn, Object obj) throws CacheException {
        this.registerTxHandler();
        return this.delegate_._putObject(fqn, obj);
    }

    protected void registerTxHandler() throws CacheException {
        try {
            Boolean isTrue = (Boolean)this.hasSynchronizationHandler_.get();
            if (isTrue == null || !isTrue.booleanValue()) {
                Transaction tx = this.getLocalTransaction();
                if (tx == null) {
                    tx = this.localTm_.getTransaction();
                }
                if (tx == null) {
                    throw new IllegalStateException("PojoCache.registerTxHanlder(). Can't have null tx handle.");
                }
                tx.registerSynchronization((Synchronization)new PojoTxSynchronizationHandler(tx, this));
                this.hasSynchronizationHandler_.set(Boolean.TRUE);
            }
        }
        catch (RollbackException e) {
            throw new CacheException("_putObject(). Exception: " + (Object)((Object)e));
        }
        catch (SystemException e) {
            throw new CacheException("_putObject(). Exception: " + (Object)((Object)e));
        }
    }

    public Object _removeObject(Fqn fqn) throws CacheException {
        boolean removeCacheInterceptor = true;
        return this._removeObject(fqn, removeCacheInterceptor);
    }

    public Object _removeObject(Fqn fqn, boolean removeCacheInterceptor) throws CacheException {
        boolean evict = false;
        this.delegate_.setBulkRemove(true);
        this.registerTxHandler();
        return this.delegate_._removeObject(fqn, removeCacheInterceptor, evict);
    }

    public Object _evictObject(Fqn fqn) throws CacheException {
        boolean evict = true;
        boolean removeCacheInterceptor = false;
        this.delegate_.setBulkRemove(false);
        return this.delegate_._removeObject(fqn, removeCacheInterceptor, evict);
    }

    public Map _findObjects(Fqn fqn) throws CacheException {
        return this.delegate_._findObjects(fqn);
    }
}

