/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyLocator;
import org.jboss.cache.buddyreplication.BuddyNotInitException;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.stack.IpAddress;
import org.w3c.dom.Element;

public class BuddyManager {
    private static Log log = LogFactory.getLog((Class)BuddyManager.class);
    private boolean enabled;
    BuddyLocator buddyLocator;
    private TreeCache cache;
    BuddyGroup buddyGroup;
    Map buddyPool;
    final Set nullBuddyPool;
    String buddyPoolName;
    boolean autoDataGravitation;
    boolean dataGravitationRemoveOnFind;
    boolean dataGravitationSearchBackupTrees;
    Map buddyGroupsIParticipateIn;
    private final BoundedLinkedQueue queue;
    private AsyncViewChangeHandlerThread asyncViewChangeHandler;
    private static SynchronizedInt threadId = new SynchronizedInt(0);
    public static final String BUDDY_BACKUP_SUBTREE = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_SUBTREE_FQN = Fqn.fromString("_BUDDY_BACKUP_");
    int buddyCommunicationTimeout;
    private static int UNINIT_BUDDIES_RETRIES = 3;
    private static final long UNINIT_BUDDIES_RETRY_NAPTIME = 500L;
    private boolean initialised;
    private final Object poolInfoNotifierLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BuddyManager(Element element) {
        block11: {
            this.buddyPool = new ConcurrentReaderHashMap();
            this.nullBuddyPool = new HashSet();
            this.autoDataGravitation = true;
            this.dataGravitationRemoveOnFind = true;
            this.dataGravitationSearchBackupTrees = true;
            this.buddyGroupsIParticipateIn = new ConcurrentReaderHashMap();
            this.queue = new BoundedLinkedQueue();
            this.asyncViewChangeHandler = new AsyncViewChangeHandlerThread();
            this.buddyCommunicationTimeout = 10000;
            this.initialised = false;
            this.poolInfoNotifierLock = new Object();
            this.enabled = XmlHelper.readBooleanContents(element, "buddyReplicationEnabled");
            this.dataGravitationRemoveOnFind = XmlHelper.readBooleanContents(element, "dataGravitationRemoveOnFind", true);
            this.dataGravitationSearchBackupTrees = XmlHelper.readBooleanContents(element, "dataGravitationSearchBackupTrees", true);
            this.autoDataGravitation = this.enabled && XmlHelper.readBooleanContents(element, "autoDataGravitation", false);
            String strBuddyCommunicationTimeout = XmlHelper.readStringContents(element, "buddyCommunicationTimeout");
            try {
                Object var5_3;
                try {
                    this.buddyCommunicationTimeout = Integer.parseInt(strBuddyCommunicationTimeout);
                }
                catch (Exception e) {
                    var5_3 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using buddy communication timeout of " + this.buddyCommunicationTimeout + " millis"));
                    }
                    break block11;
                }
                var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (!log.isDebugEnabled()) throw throwable;
                log.debug((Object)("Using buddy communication timeout of " + this.buddyCommunicationTimeout + " millis"));
                throw throwable;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using buddy communication timeout of " + this.buddyCommunicationTimeout + " millis"));
            }
        }
        this.buddyPoolName = XmlHelper.readStringContents(element, "buddyPoolName");
        if (this.buddyPoolName != null && this.buddyPoolName.equals("")) {
            this.buddyPoolName = null;
        }
        String buddyLocatorClass = null;
        Properties buddyLocatorProperties = null;
        try {
            buddyLocatorClass = XmlHelper.readStringContents(element, "buddyLocatorClass");
            try {
                buddyLocatorProperties = XmlHelper.readPropertiesContents(element, "buddyLocatorProperties");
            }
            catch (IOException e) {
                log.warn((Object)"Caught exception reading buddyLocatorProperties", (Throwable)e);
                log.error((Object)("Unable to read buddyLocatorProperties specified!  Using defaults for [" + buddyLocatorClass + "]"));
            }
            this.buddyLocator = buddyLocatorClass == null || buddyLocatorClass.equals("") ? this.createDefaultBuddyLocator(buddyLocatorProperties) : this.createBuddyLocator(buddyLocatorClass, buddyLocatorProperties);
            return;
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception instantiating buddy locator", (Throwable)e);
            log.error((Object)("Unable to instantiate specified buddyLocatorClass [" + buddyLocatorClass + "].  Using default buddyLocator [" + NextMemberBuddyLocator.class.getName() + "] instead, with default properties."));
            this.buddyLocator = this.createDefaultBuddyLocator(null);
        }
    }

    protected BuddyLocator createBuddyLocator(String className, Properties props) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        BuddyLocator bl = (BuddyLocator)Class.forName(className).newInstance();
        bl.init(props);
        return bl;
    }

    protected BuddyLocator createDefaultBuddyLocator(Properties props) {
        NextMemberBuddyLocator bl = new NextMemberBuddyLocator();
        bl.init(props);
        return bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getBuddyPoolName() {
        return this.buddyPoolName;
    }

    public static String getGroupNameFromAddress(Object address) {
        String s = address.toString();
        return s.replace(':', '_');
    }

    public void init(TreeCache cache) throws Exception {
        this.cache = cache;
        IpAddress localAddress = (IpAddress)cache.getLocalAddress();
        this.buddyGroup = new BuddyGroup();
        this.buddyGroup.setDataOwner(localAddress);
        this.buddyGroup.setGroupName(BuddyManager.getGroupNameFromAddress(localAddress));
        log.debug((Object)("Starting buddy manager for data owner " + this.buddyGroup.getDataOwner()));
        if (this.buddyPoolName != null) {
            this.buddyPool.put(this.buddyGroup.getDataOwner(), this.buddyPoolName);
        }
        this.broadcastBuddyPoolMembership();
        this.initialised = true;
        cache.addTreeCacheListener(new TreeCacheListener(){
            private Vector oldMembers;

            public void nodeCreated(Fqn fqn) {
            }

            public void nodeRemoved(Fqn fqn) {
            }

            public void nodeLoaded(Fqn fqn) {
            }

            public void nodeEvicted(Fqn fqn) {
            }

            public void nodeModified(Fqn fqn) {
            }

            public void nodeVisited(Fqn fqn) {
            }

            public void cacheStarted(TreeCache cache) {
            }

            public void cacheStopped(TreeCache cache) {
            }

            public void viewChange(View newView) {
                Vector newMembers = newView.getMembers();
                BuddyManager.this.enqueueViewChange(this.oldMembers == null ? null : new Vector(this.oldMembers), new Vector(newMembers));
                if (this.oldMembers == null) {
                    this.oldMembers = new Vector();
                }
                this.oldMembers.clear();
                this.oldMembers.addAll(newMembers);
            }
        });
        this.reassignBuddies(cache.getMembers());
        this.asyncViewChangeHandler.start();
    }

    public boolean isAutoDataGravitation() {
        return this.autoDataGravitation;
    }

    public boolean isDataGravitationRemoveOnFind() {
        return this.dataGravitationRemoveOnFind;
    }

    public boolean isDataGravitationSearchBackupTrees() {
        return this.dataGravitationSearchBackupTrees;
    }

    public int getBuddyCommunicationTimeout() {
        return this.buddyCommunicationTimeout;
    }

    private void enqueueViewChange(List oldMembers, List newMembers) {
        try {
            this.queue.put((Object)new List[]{oldMembers, newMembers});
        }
        catch (InterruptedException e) {
            log.warn((Object)"Caught interrupted exception trying to enqueue a view change event", (Throwable)e);
        }
    }

    private void reassignBuddies(List membership) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Data owner address " + this.cache.getLocalAddress()));
            log.debug((Object)("Entering updateGroup.  Current group: " + this.buddyGroup + ".  Current View membership: " + membership));
        }
        List newBuddies = this.buddyLocator.locateBuddies(this.buddyPool, membership, this.buddyGroup.getDataOwner());
        ArrayList uninitialisedBuddies = new ArrayList();
        Iterator newBuddiesIt = newBuddies.iterator();
        while (newBuddiesIt.hasNext()) {
            Object newBuddy = newBuddiesIt.next();
            if (this.buddyGroup.buddies.contains(newBuddy)) continue;
            uninitialisedBuddies.add(newBuddy);
        }
        ArrayList obsoleteBuddies = new ArrayList();
        Iterator originalBuddies = this.buddyGroup.buddies.iterator();
        while (originalBuddies.hasNext()) {
            Object origBuddy = originalBuddies.next();
            if (newBuddies.contains(origBuddy)) continue;
            obsoleteBuddies.add(origBuddy);
        }
        if (!obsoleteBuddies.isEmpty()) {
            this.removeFromGroup(obsoleteBuddies);
        } else {
            log.trace((Object)"No obsolete buddies found, nothing to announce.");
        }
        if (!uninitialisedBuddies.isEmpty()) {
            this.addBuddies(uninitialisedBuddies);
        } else {
            log.trace((Object)"No uninitialized buddies found, nothing to announce.");
        }
        log.info((Object)("New buddy group: " + this.buddyGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePoolNameBroadcast(IpAddress address, String poolName) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)("BuddyManager@" + Integer.toHexString(this.hashCode()) + ": received announcement that cache instance " + address + " is in buddy pool " + poolName));
        }
        if (poolName != null) {
            this.buddyPool.put(address, poolName);
        } else {
            object = this.nullBuddyPool;
            synchronized (object) {
                if (!this.nullBuddyPool.contains(address)) {
                    this.nullBuddyPool.add(address);
                }
            }
        }
        object = this.poolInfoNotifierLock;
        synchronized (object) {
            log.trace((Object)"Notifying any waiting view change threads that we have received buddy pool info.");
            this.poolInfoNotifierLock.notifyAll();
        }
    }

    public void handleRemoveFromBuddyGroup(String groupName) throws BuddyNotInitException {
        if (!this.initialised) {
            throw new BuddyNotInitException("Not yet initialised");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing self from buddy group " + groupName));
        }
        this.buddyGroupsIParticipateIn.remove(groupName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing backup data for group " + groupName));
        }
        try {
            this.cache.remove(new Fqn(BUDDY_BACKUP_SUBTREE_FQN, groupName));
        }
        catch (CacheException e) {
            log.error((Object)("Unable to remove backup data for group " + groupName), (Throwable)e);
        }
    }

    public void handleAssignToBuddyGroup(BuddyGroup newGroup, Map state) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handling assign to buddy grp.  Sender: " + newGroup.getGroupName() + "; My instance: " + this.buddyGroup.getDataOwner()));
        }
        if (!this.initialised) {
            throw new BuddyNotInitException("Not yet initialised");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Assigning self to buddy group " + newGroup));
        }
        this.buddyGroupsIParticipateIn.put(newGroup.getGroupName(), newGroup);
        Fqn integrationBase = new Fqn(BUDDY_BACKUP_SUBTREE_FQN, newGroup.getGroupName());
        VersionAwareMarshaller marshaller = null;
        if (this.cache.getUseRegionBasedMarshalling()) {
            marshaller = this.cache.getMarshaller();
        }
        Iterator it = state.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Fqn fqn = (Fqn)entry.getKey();
            String fqnS = fqn.toString();
            if (marshaller != null && marshaller.isInactive(fqn.toString())) continue;
            ClassLoader cl = marshaller == null ? null : marshaller.getClassLoader(fqnS);
            Fqn integrationRoot = new Fqn(integrationBase, fqn);
            this.cache._setState((byte[])entry.getValue(), integrationRoot, cl);
        }
    }

    public static Fqn getBackupFqn(Object dataOwnerAddress, Fqn origFqn) {
        return BuddyManager.getBackupFqn(BuddyManager.getGroupNameFromAddress(dataOwnerAddress), origFqn);
    }

    public static Fqn getBackupFqn(String buddyGroupName, Fqn origFqn) {
        if (BuddyManager.isBackupFqn(origFqn)) {
            throw new RuntimeException("Cannot make a backup Fqn from a backup Fqn! Attempting to create a backup of " + origFqn);
        }
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add(buddyGroupName);
        elements.addAll(origFqn.peekElements());
        return new Fqn(elements);
    }

    public static Fqn getBackupFqn(Fqn buddyGroupRoot, Fqn origFqn) {
        if (origFqn.isChildOf(buddyGroupRoot)) {
            return origFqn;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add(buddyGroupRoot.get(1));
        elements.addAll(origFqn.peekElements());
        return new Fqn(elements);
    }

    public static boolean isBackupFqn(Fqn name) {
        return name != null && name.hasElement(BUDDY_BACKUP_SUBTREE);
    }

    public List getBuddyAddresses() {
        return this.buddyGroup.buddies;
    }

    public JBCMethodCall transformFqns(JBCMethodCall call) {
        return this.transformFqns(call, call.getMethodId() != 34);
    }

    public JBCMethodCall transformFqns(JBCMethodCall call, boolean transformForCurrentCall) {
        if (call != null && call.getArgs() != null) {
            JBCMethodCall call2 = new JBCMethodCall(call.getMethod(), (Object[])call.getArgs().clone(), call.getMethodId());
            this.handleArgs(call2.getArgs(), transformForCurrentCall);
            return call2;
        }
        return call;
    }

    private void removeFromGroup(List buddies) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing obsolete buddies from buddy group [" + this.buddyGroup.getGroupName() + "].  Obsolete buddies are " + buddies));
        }
        this.buddyGroup.buddies.removeAll(buddies);
        JBCMethodCall membershipCall = MethodCallFactory.create(MethodDeclarations.remoteRemoveFromBuddyGroupMethod, new Object[]{this.buddyGroup.getGroupName()});
        JBCMethodCall replicateCall = MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{membershipCall});
        int attemptsLeft = UNINIT_BUDDIES_RETRIES;
        while (attemptsLeft-- > 0) {
            try {
                this.makeRemoteCall(buddies, replicateCall, true);
                break;
            }
            catch (Exception e) {
                if (e instanceof BuddyNotInitException || e.getCause() instanceof BuddyNotInitException) {
                    if (attemptsLeft > 0) {
                        log.info((Object)"One of the buddies have not been initialised.  Will retry after a short nap.");
                        Thread.sleep(500L);
                        continue;
                    }
                    throw new BuddyNotInitException("Unable to contact buddy after " + UNINIT_BUDDIES_RETRIES + " retries");
                }
                log.error((Object)"Unable to communicate with Buddy for some reason", (Throwable)e);
            }
        }
        log.trace((Object)"removeFromGroup notification complete");
    }

    private void addBuddies(List buddies) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Assigning new buddies to buddy group [" + this.buddyGroup.getGroupName() + "].  New buddies are " + buddies));
        }
        this.buddyGroup.buddies.addAll(buddies);
        HashMap<Fqn, byte[]> stateMap = new HashMap<Fqn, byte[]>();
        byte[] state = null;
        if (this.cache.getUseRegionBasedMarshalling()) {
            RegionManager rm = this.cache.getRegionManager();
            Region[] regions = rm.getRegions();
            if (regions.length > 0) {
                for (int i = 0; i < regions.length; ++i) {
                    Fqn f = Fqn.fromString(regions[i].getFqn());
                    state = this.acquireState(f);
                    if (state == null) continue;
                    stateMap.put(f, state);
                }
            } else if (!this.cache.isInactiveOnStartup() && (state = this.acquireState(Fqn.ROOT)) != null) {
                stateMap.put(Fqn.ROOT, state);
            }
        } else {
            state = this.acquireState(Fqn.ROOT);
            if (state != null) {
                stateMap.put(Fqn.ROOT, state);
            }
        }
        JBCMethodCall membershipCall = MethodCallFactory.create(MethodDeclarations.remoteAssignToBuddyGroupMethod, new Object[]{this.buddyGroup, stateMap});
        JBCMethodCall replicateCall = MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{membershipCall});
        int attemptsLeft = UNINIT_BUDDIES_RETRIES;
        while (attemptsLeft-- > 0) {
            try {
                this.makeRemoteCall(buddies, replicateCall, true);
                break;
            }
            catch (Exception e) {
                if (e instanceof BuddyNotInitException || e.getCause() instanceof BuddyNotInitException) {
                    if (attemptsLeft > 0) {
                        log.info((Object)"One of the buddies have not been initialised.  Will retry after a short nap.");
                        Thread.sleep(500L);
                        continue;
                    }
                    throw new BuddyNotInitException("Unable to contact buddy after " + UNINIT_BUDDIES_RETRIES + " retries");
                }
                log.error((Object)"Unable to communicate with Buddy for some reason", (Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("addToGroup notification complete (data owner " + this.buddyGroup.getDataOwner() + ")"));
        }
    }

    private byte[] acquireState(Fqn fqn) throws Exception {
        long[] timeouts = new long[]{400L, 800L, 1600L};
        TimeoutException timeoutException = null;
        boolean trace = log.isTraceEnabled();
        for (int i = 0; i < timeouts.length; ++i) {
            timeoutException = null;
            boolean force = i == timeouts.length - 1;
            try {
                byte[] state = this.cache._getState(fqn, this.cache.getFetchInMemoryState(), this.cache.getFetchPersistentState(), timeouts[i], force, false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"acquireState(): got state");
                }
                return state;
            }
            catch (TimeoutException t) {
                timeoutException = t;
                if (!trace) continue;
                log.trace((Object)"acquireState(): got a TimeoutException");
                continue;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (timeoutException != null) {
            throw new CacheException("acquireState(): Failed getting state due to timeout", timeoutException);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"acquireState(): Unable to give state");
        }
        return null;
    }

    private void broadcastBuddyPoolMembership() {
        this.broadcastBuddyPoolMembership(null);
    }

    private void broadcastBuddyPoolMembership(List recipients) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instance " + this.buddyGroup.getDataOwner() + " broadcasting membership in buddy pool " + this.buddyPoolName + " to recipients " + recipients));
        }
        JBCMethodCall membershipCall = MethodCallFactory.create(MethodDeclarations.remoteAnnounceBuddyPoolNameMethod, new Object[]{this.buddyGroup.getDataOwner(), this.buddyPoolName});
        JBCMethodCall replicateCall = MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{membershipCall});
        try {
            this.makeRemoteCall(recipients, replicateCall, true);
        }
        catch (Exception e) {
            log.error((Object)"Problems broadcasting buddy pool membership info to cluster", (Throwable)e);
        }
    }

    private void makeRemoteCall(List recipients, MethodCall call, boolean sync) throws Exception {
        if (recipients != null) {
            Iterator recipientsIt = recipients.iterator();
            Vector members = this.cache.getMembers();
            while (recipientsIt.hasNext()) {
                if (members.contains(recipientsIt.next())) continue;
                recipientsIt.remove();
            }
        }
        this.cache.callRemoteMethods(recipients, call, sync, true, (long)this.buddyCommunicationTimeout);
    }

    private void handleArgs(Object[] args, boolean transformForCurrentCall) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof JBCMethodCall) {
                JBCMethodCall call = (JBCMethodCall)((Object)args[i]);
                boolean transformFqns = true;
                if (call.getMethodId() == 34) {
                    transformFqns = false;
                }
                args[i] = this.transformFqns((JBCMethodCall)((Object)args[i]), transformFqns);
            }
            if (args[i] instanceof List && args[i] != null) {
                Object[] asArray = ((List)args[i]).toArray();
                this.handleArgs(asArray, transformForCurrentCall);
                ArrayList<Object> newList = new ArrayList<Object>(asArray.length);
                newList.addAll(Arrays.asList(asArray));
                args[i] = newList;
            }
            if (!(args[i] instanceof Fqn)) continue;
            Fqn fqn = (Fqn)args[i];
            if (!transformForCurrentCall) continue;
            args[i] = this.getBackupFqn(fqn);
        }
    }

    public Fqn getBackupFqn(Fqn originalFqn) {
        return BuddyManager.getBackupFqn(this.buddyGroup == null || this.buddyGroup.getGroupName() == null ? "null" : this.buddyGroup.getGroupName(), originalFqn);
    }

    private void waitForInit() {
        while (!this.initialised) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static Fqn getActualFqn(Fqn fqn) {
        if (!BuddyManager.isBackupFqn(fqn)) {
            return fqn;
        }
        ArrayList elements = new ArrayList(fqn.peekElements());
        elements.remove(0);
        elements.remove(0);
        return new Fqn(elements);
    }

    private class AsyncViewChangeHandlerThread
    implements Runnable {
        private Thread t;

        private AsyncViewChangeHandlerThread() {
        }

        public void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "AsyncViewChangeHandlerThread-" + threadId.increment());
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void run() {
            BuddyManager.this.waitForInit();
            while (!Thread.interrupted()) {
                try {
                    this.handleEnqueuedViewChange();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Throwable t) {
                    log.error((Object)"Caught exception handling view change", t);
                }
            }
            log.trace((Object)"Exiting run()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEnqueuedViewChange() throws Exception {
            log.trace((Object)"Waiting for enqueued view change events");
            List[] members = (List[])BuddyManager.this.queue.take();
            this.broadcastPoolMembership(members);
            boolean rebroadcast = false;
            while (!this.buddyPoolInfoAvailable(members[1])) {
                rebroadcast = true;
                Object object = BuddyManager.this.poolInfoNotifierLock;
                synchronized (object) {
                    log.trace((Object)"Not received necessary buddy pool info for all new members yet; waiting on poolInfoNotifierLock.");
                    BuddyManager.this.poolInfoNotifierLock.wait();
                }
            }
            if (rebroadcast) {
                this.broadcastPoolMembership(members);
            }
            BuddyManager.this.reassignBuddies(members[1]);
        }

        private void broadcastPoolMembership(List[] members) {
            log.trace((Object)"Broadcasting pool membership details, triggered by view change.");
            if (members[0] == null) {
                BuddyManager.this.broadcastBuddyPoolMembership();
            } else {
                ArrayList delta = new ArrayList();
                delta.addAll(members[1]);
                delta.removeAll(members[0]);
                BuddyManager.this.broadcastBuddyPoolMembership(delta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean buddyPoolInfoAvailable(List newMembers) {
            boolean infoReceived = true;
            Iterator i = newMembers.iterator();
            while (i.hasNext()) {
                Object address = i.next();
                Set set = BuddyManager.this.nullBuddyPool;
                synchronized (set) {
                    infoReceived = infoReceived && (address.equals(BuddyManager.this.cache.getLocalAddress()) || BuddyManager.this.buddyPool.keySet().contains(address) || BuddyManager.this.nullBuddyPool.contains(address));
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(BuddyManager.this.buddyGroup.getDataOwner() + " received buddy pool info for new members " + newMembers + "?  " + infoReceived));
            }
            return infoReceived;
        }
    }
}

