/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.blocks.MethodCall;

public class PessimisticLockInterceptor
extends Interceptor {
    TransactionTable tx_table = null;
    boolean writeLockOnChildInsertRemove = true;
    Map lock_table;
    private long lock_acquisition_timeout;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.tx_table = cache.getTransactionTable();
        this.lock_table = cache.getLockTable();
        this.lock_acquisition_timeout = cache.getLockAcquisitionTimeout();
        this.writeLockOnChildInsertRemove = cache.getLockParentForChildInsertRemove();
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        Fqn fqn = null;
        int lock_type = 0;
        long lock_timeout = this.lock_acquisition_timeout;
        Object[] args = m.getArgs();
        InvocationContext ctx = this.getInvocationContext();
        boolean storeLockedNode = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("PessimisticLockInterceptor invoked for method " + (Object)((Object)m)));
        }
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking()) {
            this.log.trace((Object)"Suppressing locking");
            switch (m.getMethodId()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.log.trace((Object)"Creating nodes if necessary");
                    this.createNodes((Fqn)args[1], ctx.getGlobalTransaction());
                }
            }
            return super.invoke(m);
        }
        boolean recursive = false;
        boolean createIfNotExists = false;
        boolean zeroLockTimeout = false;
        boolean isRemoveData = false;
        switch (m.getMethodId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                createIfNotExists = true;
                fqn = (Fqn)args[1];
                lock_type = 2;
                if (m.getMethodId() != 4) break;
                lock_timeout = (Long)args[5];
                break;
            }
            case 5: {
                fqn = (Fqn)args[1];
                lock_type = 2;
                recursive = true;
                createIfNotExists = true;
                storeLockedNode = true;
                break;
            }
            case 6: 
            case 7: {
                isRemoveData = true;
            }
            case 15: {
                fqn = (Fqn)args[1];
                lock_type = 2;
                break;
            }
            case 8: {
                zeroLockTimeout = true;
                fqn = (Fqn)args[0];
                lock_type = 2;
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                fqn = (Fqn)args[0];
                lock_type = 1;
                break;
            }
            case 33: {
                fqn = (Fqn)args[0];
                lock_type = (Integer)args[1];
                recursive = (Boolean)args[2];
                break;
            }
            case 11: {
                this.commit(ctx.getGlobalTransaction());
                break;
            }
            case 12: {
                this.rollback(ctx.getGlobalTransaction());
                break;
            }
            default: {
                if (!this.isOnePhaseCommitPrepareMehod(m)) break;
                this.commit(ctx.getGlobalTransaction());
            }
        }
        if (fqn != null) {
            if (createIfNotExists) {
                do {
                    this.lock(fqn, ctx.getGlobalTransaction(), lock_type, recursive, zeroLockTimeout ? 0L : lock_timeout, createIfNotExists, storeLockedNode, isRemoveData);
                } while (!this.cache.exists(fqn));
            } else {
                this.lock(fqn, ctx.getGlobalTransaction(), lock_type, recursive, zeroLockTimeout ? 0L : lock_timeout, createIfNotExists, storeLockedNode, isRemoveData);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("bypassed locking as method " + m.getName() + "() doesn't require locking"));
        }
        if (m.getMethodId() == 33) {
            return null;
        }
        Object o = super.invoke(m);
        if (storeLockedNode && ctx.getGlobalTransaction() == null) {
            this.cache.realRemove(fqn, true);
        } else if (m.getMethodId() == 11 || this.isOnePhaseCommitPrepareMehod(m) || m.getMethodId() == 12) {
            this.cleanup(ctx.getGlobalTransaction());
        }
        return o;
    }

    private void cleanup(GlobalTransaction gtx) {
        TransactionEntry entry = this.tx_table.get(gtx);
        entry.releaseAllLocksLIFO(gtx);
        Transaction ltx = entry.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removing local transaction " + ltx + " and global transaction " + gtx));
        }
        this.tx_table.remove(ltx);
        this.tx_table.remove(gtx);
    }

    private void lock(Fqn fqn, GlobalTransaction gtx, int lock_type, boolean recursive, long lock_timeout, boolean createIfNotExists, boolean isRemoveNodeOperation, boolean isRemoveDataOperation) throws TimeoutException, LockingException, InterruptedException {
        Object owner;
        Thread currentThread = Thread.currentThread();
        Object object = owner = gtx != null ? gtx : currentThread;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Attempting to lock node " + fqn + " for owner " + owner));
        }
        if (fqn == null) {
            this.log.error((Object)"fqn is null - this should not be the case");
            return;
        }
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        if (this.cache.getIsolationLevelClass() == IsolationLevel.NONE) {
            lock_type = 0;
        }
        DataNode n = this.cache.getRoot();
        for (int i = -1; i < treeNodeSize; ++i) {
            Set acquired_locks;
            DataNode child_node;
            Object child_name;
            if (i == -1) {
                child_name = Fqn.ROOT.getName();
                child_node = this.cache.getRoot();
            } else {
                child_name = fqn.get(i);
                child_node = (DataNode)n.getOrCreateChild(child_name, gtx, createIfNotExists);
            }
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            if (lock_type == 0) {
                n = child_node;
                continue;
            }
            int currentLockType = this.writeLockNeeded(lock_type, i, treeNodeSize, isRemoveNodeOperation, createIfNotExists, isRemoveDataOperation, fqn, child_node.getFqn()) ? 2 : 1;
            if (gtx != null && this.needToReverseRemove(child_node, this.tx_table.get(gtx), lock_type, isRemoveNodeOperation, createIfNotExists)) {
                this.reverseRemove(child_node);
            }
            this.acquireNodeLock(child_node, owner, gtx, currentLockType, lock_timeout);
            DataNode repeek = this.cache.peek(child_node.getFqn());
            if (repeek != null && child_node != repeek) {
                this.log.trace((Object)"Was waiting for and obtained a lock on a node that doesn't exist anymore!  Attempting lock acquisition again.");
                child_node.getLock().release(owner);
                --i;
                continue;
            }
            if (recursive && this.isTargetNode(i, treeNodeSize) && (acquired_locks = child_node.acquireAll(owner, lock_timeout, lock_type)).size() > 0) {
                if (gtx != null) {
                    this.cache.getTransactionTable().addLocks(gtx, acquired_locks);
                } else {
                    List locks = this.getLocks(Thread.currentThread());
                    locks.addAll(acquired_locks);
                }
            }
            n = child_node;
        }
        if (isRemoveNodeOperation && gtx != null) {
            this.cache.getTransactionTable().get(gtx).addRemovedNode(fqn);
        }
    }

    private boolean needToReverseRemove(DataNode n, TransactionEntry te, int lockTypeRequested, boolean isRemoveOperation, boolean createIfNotExists) {
        return !isRemoveOperation && createIfNotExists && lockTypeRequested == 2 && n.isMarkedForRemoval() && this.hasBeenRemovedInCurrentTx(te, n.getFqn());
    }

    private boolean hasBeenRemovedInCurrentTx(TransactionEntry te, Fqn f) {
        if (te.getRemovedNodes().contains(f)) {
            return true;
        }
        Iterator i = te.getRemovedNodes().iterator();
        while (i.hasNext()) {
            Fqn removed = (Fqn)i.next();
            if (!f.isChildOf(removed)) continue;
            return true;
        }
        return false;
    }

    private void reverseRemove(DataNode n) {
        n.unmarkForRemoval(false);
    }

    private boolean writeLockNeeded(int lock_type, int currentNodeIndex, int treeNodeSize, boolean isRemoveOperation, boolean isPutOperation, boolean isRemoveDataOperation, Fqn targetFqn, Fqn currentFqn) {
        if (this.writeLockOnChildInsertRemove) {
            if (isRemoveOperation && currentNodeIndex == treeNodeSize - 2) {
                return true;
            }
            if (!this.isTargetNode(currentNodeIndex, treeNodeSize) && !this.cache.exists(new Fqn(currentFqn, targetFqn.get(currentNodeIndex + 1)))) {
                return isPutOperation;
            }
        }
        return lock_type == 2 && this.isTargetNode(currentNodeIndex, treeNodeSize) && (isPutOperation || isRemoveOperation || isRemoveDataOperation);
    }

    private boolean isTargetNode(int nodePosition, int treeNodeSize) {
        return nodePosition == treeNodeSize - 1;
    }

    private void acquireNodeLock(DataNode node, Object owner, GlobalTransaction gtx, int lock_type, long lock_timeout) throws LockingException, TimeoutException, InterruptedException {
        boolean acquired = node.acquire(owner, lock_timeout, lock_type);
        if (acquired) {
            this.recordNodeLock(gtx, node.getLock());
        }
    }

    private void recordNodeLock(GlobalTransaction gtx, IdentityLock lock) {
        if (gtx != null) {
            this.cache.getTransactionTable().addLock(gtx, lock);
        } else {
            List locks = this.getLocks(Thread.currentThread());
            if (!locks.contains(lock)) {
                locks.add(lock);
            }
        }
    }

    private List getLocks(Thread currentThread) {
        List locks = (List)this.lock_table.get(currentThread);
        if (locks == null) {
            locks = Collections.synchronizedList(new LinkedList());
            this.lock_table.put(currentThread, locks);
        }
        return locks;
    }

    private void createNodes(Fqn fqn, GlobalTransaction gtx) {
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        DataNode n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Object child_name = fqn.get(i);
            DataNode child_node = (DataNode)n.getOrCreateChild(child_name, gtx, true);
            if (gtx != null && this.needToReverseRemove(child_node, this.tx_table.get(gtx), 2, false, true)) {
                this.reverseRemove(child_node);
            }
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            n = child_node;
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("committing cache with gtx " + gtx));
        }
        if ((entry = this.tx_table.get(gtx)) == null) {
            this.log.error((Object)("entry for transaction " + gtx + " not found (maybe already committed)"));
            return;
        }
        Iterator removedNodes = entry.getRemovedNodes().iterator();
        while (removedNodes.hasNext()) {
            Fqn f = (Fqn)removedNodes.next();
            this.cache.realRemove(f, false);
        }
    }

    private void rollback(GlobalTransaction tx) {
        TransactionEntry entry = this.tx_table.get(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("called to rollback cache with GlobalTransaction=" + tx));
        }
        if (entry == null) {
            this.log.error((Object)("entry for transaction " + tx + " not found (transaction has possibly already been rolled back)"));
            return;
        }
        Iterator removedNodes = entry.getRemovedNodes().iterator();
        while (removedNodes.hasNext()) {
            Fqn f = (Fqn)removedNodes.next();
            this.cache.realRemove(f, false);
        }
        entry.undoOperations(this.cache);
    }
}

