/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MarshallingException;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionManager;
import org.jboss.cache.marshall.RegionNameConflictException;
import org.jboss.cache.marshall.RegionNotFoundException;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jgroups.blocks.RpcDispatcher;

public class TreeCacheMarshaller
implements RpcDispatcher.Marshaller {
    protected RegionManager manager_;
    protected boolean defaultInactive_;
    private ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    private Log log_ = LogFactory.getLog((Class)TreeCacheMarshaller.class);

    public TreeCacheMarshaller() {
    }

    public TreeCacheMarshaller(RegionManager manager, boolean defaultInactive) {
        if (manager == null) {
            throw new IllegalArgumentException("manager cannot be null");
        }
        this.manager_ = manager;
        this.defaultInactive_ = defaultInactive;
    }

    public RegionManager getManager() {
        return this.manager_;
    }

    public void setManager(RegionManager manager) {
        this.manager_ = manager;
    }

    public boolean isDefaultInactive() {
        return this.defaultInactive_;
    }

    public void setDefaultInactive(boolean defaultInactive) {
        this.defaultInactive_ = defaultInactive;
    }

    public void registerClassLoader(String fqn, ClassLoader cl) throws RegionNameConflictException {
        Region existing = this.manager_.getRegion(fqn);
        if (existing == null) {
            this.manager_.createRegion(fqn, cl, this.defaultInactive_);
        } else {
            existing.setClassLoader(cl);
        }
    }

    public void unregisterClassLoader(String fqn) throws RegionNotFoundException {
        Region region = this.manager_.getRegion(fqn);
        if (region != null) {
            region.setClassLoader(null);
        }
    }

    public ClassLoader getClassLoader(String fqn) throws RegionNotFoundException {
        ClassLoader result = null;
        Region region = this.manager_.getRegion(fqn);
        if (region != null) {
            result = region.getClassLoader();
        }
        return result;
    }

    public void activate(String fqn) throws RegionNameConflictException {
        if (this.manager_.hasRegion(fqn)) {
            Region region = this.manager_.getRegion(fqn);
            if (!this.defaultInactive_ && region.getClassLoader() == null) {
                this.manager_.removeRegion(fqn);
            } else {
                region.activate();
            }
        } else if (this.defaultInactive_) {
            this.manager_.createRegion(fqn, null, false);
        } else {
            this.manager_.checkConflict(fqn);
        }
    }

    public void inactivate(String fqn) throws RegionNameConflictException {
        if (this.manager_.hasRegion(fqn)) {
            Region region = this.manager_.getRegion(fqn);
            if (this.defaultInactive_ && region.getClassLoader() == null) {
                this.manager_.removeRegion(fqn);
            } else {
                region.inactivate();
            }
        } else if (!this.defaultInactive_) {
            this.manager_.createRegion(fqn, null, true);
        } else {
            this.manager_.checkConflict(fqn);
        }
    }

    public boolean isInactive(String fqn) {
        boolean result = this.defaultInactive_;
        Region region = this.manager_.getRegion(fqn);
        if (region != null) {
            result = region.isInactive();
        }
        return result;
    }

    public byte[] objectToByteBuffer(Object o) throws Exception {
        String string;
        String fqn;
        JBCMethodCall call = (JBCMethodCall)((Object)o);
        switch (call.getMethodId()) {
            case 13: {
                fqn = this.extractFqnFromMethodCall(call);
                break;
            }
            case 14: {
                fqn = this.extractFqnFromListOfMethodCall(call);
                break;
            }
            default: {
                throw new IllegalStateException("TreeCacheMarshaller.objectToByteBuffer(): MethodCall name is either not  replicate or replicateAll but : " + call.getName());
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MarshalledValueOutputStream oos = new MarshalledValueOutputStream((OutputStream)bos);
        if (fqn == null) {
            string = "NULL";
        }
        oos.writeUTF(string);
        oos.writeObject(o);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)"send");
            this.log_.trace((Object)this.getColumnDump(bos.toByteArray()));
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object objectFromByteBuffer(byte[] bytes) throws Exception {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)"recv");
            this.log_.trace((Object)this.getColumnDump(bytes));
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        MarshalledValueInputStream ois = new MarshalledValueInputStream((InputStream)is);
        String fqn = ois.readUTF();
        ClassLoader oldTcl = null;
        Region region = null;
        if (fqn != null && !fqn.equals("NULL")) {
            region = this.getRegion(fqn);
            if (region != null) {
                if (region.getStatus() == 1) {
                    if (this.log_.isTraceEnabled()) {
                        this.log_.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " is in the inactive default region"));
                    }
                    return MethodCallFactory.create(MethodDeclarations.notifyCallOnInactiveMethod, new Object[]{fqn});
                }
                ClassLoader cl = region.getClassLoader();
                if (cl != null) {
                    oldTcl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    if (this.log_.isTraceEnabled()) {
                        this.log_.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " Will use customed class loader " + cl));
                    }
                }
            } else if (this.defaultInactive_) {
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("objectFromByteBuffer(): fqn: " + fqn + " is in an inactive region"));
                }
                return MethodCallFactory.create(MethodDeclarations.notifyCallOnInactiveMethod, new Object[]{fqn});
            }
        }
        Object obj = null;
        try {
            obj = ois.readObject();
            Object var9_8 = null;
            if (oldTcl != null) {
                Thread.currentThread().setContextClassLoader(oldTcl);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (oldTcl != null) {
                Thread.currentThread().setContextClassLoader(oldTcl);
            }
            throw throwable;
        }
        if (obj == null) {
            throw new MarshallingException("Read null object with fqn: " + fqn);
        }
        if (region != null && region.isQueueing()) {
            obj = MethodCallFactory.create(MethodDeclarations.enqueueMethodCallMethod, new Object[]{region.getFqn(), obj});
        }
        return obj;
    }

    protected String extractFqnFromMethodCall(JBCMethodCall call) {
        JBCMethodCall c0 = (JBCMethodCall)((Object)call.getArgs()[0]);
        return this.extractFqn(c0);
    }

    protected String extractFqnFromListOfMethodCall(JBCMethodCall call) {
        Object[] args = call.getArgs();
        JBCMethodCall c0 = (JBCMethodCall)((Object)((List)args[0]).get(0));
        return this.extractFqn(c0);
    }

    protected String extractFqn(JBCMethodCall method_call) {
        if (method_call == null) {
            throw new NullPointerException("method call is null");
        }
        Method meth = method_call.getMethod();
        String fqnStr = null;
        Object[] args = method_call.getArgs();
        switch (method_call.getMethodId()) {
            case 10: 
            case 18: {
                List modifications = (List)args[1];
                fqnStr = this.extractFqn((JBCMethodCall)((Object)modifications.get(0)));
                boolean one_phase_commit = (Boolean)args[args.length - 1];
                if (one_phase_commit) break;
                this.transactions.put(args[0], (Object)fqnStr);
                break;
            }
            case 11: 
            case 12: {
                fqnStr = (String)this.transactions.remove(args[0]);
                break;
            }
            case 19: 
            case 35: {
                Fqn fqn = (Fqn)args[0];
                fqnStr = fqn.toString();
                break;
            }
            case 34: {
                Fqn fqn1 = (Fqn)args[1];
                fqnStr = fqn1.toString();
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            default: {
                if (MethodDeclarations.isCrudMethod(meth)) {
                    Fqn fqn2 = (Fqn)args[1];
                    fqnStr = fqn2.toString();
                    break;
                }
                throw new IllegalArgumentException("TreeCacheMarshaller.extractFqn(): Unknown method call name: " + meth.getName());
            }
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("extract(): received " + (Object)((Object)method_call) + "extracted fqn: " + fqnStr));
        }
        return fqnStr;
    }

    protected Region getRegion(String fqnString) {
        Fqn fqn = Fqn.fromString(fqnString);
        if (BuddyManager.isBackupFqn(fqn)) {
            fqn = fqn.getFqnChild(2, fqn.size());
        }
        return this.manager_.getRegion(fqn);
    }

    String getColumnDump(byte[] buffer) {
        int col = 16;
        int length = buffer.length;
        int offs = 0;
        StringBuffer sb = new StringBuffer(length * 4);
        StringBuffer tx = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            byte b;
            if (i % col == 0) {
                sb.append(tx).append('\n');
                tx.setLength(0);
            }
            if (Character.isISOControl((char)(b = buffer[i + offs]))) {
                tx.append('.');
            } else {
                tx.append((char)b);
            }
            TreeCacheMarshaller.appendHex(sb, b);
            sb.append(' ');
        }
        int remain = col - length % col;
        if (remain != col) {
            for (int i = 0; i < remain * 3; ++i) {
                sb.append(' ');
            }
        }
        sb.append(tx);
        return sb.toString();
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(Character.forDigit(b >> 4 & 0xF, 16));
        sb.append(Character.forDigit(b & 0xF, 16));
    }
}

