/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.DelegatingCacheLoader;

public class TcpDelegatingCacheLoader
extends DelegatingCacheLoader {
    private Socket sock;
    private String host;
    private int port;
    ObjectInputStream in;
    ObjectOutputStream out;

    public TcpDelegatingCacheLoader() {
    }

    public TcpDelegatingCacheLoader(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setConfig(Properties props) {
        this.host = props.getProperty("host");
        if (this.host == null || this.host.length() == 0) {
            this.host = "localhost";
        }
        this.port = Integer.parseInt(props.getProperty("port"));
    }

    public void start() throws Exception {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void init() throws IOException {
        if (this.host == null) {
            this.host = "localhost";
        }
        this.sock = new Socket(this.host, this.port);
        this.out = new ObjectOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        this.out.flush();
        this.in = new ObjectInputStream(new BufferedInputStream(this.sock.getInputStream()));
    }

    public void setCache(TreeCache cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set delegateGetChildrenNames(Fqn fqn) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(1);
            this.out.writeObject(fqn);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return (Set)retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map delegateGet(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(3);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return (Map)retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delegateExists(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(4);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return (Boolean)retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(5);
            this.out.writeObject(name);
            this.out.writeObject(key);
            this.out.writeObject(value);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(6);
            this.out.writeObject(name);
            this.out.writeObject(attributes);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delegatePut(List modifications) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(12);
            int length = modifications != null ? modifications.size() : 0;
            this.out.writeInt(length);
            if (length > 0) {
                Iterator it = modifications.iterator();
                while (it.hasNext()) {
                    Modification m = (Modification)it.next();
                    m.writeExternal(this.out);
                }
            }
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(7);
            this.out.writeObject(name);
            this.out.writeObject(key);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delegateRemove(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(8);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delegateRemoveData(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeInt(9);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    public byte[] delegateLoadEntireState() throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    public void delegateStoreEntireState(byte[] state) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }
}

