/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockMap;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.OwnerNotExistedException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;

public class IdentityLock {
    private static final Log log = LogFactory.getLog((Class)IdentityLock.class);
    private static boolean trace = log.isTraceEnabled();
    private final LockStrategy lock_;
    private final LockMap map_;
    private final boolean mustReacquireRead_;
    private Fqn fqn_;

    public IdentityLock(TreeCache cache, Fqn fqn) {
        this(cache);
        this.fqn_ = fqn;
    }

    public IdentityLock(TreeCache cache) {
        if (cache == null) {
            if (trace) {
                log.trace((Object)"Cache instance is null. Use default lock strategy");
            }
            this.lock_ = LockStrategyFactory.getLockStrategy();
            this.mustReacquireRead_ = false;
        } else {
            IsolationLevel level = cache.getIsolationLevelClass();
            this.lock_ = LockStrategyFactory.getLockStrategy(level == null ? IsolationLevel.REPEATABLE_READ : level);
            this.mustReacquireRead_ = level == IsolationLevel.READ_COMMITTED;
        }
        this.map_ = new LockMap();
    }

    public IdentityLock(IsolationLevel level) {
        this.lock_ = LockStrategyFactory.getLockStrategy(level);
        this.mustReacquireRead_ = level == IsolationLevel.READ_COMMITTED;
        this.map_ = new LockMap();
        this.fqn_ = Fqn.ROOT;
    }

    public Fqn getFqn() {
        return this.fqn_;
    }

    public Set getReaderOwners() {
        return this.map_.readerOwners();
    }

    public Object getWriterOwner() {
        return this.map_.writerOwner();
    }

    public boolean acquireWriteLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (caller == null) {
            throw new IllegalArgumentException("acquireWriteLock(): null caller");
        }
        if (this.map_.isOwner(caller, 2)) {
            if (trace) {
                log.trace((Object)("acquireWriteLock(): caller already owns lock for " + this.getFqn() + " (caller=" + caller + ')'));
            }
            return false;
        }
        if (this.map_.isOwner(caller, 1)) {
            Sync wLock;
            try {
                if (trace) {
                    log.trace((Object)("upgrading RL to WL for " + caller + ", timeout=" + timeout + ", locks: " + this.map_.printInfo()));
                }
                wLock = this.lock_.upgradeLockAttempt(timeout);
            }
            catch (UpgradeException ue) {
                String errStr = "acquireWriteLock(): lock upgrade failed for " + this.getFqn() + " (caller=" + caller + ", lock info: " + this.toString(true) + ')';
                log.trace((Object)errStr, (Throwable)ue);
                throw new UpgradeException(errStr, ue);
            }
            if (wLock == null) {
                this.release(caller);
                this.map_.removeReader(caller);
                String errStr = "upgrade lock for " + this.getFqn() + " could not be acquired after " + timeout + " ms." + " Lock map ownership " + this.map_.printInfo() + " (caller=" + caller + ", lock info: " + this.toString(true) + ')';
                log.trace((Object)errStr);
                throw new UpgradeException(errStr);
            }
            try {
                if (trace) {
                    log.trace((Object)("upgrading lock for " + this.getFqn()));
                }
                this.map_.upgrade(caller);
            }
            catch (OwnerNotExistedException ex) {
                throw new UpgradeException("Can't upgrade lock to WL for " + this.getFqn() + ", error in LockMap.upgrade(): " + ex);
            }
        }
        boolean rc = this.lock_.writeLock().attempt(timeout);
        if (!rc) {
            String errStr = "write lock for " + this.getFqn() + " could not be acquired after " + timeout + " ms. " + "Locks: " + this.map_.printInfo() + " (caller=" + caller + ", lock info: " + this.toString(true) + ')';
            log.trace((Object)errStr);
            throw new TimeoutException(errStr);
        }
        this.map_.setWriterIfNotNull(caller);
        return true;
    }

    public boolean acquireReadLock(Object caller, long timeout) throws LockingException, TimeoutException, InterruptedException {
        if (caller == null) {
            throw new IllegalArgumentException("owner is null");
        }
        boolean hasRead = false;
        boolean hasRequired = false;
        if (this.mustReacquireRead_) {
            hasRequired = this.map_.isOwner(caller, 2);
            if (!hasRequired) {
                hasRead = this.map_.isOwner(caller, 1);
            }
        } else if (this.map_.isOwner(caller, 0)) {
            hasRequired = true;
        }
        if (hasRequired) {
            if (trace) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("acquireReadLock(): caller ").append(caller).append(" already owns lock for ").append(this.getFqn());
                log.trace((Object)sb.toString());
            }
            return false;
        }
        boolean rc = this.lock_.readLock().attempt(timeout);
        if (!rc) {
            StringBuffer sb = new StringBuffer();
            sb.append("read lock for ").append(this.getFqn()).append(" could not be acquired by ").append(caller);
            sb.append(" after ").append(timeout).append(" ms. Locks: ").append(this.map_.printInfo());
            sb.append(", lock info: ").append(this.toString(true));
            String errMsg = sb.toString();
            log.trace((Object)errMsg);
            throw new TimeoutException(errMsg);
        }
        if (!hasRead) {
            this.map_.addReader(caller);
        }
        return true;
    }

    public void release(Object caller) {
        if (caller == null) {
            throw new IllegalArgumentException("IdentityLock.release(): null owner object.");
        }
        if (this.map_.isOwner(caller, 1)) {
            this.map_.removeReader(caller);
            this.lock_.readLock().release();
        } else if (this.map_.isOwner(caller, 2)) {
            this.map_.removeWriter();
            this.lock_.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        try {
            if (this.map_.writerOwner() != null) {
                this.lock_.writeLock().release();
            }
            this.map_.releaseReaderOwners(this.lock_);
        }
        finally {
            this.map_.removeAll();
        }
    }

    public void releaseForce() {
        this.releaseAll();
    }

    public boolean isReadLocked() {
        return this.map_.isReadLocked();
    }

    public boolean isWriteLocked() {
        return this.map_.writerOwner() != null;
    }

    public boolean isLocked() {
        return this.isReadLocked() || this.isWriteLocked();
    }

    public boolean isOwner(Object o) {
        return this.map_.isOwner(o, 0);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean print_lock_details) {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, print_lock_details);
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
        this.toString(sb, false);
    }

    public void toString(StringBuffer sb, boolean print_lock_details) {
        Object write_owner;
        Collection read_owners;
        boolean printed_read_owners = false;
        Collection collection = read_owners = this.lock_ != null ? this.getReaderOwners() : null;
        if (read_owners != null && read_owners.size() > 0) {
            Iterator iter = read_owners.iterator();
            read_owners = new ArrayList(read_owners.size());
            while (iter.hasNext()) {
                read_owners.add(iter.next());
            }
            sb.append("read owners=").append(read_owners);
            printed_read_owners = true;
        } else {
            read_owners = null;
        }
        Object object = write_owner = this.lock_ != null ? this.getWriterOwner() : null;
        if (write_owner != null) {
            if (printed_read_owners) {
                sb.append(", ");
            }
            sb.append("write owner=").append(write_owner);
        }
        if (read_owners == null && write_owner == null) {
            sb.append("<unlocked>");
        }
        if (print_lock_details) {
            sb.append(" (").append(this.lock_.toString()).append(')');
        }
    }
}

