/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionNameConflictException;

public class RegionManager {
    private Log log_ = LogFactory.getLog((Class)RegionManager.class);
    private final Map regionMap_ = new ConcurrentHashMap();
    private int longestFqn = 0;

    public Region createRegion(String fqn, ClassLoader cl) throws RegionNameConflictException {
        return this.createRegion(fqn, cl, false);
    }

    public Region createRegion(String fqn, ClassLoader cl, boolean inactive) throws RegionNameConflictException {
        return this.createRegion(Fqn.fromString(fqn), cl, inactive);
    }

    public Region createRegion(Fqn fqn, ClassLoader cl, boolean inactive) throws RegionNameConflictException {
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("createRegion(): creating region for fqn- " + fqn));
        }
        this.checkConflict(fqn);
        Region region = new Region(fqn.toString() + "/", cl, inactive);
        this.regionMap_.put(fqn, region);
        this.longestFqn = Math.max(this.longestFqn, fqn.size());
        return region;
    }

    public void removeRegion(String fqn) {
        this.removeRegion(Fqn.fromString(fqn));
    }

    public boolean removeRegion(Fqn fqn) {
        Region region = (Region)this.regionMap_.remove(fqn);
        return region != null;
    }

    public boolean hasRegion(String myFqn) {
        return this.hasRegion(Fqn.fromString(myFqn));
    }

    public boolean hasRegion(Fqn fqn) {
        return this.regionMap_.containsKey(fqn);
    }

    public Region getRegion(String myFqn) {
        return this.getRegion(Fqn.fromString(myFqn));
    }

    public Region getRegion(Fqn fqn) {
        Fqn orig = fqn;
        if (fqn.size() > this.longestFqn) {
            fqn = fqn.getFqnChild(0, this.longestFqn);
        }
        do {
            Region region;
            if ((region = (Region)this.regionMap_.get(fqn)) == null) continue;
            return region;
        } while (!(fqn = fqn.getParent()).isRoot());
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("getRegion(): user-specified region not found: " + orig));
        }
        return null;
    }

    public Region[] getRegions() {
        TreeSet s = new TreeSet(new RegionComparator());
        Iterator i = this.regionMap_.values().iterator();
        while (i.hasNext()) {
            s.add(i.next());
        }
        return s.toArray(new Region[0]);
    }

    public void checkConflict(String myFqn) throws RegionNameConflictException {
        this.checkConflict(Fqn.fromString(myFqn));
    }

    public void checkConflict(Fqn fqn) throws RegionNameConflictException {
        for (int i = 0; i < fqn.size(); ++i) {
            Fqn child = fqn.getFqnChild(i);
            if (!this.regionMap_.containsKey(child)) continue;
            throw new RegionNameConflictException("RegionManager.checkConflict(): new region fqn " + fqn + " is in conflict with existing region fqn " + child);
        }
    }

    public void setUnmarshallingClassLoader(Fqn subtree) {
        Region region;
        ClassLoader regionCL;
        if (subtree.isChildOf(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)) {
            subtree = subtree.size() <= 2 ? Fqn.ROOT : subtree.getFqnChild(2, subtree.size());
        }
        ClassLoader classLoader = regionCL = (region = this.getRegion(subtree)) == null ? null : region.getClassLoader();
        if (regionCL != null) {
            Thread.currentThread().setContextClassLoader(regionCL);
        }
    }

    static class RegionComparator
    implements Comparator {
        RegionComparator() {
        }

        public int compare(Object o1, Object o2) {
            Region r1 = (Region)o1;
            Region r2 = (Region)o2;
            String f1 = r1.getFqn();
            String f2 = r2.getFqn();
            return f1.compareTo(f2);
        }
    }
}

