/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Map;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.VersionedNode;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.optimistic.WorkspaceNodeImpl;

public class NodeFactory {
    private CacheSPI cache;
    private boolean optimistic;

    public NodeFactory(CacheSPI cache) {
        this.cache = cache;
        this.init();
    }

    public void init() {
        this.optimistic = this.cache.getConfiguration().isNodeLockingOptimistic();
    }

    public NodeSPI createDataNode(Object childName, Fqn fqn, NodeSPI parent, Map data, boolean mapSafe) {
        return this.optimistic ? new VersionedNode(fqn, parent, data, this.cache) : new UnversionedNode(childName, fqn, data, mapSafe, this.cache);
    }

    public Node createNode(Object childName, Node parent, Map data) {
        return this.createNodeOfType(parent, childName, parent, data);
    }

    public Node createNodeOfType(Node template, Object childName, Node parent, Map data) {
        if (template instanceof WorkspaceNode) {
            NodeSPI dataNodeParent = ((WorkspaceNode)parent).getNode();
            TransactionWorkspace workspace = ((WorkspaceNode)template).getTransactionWorkspace();
            return this.createWorkspaceNode(dataNodeParent, workspace);
        }
        return this.createDataNode(childName, new Fqn<Object>(parent.getFqn(), childName), (NodeSPI)parent, data, false);
    }

    public WorkspaceNode createWorkspaceNode(NodeSPI dataNode, TransactionWorkspace workspace) {
        return new WorkspaceNodeImpl(dataNode, workspace);
    }

    public NodeSPI createRootDataNode() {
        return this.createDataNode(null, Fqn.ROOT, null, null, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        UNVERSIONED_NODE,
        VERSIONED_NODE,
        WORKSPACE_NODE;

    }
}

