/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.xml.XmlHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLoaderConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = 2210349340378984424L;
    private boolean passivation;
    private String preload;
    private List<IndividualCacheLoaderConfig> cacheLoaderConfigs = new ArrayList<IndividualCacheLoaderConfig>();
    private boolean shared;

    public String getPreload() {
        return this.preload;
    }

    public void setPreload(String preload) {
        this.testImmutability("preload");
        this.preload = preload;
    }

    public void setPassivation(boolean passivation) {
        this.testImmutability("passivation");
        this.passivation = passivation;
    }

    public boolean isPassivation() {
        return this.passivation;
    }

    public void addIndividualCacheLoaderConfig(IndividualCacheLoaderConfig clc) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs.add(clc);
        this.addChildConfig(clc);
    }

    public List<IndividualCacheLoaderConfig> getIndividualCacheLoaderConfigs() {
        return this.cacheLoaderConfigs;
    }

    public void setIndividualCacheLoaderConfigs(List<IndividualCacheLoaderConfig> configs) {
        this.testImmutability("cacheLoaderConfigs");
        this.replaceChildConfigs(this.cacheLoaderConfigs, configs);
        this.cacheLoaderConfigs = configs == null ? new ArrayList() : configs;
    }

    public IndividualCacheLoaderConfig getFirstCacheLoaderConfig() {
        if (this.cacheLoaderConfigs.size() == 0) {
            return null;
        }
        return this.cacheLoaderConfigs.get(0);
    }

    public boolean useChainingCacheLoader() {
        return !this.isPassivation() && this.cacheLoaderConfigs.size() > 1;
    }

    public String toString() {
        return new StringBuffer().append("CacheLoaderConfig{").append("shared=").append(this.shared).append(", passivation=").append(this.passivation).append(", preload='").append(this.preload).append('\'').append(", cacheLoaderConfigs.size()=").append(this.cacheLoaderConfigs.size()).append('}').toString();
    }

    public void setShared(boolean shared) {
        this.testImmutability("shared");
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CacheLoaderConfig) {
            CacheLoaderConfig other = (CacheLoaderConfig)obj;
            return this.passivation == other.passivation && this.shared == other.shared && CacheLoaderConfig.safeEquals(this.preload, other.preload) && CacheLoaderConfig.safeEquals(this.cacheLoaderConfigs, other.cacheLoaderConfigs);
        }
        return false;
    }

    public int hashCode() {
        int result = 19;
        result = 51 * result + (this.passivation ? 0 : 1);
        result = 51 * result + (this.shared ? 0 : 1);
        result = 51 * result + (this.preload == null ? 0 : this.preload.hashCode());
        result = 51 * result + (this.cacheLoaderConfigs == null ? 0 : ((Object)this.cacheLoaderConfigs).hashCode());
        return result;
    }

    public static class IndividualCacheLoaderConfig
    extends ConfigurationComponent {
        private static final long serialVersionUID = -2282396799100828593L;
        private String className;
        private boolean async;
        private boolean ignoreModifications;
        private boolean fetchPersistentState;
        private boolean singletonStore;
        private boolean pushStateWhenCoordinator;
        private boolean purgeOnStartup;
        private Properties properties;

        protected void populateFromBaseConfig(IndividualCacheLoaderConfig base) {
            if (base != null) {
                this.setAsync(base.isAsync());
                this.setIgnoreModifications(base.isIgnoreModifications());
                this.setFetchPersistentState(base.isFetchPersistentState());
                this.setSingletonStore(base.isSingletonStore());
                this.setPushStateWhenCoordinator(base.isPushStateWhenCoordinator());
                this.setPurgeOnStartup(base.isPurgeOnStartup());
                Properties props = base.getProperties();
                if (props != null) {
                    this.setProperties(props);
                }
            }
        }

        public boolean isPurgeOnStartup() {
            return this.purgeOnStartup;
        }

        public boolean isFetchPersistentState() {
            return this.fetchPersistentState;
        }

        public void setFetchPersistentState(boolean fetchPersistentState) {
            this.testImmutability("fetchPersistentState");
            this.fetchPersistentState = fetchPersistentState;
        }

        public void setClassName(String className) {
            this.testImmutability("className");
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setAsync(boolean async) {
            this.testImmutability("async");
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }

        public void setIgnoreModifications(boolean ignoreModifications) {
            this.testImmutability("ignoreModifications");
            this.ignoreModifications = ignoreModifications;
        }

        public boolean isIgnoreModifications() {
            return this.ignoreModifications;
        }

        public void setProperties(String properties) throws IOException {
            if (properties == null) {
                return;
            }
            this.testImmutability("properties");
            properties = XmlHelper.escapeBackslashes(properties);
            ByteArrayInputStream is = new ByteArrayInputStream(properties.trim().getBytes("ISO8859_1"));
            this.properties = new Properties();
            this.properties.load(is);
            is.close();
        }

        public void setProperties(Properties properties) {
            this.testImmutability("properties");
            this.properties = properties;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setPurgeOnStartup(boolean purgeOnStartup) {
            this.testImmutability("purgeOnStartup");
            this.purgeOnStartup = purgeOnStartup;
        }

        public boolean isSingletonStore() {
            return this.singletonStore;
        }

        public void setSingletonStore(boolean singletonStore) {
            this.testImmutability("singletonStore");
            this.singletonStore = singletonStore;
        }

        public boolean isPushStateWhenCoordinator() {
            return this.pushStateWhenCoordinator;
        }

        public void setPushStateWhenCoordinator(boolean pushStateWhenCoordinator) {
            this.testImmutability("pushStateWhenCoordinator");
            if (this.singletonStore) {
                this.pushStateWhenCoordinator = pushStateWhenCoordinator;
            }
        }

        public boolean equals(Object obj) {
            return this.equalsExcludingProperties(obj) && IndividualCacheLoaderConfig.safeEquals(this.properties, ((IndividualCacheLoaderConfig)obj).properties);
        }

        protected boolean equalsExcludingProperties(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IndividualCacheLoaderConfig) {
                IndividualCacheLoaderConfig other = (IndividualCacheLoaderConfig)obj;
                return IndividualCacheLoaderConfig.safeEquals(this.className, other.className) && this.async == other.async && this.ignoreModifications == other.ignoreModifications && this.fetchPersistentState == other.fetchPersistentState && this.singletonStore == other.singletonStore && this.pushStateWhenCoordinator == other.pushStateWhenCoordinator;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.hashCodeExcludingProperties() + (this.properties == null ? 0 : this.properties.hashCode());
        }

        protected int hashCodeExcludingProperties() {
            int result = 17;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.async ? 0 : 1);
            result = 31 * result + (this.ignoreModifications ? 0 : 1);
            result = 31 * result + (this.fetchPersistentState ? 0 : 1);
            result = 31 * result + (this.singletonStore ? 0 : 1);
            result = 31 * result + (this.pushStateWhenCoordinator ? 0 : 1);
            result = 31 * result + (this.purgeOnStartup ? 0 : 1);
            return result;
        }

        public String toString() {
            return new StringBuffer().append("IndividualCacheLoaderConfig{").append("className='").append(this.className).append('\'').append(", async=").append(this.async).append(", ignoreModifications=").append(this.ignoreModifications).append(", fetchPersistentState=").append(this.fetchPersistentState).append(", properties=").append(this.properties).append('}').append(", purgeOnStartup=").append(this.purgeOnStartup).append(", singletonStore=").append(this.singletonStore).append(", singletonStore.pushStateWhenCoordinator=").append(this.pushStateWhenCoordinator).toString();
        }
    }
}

