/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.EvictionPolicyConfig;

public class EvictionRegionConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = -5482474634995601400L;
    public static final String NAME = "name";
    public static final String REGION = "region";
    public static final String REGION_POLICY_CLASS = "policyClass";
    public static final String EVENT_QUEUE_SIZE = "eventQueueSize";
    private Fqn regionFqn;
    @Dynamic
    private Integer eventQueueSize;
    private EvictionPolicyConfig evictionPolicyConfig;

    public EvictionPolicyConfig getEvictionPolicyConfig() {
        return this.evictionPolicyConfig;
    }

    public void setEvictionPolicyConfig(EvictionPolicyConfig config) {
        this.testImmutability("evictionPolicyConfig");
        if (this.evictionPolicyConfig instanceof ConfigurationComponent) {
            this.removeChildConfig((ConfigurationComponent)((Object)this.evictionPolicyConfig));
        }
        if (config instanceof ConfigurationComponent) {
            this.addChildConfig((ConfigurationComponent)((Object)config));
        }
        if (config != null) {
            config.validate();
        }
        this.evictionPolicyConfig = config;
    }

    public Fqn getRegionFqn() {
        return this.regionFqn;
    }

    public void setRegionFqn(Fqn regionFqn) {
        this.testImmutability("regionFqn");
        this.regionFqn = regionFqn;
    }

    public String getRegionName() {
        return this.regionFqn == null ? null : this.regionFqn.toString();
    }

    public void setRegionName(String name) {
        this.setRegionFqn(name == null ? null : Fqn.fromString(name));
    }

    public int getEventQueueSize() {
        return this.eventQueueSize == null ? 200000 : this.eventQueueSize;
    }

    public void setEventQueueSize(int queueSize) {
        this.testImmutability(EVENT_QUEUE_SIZE);
        if (queueSize <= 0) {
            LogFactory.getLog(EvictionRegionConfig.class).warn((Object)("Ignoring invalid queue capacity " + queueSize + " -- using " + 200000));
            queueSize = 200000;
        }
        this.eventQueueSize = queueSize;
    }

    public void setDefaultEventQueueSize(int queueSize) {
        if (this.eventQueueSize == null) {
            this.setEventQueueSize(queueSize);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvictionRegionConfig) {
            EvictionRegionConfig other = (EvictionRegionConfig)obj;
            return EvictionRegionConfig.safeEquals(this.regionFqn, other.regionFqn);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.regionFqn == null ? 0 : this.regionFqn.hashCode());
        return result;
    }
}

