/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractCacheListener;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Region;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.notifications.Notifier;

public class EvictionTimerTask {
    private Log log = LogFactory.getLog(EvictionTimerTask.class);
    private final Set<Region> processedRegions = Collections.synchronizedSet(new HashSet());
    private int wakeupIntervalSeconds;

    public void init(int wakeupIntervalSeconds, Notifier notifier) {
        this.wakeupIntervalSeconds = wakeupIntervalSeconds;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating a new eviction listener with wakeupIntervalSeconds set at " + wakeupIntervalSeconds));
        }
        EvictionListener l = new EvictionListener();
        notifier.setEvictionPolicyListener(l);
    }

    public void addRegionToProcess(Region region) {
        this.processedRegions.add(region);
    }

    public void removeRegionToProcess(Region region) {
        this.processedRegions.remove(region);
    }

    public boolean isRegionRegisteredForProcessing(Region region) {
        return this.processedRegions.contains(region);
    }

    class EvictionListener
    extends AbstractCacheListener {
        private Log log = LogFactory.getLog(EvictionListener.class);
        private Timer evictionThread;

        EvictionListener() {
        }

        public void cacheStarted(CacheSPI cache) {
            this.evictionThread = new Timer(true);
            TimerTask tt = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Set set = EvictionTimerTask.this.processedRegions;
                    synchronized (set) {
                        for (Region region : EvictionTimerTask.this.processedRegions) {
                            EvictionPolicy policy = region.getEvictionPolicy();
                            Region region2 = region;
                            synchronized (region2) {
                                EvictionAlgorithm algo = policy.getEvictionAlgorithm();
                                if (algo == null) {
                                    throw new NullPointerException("algorithm null");
                                }
                                try {
                                    algo.process(region);
                                }
                                catch (EvictionException e) {
                                    EvictionListener.this.log.error((Object)("run(): error processing eviction with exception: " + e.toString() + " will reset the eviction queue list."));
                                    region.resetEvictionQueues();
                                    EvictionListener.this.log.debug((Object)"trace", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            };
            this.evictionThread.schedule(tt, EvictionTimerTask.this.wakeupIntervalSeconds * 1000, (long)(EvictionTimerTask.this.wakeupIntervalSeconds * 1000));
        }

        public void cacheStopped(CacheSPI cache) {
            this.log.debug((Object)"Stopping eviction timer");
            if (this.evictionThread != null) {
                this.evictionThread.cancel();
            }
            this.evictionThread = null;
        }
    }
}

