/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;

public class BaseCacheLoaderInterceptor
extends Interceptor {
    protected CacheLoader loader = null;
    private Map lockMap = new ConcurrentHashMap();

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoaderManager().getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void obtainLoaderLock(Object lock) throws InterruptedException {
        Thread current = Thread.currentThread();
        BaseCacheLoaderInterceptor baseCacheLoaderInterceptor = this;
        synchronized (baseCacheLoaderInterceptor) {
            while (this.lockMap.containsKey(lock) && !this.lockMap.get(lock).equals(current)) {
                this.wait();
            }
            if (this.lockMap.containsKey(lock) && !this.lockMap.get(lock).equals(current)) {
                throw new ConcurrentModificationException("Loader lock " + lock + " is already held by someone else.");
            }
            this.lockMap.put(lock, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLoaderLock(Object lock) {
        BaseCacheLoaderInterceptor baseCacheLoaderInterceptor = this;
        synchronized (baseCacheLoaderInterceptor) {
            this.lockMap.remove(lock);
            this.notify();
        }
    }

    protected void releaseLoaderLocks(List locks) {
        for (Object lock : locks) {
            this.releaseLoaderLock(lock);
        }
    }

    protected void obtainLoaderLocks(List locks) throws InterruptedException {
        for (Object lock : locks) {
            this.obtainLoaderLock(lock);
        }
    }
}

