/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;

public class CreateIfNotExistsInterceptor
extends Interceptor {
    private final ReentrantLock put_lock = new ReentrantLock();
    private final ReentrantLock remove_lock = new ReentrantLock();
    private final ArrayList put_list = new ArrayList();
    private final ArrayList remove_list = new ArrayList();

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        boolean isEvict;
        boolean isPut = MethodDeclarations.isPutMethod(m.getMethodId());
        boolean isRemove = m.getMethodId() == 5;
        boolean bl = isEvict = m.getMethodId() == 8;
        if (isPut || isRemove || isEvict) {
            Object[] args = m.getArgs();
            Fqn fqn = (Fqn)(args != null ? (isEvict ? args[0] : args[1]) : null);
            if (fqn == null) {
                throw new CacheException("failed extracting FQN from method " + (Object)((Object)m));
            }
            if (isPut) {
                try {
                    this.addFqnToPutList(fqn, this.put_lock);
                    this.findAndBlockOnRemove(fqn, this.remove_lock);
                    if (this.cache.peek(fqn, false) == null) {
                        GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("creating node " + fqn));
                        }
                        this.createNode(fqn, gtx);
                    }
                    Object object = super.invoke(m);
                    return object;
                }
                finally {
                    this.removeFqnFromPutList(fqn, this.put_lock);
                }
            }
            try {
                this.findAndBlockOnPut(fqn, this.put_lock);
                this.addFqnToRemoveList(fqn, this.remove_lock);
                this.put_lock.unlock();
                Object object = super.invoke(m);
                return object;
            }
            finally {
                if (this.put_lock.isHeldByCurrentThread()) {
                    this.put_lock.unlock();
                }
                this.removeFqnFromRemoveList(fqn, this.remove_lock);
            }
        }
        return super.invoke(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAndBlockOnPut(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        while (true) {
            lock.lockInterruptibly();
            Fqn tmp = this.findFqnInPutList(fqn);
            if (tmp == null) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("found " + tmp + " in put-list, waiting"));
            }
            Fqn fqn2 = tmp;
            synchronized (fqn2) {
                lock.unlock();
                tmp.wait();
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("wait() for put-list on " + tmp + " got notified"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAndBlockOnRemove(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        while (true) {
            lock.lockInterruptibly();
            try {
                Fqn tmp = this.findFqnInRemoveList(fqn);
                if (tmp == null) {
                    return;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("found " + tmp + " in remove-list, waiting"));
                }
                Fqn fqn2 = tmp;
                synchronized (fqn2) {
                    lock.unlock();
                    tmp.wait();
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("wait() for remove-list on " + tmp + " got notified"));
                continue;
            }
            finally {
                lock.unlock();
                continue;
            }
            break;
        }
    }

    private Fqn findFqnInPutList(Fqn fqn) {
        for (Fqn tmp : this.put_list) {
            if (!tmp.isChildOf(fqn) && !tmp.equals(fqn)) continue;
            return tmp;
        }
        return null;
    }

    private Fqn findFqnInRemoveList(Fqn fqn) {
        for (Fqn tmp : this.remove_list) {
            if (!fqn.isChildOf(tmp) && !fqn.equals(tmp)) continue;
            return tmp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFqnToPutList(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        lock.lockInterruptibly();
        try {
            if (!this.put_list.contains(fqn)) {
                this.put_list.add(fqn);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("adding " + fqn + " to put-list (size=" + this.put_list.size() + ")"));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFqnToRemoveList(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        lock.lockInterruptibly();
        try {
            if (!this.remove_list.contains(fqn)) {
                this.remove_list.add(fqn);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("adding " + fqn + " to remove-list (size=" + this.remove_list.size() + ")"));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFqnFromPutList(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        lock.lockInterruptibly();
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removing " + fqn + " from put-list (size=" + this.put_list.size() + ")"));
            }
            this.put_list.remove(fqn);
            lock.unlock();
            Fqn fqn2 = fqn;
            synchronized (fqn2) {
                fqn.notifyAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFqnFromRemoveList(Fqn fqn, ReentrantLock lock) throws InterruptedException {
        lock.lockInterruptibly();
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removing " + fqn + " from remove-list (size=" + this.remove_list.size() + ")"));
            }
            this.remove_list.remove(fqn);
            lock.unlock();
            Fqn fqn2 = fqn;
            synchronized (fqn2) {
                fqn.notifyAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNode(Fqn fqn, GlobalTransaction tx) {
        Fqn<Object> tmp_fqn = Fqn.ROOT;
        if (fqn == null) {
            return;
        }
        CreateIfNotExistsInterceptor createIfNotExistsInterceptor = this;
        synchronized (createIfNotExistsInterceptor) {
            int treeNodeSize = fqn.size();
            NodeSPI n = this.cache.getRoot();
            for (int i = 0; i < treeNodeSize; ++i) {
                Object child_name = fqn.get(i);
                tmp_fqn = new Fqn<Object>(tmp_fqn, child_name);
                NodeSPI child_node = n.getChildDirect(child_name);
                if (child_node == null) {
                    child_node = n.addChildDirect(new Fqn<Object>(child_name));
                    if (tx != null) {
                        MethodCall undo_op = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, tx, tmp_fqn, false);
                        ((CacheImpl)this.cache).addUndoOperation(tx, undo_op);
                    }
                    this.cache.getNotifier().notifyNodeCreated(tmp_fqn, true, true);
                    this.cache.getNotifier().notifyNodeCreated(tmp_fqn, false, true);
                }
                n = child_node;
            }
        }
    }
}

