/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptorMBean;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;

public class InvocationContextInterceptor
extends BaseTransactionalContextInterceptor
implements InvocationContextInterceptorMBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall call) throws Throwable {
        boolean resumeSuspended;
        Transaction suspendedTransaction;
        InvocationContext ctx;
        block17: {
            Object object;
            ctx = this.cache.getInvocationContext();
            Option optionOverride = ctx.getOptionOverrides();
            suspendedTransaction = null;
            resumeSuspended = false;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Invoked on cache instance [" + this.cache.getLocalAddress() + "] and InvocationContext [" + ctx + "]"));
            }
            try {
                Transaction tx = this.getTransaction();
                this.setTransactionalContext(tx, this.getGlobalTransaction(tx, call));
                if (optionOverride == null) break block17;
                if (optionOverride.isFailSilently()) {
                    this.log.debug((Object)"FAIL_SILENTLY Option is present - suspending any ongoing transaction.");
                    if (ctx.getTransaction() != null) {
                        suspendedTransaction = this.txManager.suspend();
                        this.setTransactionalContext(null, null);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Suspending transaction " + suspendedTransaction));
                        }
                        resumeSuspended = true;
                    } else {
                        this.log.trace((Object)"No ongoing transaction to suspend");
                    }
                }
                if (!optionOverride.isBypassInterceptorChain()) break block17;
                this.log.trace((Object)"Interceptor chain bypass option set for call; skipping interceptor chain and proceeding to last interceptor.");
                object = this.getLast().invoke(call);
            }
            catch (Throwable throwable) {
                this.log.trace((Object)"Resetting invocation-scope options");
                this.cache.getInvocationContext().getOptionOverrides().reset();
                if (resumeSuspended) {
                    this.txManager.resume(suspendedTransaction);
                } else if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
                    this.copyInvocationScopeOptionsToTxScope(ctx);
                }
                throw throwable;
            }
            this.log.trace((Object)"Resetting invocation-scope options");
            this.cache.getInvocationContext().getOptionOverrides().reset();
            if (resumeSuspended) {
                this.txManager.resume(suspendedTransaction);
            } else if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
                this.copyInvocationScopeOptionsToTxScope(ctx);
            }
            return object;
        }
        Object object = super.invoke(call);
        this.log.trace((Object)"Resetting invocation-scope options");
        this.cache.getInvocationContext().getOptionOverrides().reset();
        if (resumeSuspended) {
            this.txManager.resume(suspendedTransaction);
        } else if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
            this.copyInvocationScopeOptionsToTxScope(ctx);
        }
        return object;
    }

    private GlobalTransaction getGlobalTransaction(Transaction tx, MethodCall call) {
        GlobalTransaction gtx = null;
        if (MethodDeclarations.isTransactionLifecycleMethod(call.getMethodId())) {
            gtx = this.findGlobalTransaction(call.getArgs());
            gtx.setRemote(this.isRemoteGlobalTx(gtx));
        } else {
            gtx = this.cache.getCurrentTransaction(tx, false);
        }
        return gtx;
    }

    private Transaction getTransaction() throws SystemException {
        if (this.txManager == null) {
            this.log.trace((Object)"no transaction manager configured, setting tx as null.");
            return null;
        }
        return this.txManager.getTransaction();
    }

    protected GlobalTransaction findGlobalTransaction(Object[] params) {
        int clue = 0;
        if (params[clue] instanceof GlobalTransaction) {
            return (GlobalTransaction)params[clue];
        }
        for (Object param : params) {
            if (!(param instanceof GlobalTransaction)) continue;
            return (GlobalTransaction)param;
        }
        return null;
    }

    private boolean isRemoteGlobalTx(GlobalTransaction gtx) {
        return gtx != null && gtx.getAddress() != null && !gtx.getAddress().equals(this.cache.getLocalAddress());
    }
}

